/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.redismock;

import ai.grakn.redismock.Slice;
import ai.grakn.redismock.SliceParser;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Response {
    private static final Logger LOG = LoggerFactory.getLogger(Response.class);
    private static final String LINE_SEPARATOR = "\r\n";
    public static final Slice OK = new Slice("+OK\r\n");
    public static final Slice NULL = new Slice("$-1\r\n");
    public static final Slice SKIP = new Slice("Skip this submission");

    private Response() {
    }

    public static Slice bulkString(Slice s) {
        if (s == null) {
            return NULL;
        }
        ByteArrayDataOutput bo = ByteStreams.newDataOutput();
        bo.write(String.format("$%d%s", s.length(), LINE_SEPARATOR).getBytes());
        bo.write(s.data());
        bo.write(LINE_SEPARATOR.getBytes());
        return new Slice(bo.toByteArray());
    }

    public static Slice error(String s) {
        return new Slice(String.format("-%s%s", s, LINE_SEPARATOR));
    }

    public static Slice integer(long v) {
        return new Slice(String.format(":%d%s", v, LINE_SEPARATOR));
    }

    public static Slice array(List<Slice> values) {
        ByteArrayDataOutput bo = ByteStreams.newDataOutput();
        bo.write(String.format("*%d%s", values.size(), LINE_SEPARATOR).getBytes());
        for (Slice value : values) {
            bo.write(value.data());
        }
        return new Slice(bo.toByteArray());
    }

    public static Slice publishedMessage(Slice channel, Slice message) {
        Slice operation = SliceParser.consumeParameter("$7\r\nmessage\r\n".getBytes());
        ArrayList<Slice> slices = new ArrayList<Slice>();
        slices.add(Response.bulkString(operation));
        slices.add(Response.bulkString(channel));
        slices.add(Response.bulkString(message));
        return Response.array(slices);
    }

    public static Slice subscribedToChannel(List<Slice> channels) {
        Slice operation = SliceParser.consumeParameter("$9\r\nsubscribe\r\n".getBytes());
        ArrayList<Slice> slices = new ArrayList<Slice>();
        slices.add(Response.bulkString(operation));
        channels.forEach(channel -> slices.add(Response.bulkString(channel)));
        slices.add(Response.integer(channels.size()));
        return Response.array(slices);
    }

    public static Slice unsubscribe(Slice channel, int remainingSubscriptions) {
        Slice operation = SliceParser.consumeParameter("$11\r\nunsubscribe\r\n".getBytes());
        ArrayList<Slice> slices = new ArrayList<Slice>();
        slices.add(Response.bulkString(operation));
        slices.add(Response.bulkString(channel));
        slices.add(Response.integer(remainingSubscriptions));
        return Response.array(slices);
    }

    public static Slice clientResponse(String command, Slice response) {
        String stringResponse = response.toString().replace("\n", "").replace("\r", "");
        if (!response.equals(SKIP)) {
            LOG.debug("Received command [" + command + "] sending reply [" + stringResponse + "]");
        }
        return response;
    }
}

