/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.par;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.util.par.LibPar;
import org.lwjgl.util.par.ParShapesMesh;

public class ParShapes {
    protected ParShapes() {
        throw new UnsupportedOperationException();
    }

    public static native void npar_shapes_free_mesh(long var0);

    public static void par_shapes_free_mesh(@NativeType(value="par_shapes_mesh *") ParShapesMesh mesh) {
        ParShapes.npar_shapes_free_mesh(mesh.address());
    }

    public static native long npar_shapes_create_cylinder(int var0, int var1);

    @Nullable
    @NativeType(value="par_shapes_mesh *")
    public static ParShapesMesh par_shapes_create_cylinder(int slices, int stacks) {
        long __result = ParShapes.npar_shapes_create_cylinder(slices, stacks);
        return ParShapesMesh.createSafe(__result);
    }

    public static native long npar_shapes_create_torus(int var0, int var1, float var2);

    @Nullable
    @NativeType(value="par_shapes_mesh *")
    public static ParShapesMesh par_shapes_create_torus(int slices, int stacks, float radius) {
        long __result = ParShapes.npar_shapes_create_torus(slices, stacks, radius);
        return ParShapesMesh.createSafe(__result);
    }

    public static native long npar_shapes_create_parametric_sphere(int var0, int var1);

    @Nullable
    @NativeType(value="par_shapes_mesh *")
    public static ParShapesMesh par_shapes_create_parametric_sphere(int slices, int stacks) {
        long __result = ParShapes.npar_shapes_create_parametric_sphere(slices, stacks);
        return ParShapesMesh.createSafe(__result);
    }

    public static native long npar_shapes_create_subdivided_sphere(int var0);

    @Nullable
    @NativeType(value="par_shapes_mesh *")
    public static ParShapesMesh par_shapes_create_subdivided_sphere(int nsubdivisions) {
        long __result = ParShapes.npar_shapes_create_subdivided_sphere(nsubdivisions);
        return ParShapesMesh.createSafe(__result);
    }

    public static native long npar_shapes_create_klein_bottle(int var0, int var1);

    @Nullable
    @NativeType(value="par_shapes_mesh *")
    public static ParShapesMesh par_shapes_create_klein_bottle(int slices, int stacks) {
        long __result = ParShapes.npar_shapes_create_klein_bottle(slices, stacks);
        return ParShapesMesh.createSafe(__result);
    }

    public static native long npar_shapes_create_trefoil_knot(int var0, int var1, float var2);

    @Nullable
    @NativeType(value="par_shapes_mesh *")
    public static ParShapesMesh par_shapes_create_trefoil_knot(int slices, int stacks, float radius) {
        long __result = ParShapes.npar_shapes_create_trefoil_knot(slices, stacks, radius);
        return ParShapesMesh.createSafe(__result);
    }

    public static native long npar_shapes_create_hemisphere(int var0, int var1);

    @Nullable
    @NativeType(value="par_shapes_mesh *")
    public static ParShapesMesh par_shapes_create_hemisphere(int slices, int stacks) {
        long __result = ParShapes.npar_shapes_create_hemisphere(slices, stacks);
        return ParShapesMesh.createSafe(__result);
    }

    public static native long npar_shapes_create_plane(int var0, int var1);

    @Nullable
    @NativeType(value="par_shapes_mesh *")
    public static ParShapesMesh par_shapes_create_plane(int slices, int stacks) {
        long __result = ParShapes.npar_shapes_create_plane(slices, stacks);
        return ParShapesMesh.createSafe(__result);
    }

    public static native long npar_shapes_create_icosahedron();

    @Nullable
    @NativeType(value="par_shapes_mesh *")
    public static ParShapesMesh par_shapes_create_icosahedron() {
        long __result = ParShapes.npar_shapes_create_icosahedron();
        return ParShapesMesh.createSafe(__result);
    }

    public static native long npar_shapes_create_dodecahedron();

    @Nullable
    @NativeType(value="par_shapes_mesh *")
    public static ParShapesMesh par_shapes_create_dodecahedron() {
        long __result = ParShapes.npar_shapes_create_dodecahedron();
        return ParShapesMesh.createSafe(__result);
    }

    public static native long npar_shapes_create_octahedron();

    @Nullable
    @NativeType(value="par_shapes_mesh *")
    public static ParShapesMesh par_shapes_create_octahedron() {
        long __result = ParShapes.npar_shapes_create_octahedron();
        return ParShapesMesh.createSafe(__result);
    }

    public static native long npar_shapes_create_tetrahedron();

    @Nullable
    @NativeType(value="par_shapes_mesh *")
    public static ParShapesMesh par_shapes_create_tetrahedron() {
        long __result = ParShapes.npar_shapes_create_tetrahedron();
        return ParShapesMesh.createSafe(__result);
    }

    public static native long npar_shapes_create_cube();

    @Nullable
    @NativeType(value="par_shapes_mesh *")
    public static ParShapesMesh par_shapes_create_cube() {
        long __result = ParShapes.npar_shapes_create_cube();
        return ParShapesMesh.createSafe(__result);
    }

    public static native long npar_shapes_create_disk(float var0, int var1, long var2, long var4);

    @Nullable
    @NativeType(value="par_shapes_mesh *")
    public static ParShapesMesh par_shapes_create_disk(float radius, int slices, @NativeType(value="float const *") FloatBuffer center, @NativeType(value="float const *") FloatBuffer normal) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)center, (int)3);
            Checks.check((Buffer)normal, (int)3);
        }
        long __result = ParShapes.npar_shapes_create_disk(radius, slices, MemoryUtil.memAddress((FloatBuffer)center), MemoryUtil.memAddress((FloatBuffer)normal));
        return ParShapesMesh.createSafe(__result);
    }

    public static native long npar_shapes_create_empty();

    @Nullable
    @NativeType(value="par_shapes_mesh *")
    public static ParShapesMesh par_shapes_create_empty() {
        long __result = ParShapes.npar_shapes_create_empty();
        return ParShapesMesh.createSafe(__result);
    }

    public static native long npar_shapes_create_rock(int var0, int var1);

    @Nullable
    @NativeType(value="par_shapes_mesh *")
    public static ParShapesMesh par_shapes_create_rock(int seed, int nsubdivisions) {
        long __result = ParShapes.npar_shapes_create_rock(seed, nsubdivisions);
        return ParShapesMesh.createSafe(__result);
    }

    public static native long npar_shapes_create_lsystem(long var0, int var2, int var3);

    @Nullable
    @NativeType(value="par_shapes_mesh *")
    public static ParShapesMesh par_shapes_create_lsystem(@NativeType(value="char const *") ByteBuffer program, int slices, int maxdepth) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)program);
        }
        long __result = ParShapes.npar_shapes_create_lsystem(MemoryUtil.memAddress((ByteBuffer)program), slices, maxdepth);
        return ParShapesMesh.createSafe(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="par_shapes_mesh *")
    public static ParShapesMesh par_shapes_create_lsystem(@NativeType(value="char const *") CharSequence program, int slices, int maxdepth) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(program, true);
            long programEncoded = stack.getPointerAddress();
            long __result = ParShapes.npar_shapes_create_lsystem(programEncoded, slices, maxdepth);
            ParShapesMesh parShapesMesh = ParShapesMesh.createSafe(__result);
            return parShapesMesh;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void npar_shapes_export(long var0, long var2);

    public static void par_shapes_export(@NativeType(value="par_shapes_mesh const *") ParShapesMesh mesh, @NativeType(value="char const *") ByteBuffer objfile) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)objfile);
        }
        ParShapes.npar_shapes_export(mesh.address(), MemoryUtil.memAddress((ByteBuffer)objfile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void par_shapes_export(@NativeType(value="par_shapes_mesh const *") ParShapesMesh mesh, @NativeType(value="char const *") CharSequence objfile) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(objfile, true);
            long objfileEncoded = stack.getPointerAddress();
            ParShapes.npar_shapes_export(mesh.address(), objfileEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void npar_shapes_compute_aabb(long var0, long var2);

    public static void par_shapes_compute_aabb(@NativeType(value="par_shapes_mesh const *") ParShapesMesh mesh, @NativeType(value="float *") FloatBuffer aabb) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)aabb, (int)6);
        }
        ParShapes.npar_shapes_compute_aabb(mesh.address(), MemoryUtil.memAddress((FloatBuffer)aabb));
    }

    public static native long npar_shapes_clone(long var0, long var2);

    @Nullable
    @NativeType(value="par_shapes_mesh *")
    public static ParShapesMesh par_shapes_clone(@NativeType(value="par_shapes_mesh const *") ParShapesMesh mesh, @Nullable @NativeType(value="par_shapes_mesh *") ParShapesMesh target) {
        long __result = ParShapes.npar_shapes_clone(mesh.address(), MemoryUtil.memAddressSafe((Pointer)target));
        return ParShapesMesh.createSafe(__result);
    }

    public static native void npar_shapes_merge(long var0, long var2);

    public static void par_shapes_merge(@NativeType(value="par_shapes_mesh *") ParShapesMesh dst, @NativeType(value="par_shapes_mesh const *") ParShapesMesh src) {
        ParShapes.npar_shapes_merge(dst.address(), src.address());
    }

    public static native void npar_shapes_translate(long var0, float var2, float var3, float var4);

    public static void par_shapes_translate(@NativeType(value="par_shapes_mesh *") ParShapesMesh mesh, float x, float y, float z) {
        ParShapes.npar_shapes_translate(mesh.address(), x, y, z);
    }

    public static native void npar_shapes_rotate(long var0, float var2, long var3);

    public static void par_shapes_rotate(@NativeType(value="par_shapes_mesh *") ParShapesMesh mesh, float radians, @NativeType(value="float const *") FloatBuffer axis) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)axis, (int)3);
        }
        ParShapes.npar_shapes_rotate(mesh.address(), radians, MemoryUtil.memAddress((FloatBuffer)axis));
    }

    public static native void npar_shapes_scale(long var0, float var2, float var3, float var4);

    public static void par_shapes_scale(@NativeType(value="par_shapes_mesh *") ParShapesMesh mesh, float x, float y, float z) {
        ParShapes.npar_shapes_scale(mesh.address(), x, y, z);
    }

    public static native void npar_shapes_merge_and_free(long var0, long var2);

    public static void par_shapes_merge_and_free(@NativeType(value="par_shapes_mesh *") ParShapesMesh dst, @NativeType(value="par_shapes_mesh *") ParShapesMesh src) {
        ParShapes.npar_shapes_merge_and_free(dst.address(), src.address());
    }

    public static native void npar_shapes_invert(long var0, int var2, int var3);

    public static void par_shapes_invert(@NativeType(value="par_shapes_mesh *") ParShapesMesh mesh, int startface, int nfaces) {
        ParShapes.npar_shapes_invert(mesh.address(), startface, nfaces);
    }

    public static native void npar_shapes_remove_degenerate(long var0, float var2);

    public static void par_shapes_remove_degenerate(@NativeType(value="par_shapes_mesh *") ParShapesMesh mesh, float minarea) {
        ParShapes.npar_shapes_remove_degenerate(mesh.address(), minarea);
    }

    public static native void npar_shapes_unweld(long var0, boolean var2);

    public static void par_shapes_unweld(@NativeType(value="par_shapes_mesh *") ParShapesMesh mesh, @NativeType(value="bool") boolean create_indices) {
        ParShapes.npar_shapes_unweld(mesh.address(), create_indices);
    }

    public static native long npar_shapes_weld(long var0, float var2, long var3);

    @Nullable
    @NativeType(value="par_shapes_mesh *")
    public static ParShapesMesh par_shapes_weld(@NativeType(value="par_shapes_mesh const *") ParShapesMesh mesh, float epsilon, @Nullable @NativeType(value="PAR_SHAPES_T *") IntBuffer mapping) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)mapping, (int)mesh.npoints());
        }
        long __result = ParShapes.npar_shapes_weld(mesh.address(), epsilon, MemoryUtil.memAddressSafe((IntBuffer)mapping));
        return ParShapesMesh.createSafe(__result);
    }

    public static native void npar_shapes_compute_normals(long var0);

    public static void par_shapes_compute_normals(@NativeType(value="par_shapes_mesh *") ParShapesMesh mesh) {
        ParShapes.npar_shapes_compute_normals(mesh.address());
    }

    public static native long npar_shapes_create_disk(float var0, int var1, float[] var2, float[] var3);

    @Nullable
    @NativeType(value="par_shapes_mesh *")
    public static ParShapesMesh par_shapes_create_disk(float radius, int slices, @NativeType(value="float const *") float[] center, @NativeType(value="float const *") float[] normal) {
        if (Checks.CHECKS) {
            Checks.check((float[])center, (int)3);
            Checks.check((float[])normal, (int)3);
        }
        long __result = ParShapes.npar_shapes_create_disk(radius, slices, center, normal);
        return ParShapesMesh.createSafe(__result);
    }

    public static native void npar_shapes_compute_aabb(long var0, float[] var2);

    public static void par_shapes_compute_aabb(@NativeType(value="par_shapes_mesh const *") ParShapesMesh mesh, @NativeType(value="float *") float[] aabb) {
        if (Checks.CHECKS) {
            Checks.check((float[])aabb, (int)6);
        }
        ParShapes.npar_shapes_compute_aabb(mesh.address(), aabb);
    }

    public static native void npar_shapes_rotate(long var0, float var2, float[] var3);

    public static void par_shapes_rotate(@NativeType(value="par_shapes_mesh *") ParShapesMesh mesh, float radians, @NativeType(value="float const *") float[] axis) {
        if (Checks.CHECKS) {
            Checks.check((float[])axis, (int)3);
        }
        ParShapes.npar_shapes_rotate(mesh.address(), radians, axis);
    }

    public static native long npar_shapes_weld(long var0, float var2, int[] var3);

    @Nullable
    @NativeType(value="par_shapes_mesh *")
    public static ParShapesMesh par_shapes_weld(@NativeType(value="par_shapes_mesh const *") ParShapesMesh mesh, float epsilon, @Nullable @NativeType(value="PAR_SHAPES_T *") int[] mapping) {
        if (Checks.CHECKS) {
            Checks.checkSafe((int[])mapping, (int)mesh.npoints());
        }
        long __result = ParShapes.npar_shapes_weld(mesh.address(), epsilon, mapping);
        return ParShapesMesh.createSafe(__result);
    }

    static {
        LibPar.initialize();
    }
}

