/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitDirLocator {
    @Nullable
    public File lookupGitDirectory(MavenProject project, File manualyConfiguredDir) throws MojoExecutionException {
        if (GitDirLocator.isExistingDirectory(manualyConfiguredDir)) {
            return manualyConfiguredDir;
        }
        for (MavenProject mavenProject = project; mavenProject != null; mavenProject = mavenProject.getParent()) {
            File dir = this.currentProjectGitDir(mavenProject);
            if (GitDirLocator.isExistingDirectory(dir)) {
                return dir;
            }
            if (mavenProject.getBasedir() == null || !GitDirLocator.isExistingDirectory(dir = new File(mavenProject.getBasedir().getParentFile(), ".git"))) continue;
            return dir;
        }
        return null;
    }

    @NotNull
    private File currentProjectGitDir(@NotNull MavenProject mavenProject) {
        return new File(mavenProject.getBasedir(), ".git");
    }

    public static boolean isExistingDirectory(@Nullable File fileLocation) {
        return fileLocation != null && fileLocation.exists() && fileLocation.isDirectory();
    }
}

