/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkFramebufferAttachmentImageInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int USAGE;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int LAYERCOUNT;
    public static final int VIEWFORMATCOUNT;
    public static final int PVIEWFORMATS;

    public VkFramebufferAttachmentImageInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkFramebufferAttachmentImageInfoKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkFramebufferAttachmentImageInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkFramebufferAttachmentImageInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkImageCreateFlags")
    public int flags() {
        return VkFramebufferAttachmentImageInfoKHR.nflags(this.address());
    }

    @NativeType(value="VkImageUsageFlags")
    public int usage() {
        return VkFramebufferAttachmentImageInfoKHR.nusage(this.address());
    }

    @NativeType(value="uint32_t")
    public int width() {
        return VkFramebufferAttachmentImageInfoKHR.nwidth(this.address());
    }

    @NativeType(value="uint32_t")
    public int height() {
        return VkFramebufferAttachmentImageInfoKHR.nheight(this.address());
    }

    @NativeType(value="uint32_t")
    public int layerCount() {
        return VkFramebufferAttachmentImageInfoKHR.nlayerCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int viewFormatCount() {
        return VkFramebufferAttachmentImageInfoKHR.nviewFormatCount(this.address());
    }

    @Nullable
    @NativeType(value="VkFormat const *")
    public IntBuffer pViewFormats() {
        return VkFramebufferAttachmentImageInfoKHR.npViewFormats(this.address());
    }

    public VkFramebufferAttachmentImageInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkFramebufferAttachmentImageInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkFramebufferAttachmentImageInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkFramebufferAttachmentImageInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkFramebufferAttachmentImageInfoKHR flags(@NativeType(value="VkImageCreateFlags") int value) {
        VkFramebufferAttachmentImageInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkFramebufferAttachmentImageInfoKHR usage(@NativeType(value="VkImageUsageFlags") int value) {
        VkFramebufferAttachmentImageInfoKHR.nusage(this.address(), value);
        return this;
    }

    public VkFramebufferAttachmentImageInfoKHR width(@NativeType(value="uint32_t") int value) {
        VkFramebufferAttachmentImageInfoKHR.nwidth(this.address(), value);
        return this;
    }

    public VkFramebufferAttachmentImageInfoKHR height(@NativeType(value="uint32_t") int value) {
        VkFramebufferAttachmentImageInfoKHR.nheight(this.address(), value);
        return this;
    }

    public VkFramebufferAttachmentImageInfoKHR layerCount(@NativeType(value="uint32_t") int value) {
        VkFramebufferAttachmentImageInfoKHR.nlayerCount(this.address(), value);
        return this;
    }

    public VkFramebufferAttachmentImageInfoKHR pViewFormats(@Nullable @NativeType(value="VkFormat const *") IntBuffer value) {
        VkFramebufferAttachmentImageInfoKHR.npViewFormats(this.address(), value);
        return this;
    }

    public VkFramebufferAttachmentImageInfoKHR set(int sType, long pNext, int flags, int usage, int width, int height, int layerCount, @Nullable IntBuffer pViewFormats) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.usage(usage);
        this.width(width);
        this.height(height);
        this.layerCount(layerCount);
        this.pViewFormats(pViewFormats);
        return this;
    }

    public VkFramebufferAttachmentImageInfoKHR set(VkFramebufferAttachmentImageInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkFramebufferAttachmentImageInfoKHR malloc() {
        return (VkFramebufferAttachmentImageInfoKHR)VkFramebufferAttachmentImageInfoKHR.wrap(VkFramebufferAttachmentImageInfoKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkFramebufferAttachmentImageInfoKHR calloc() {
        return (VkFramebufferAttachmentImageInfoKHR)VkFramebufferAttachmentImageInfoKHR.wrap(VkFramebufferAttachmentImageInfoKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkFramebufferAttachmentImageInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkFramebufferAttachmentImageInfoKHR)VkFramebufferAttachmentImageInfoKHR.wrap(VkFramebufferAttachmentImageInfoKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkFramebufferAttachmentImageInfoKHR create(long address) {
        return (VkFramebufferAttachmentImageInfoKHR)VkFramebufferAttachmentImageInfoKHR.wrap(VkFramebufferAttachmentImageInfoKHR.class, (long)address);
    }

    @Nullable
    public static VkFramebufferAttachmentImageInfoKHR createSafe(long address) {
        return address == 0L ? null : (VkFramebufferAttachmentImageInfoKHR)VkFramebufferAttachmentImageInfoKHR.wrap(VkFramebufferAttachmentImageInfoKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkFramebufferAttachmentImageInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkFramebufferAttachmentImageInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkFramebufferAttachmentImageInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkFramebufferAttachmentImageInfoKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkFramebufferAttachmentImageInfoKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkFramebufferAttachmentImageInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkFramebufferAttachmentImageInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkFramebufferAttachmentImageInfoKHR mallocStack() {
        return VkFramebufferAttachmentImageInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkFramebufferAttachmentImageInfoKHR callocStack() {
        return VkFramebufferAttachmentImageInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkFramebufferAttachmentImageInfoKHR mallocStack(MemoryStack stack) {
        return (VkFramebufferAttachmentImageInfoKHR)VkFramebufferAttachmentImageInfoKHR.wrap(VkFramebufferAttachmentImageInfoKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkFramebufferAttachmentImageInfoKHR callocStack(MemoryStack stack) {
        return (VkFramebufferAttachmentImageInfoKHR)VkFramebufferAttachmentImageInfoKHR.wrap(VkFramebufferAttachmentImageInfoKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkFramebufferAttachmentImageInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkFramebufferAttachmentImageInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkFramebufferAttachmentImageInfoKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkFramebufferAttachmentImageInfoKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nusage(long struct) {
        return UNSAFE.getInt(null, struct + (long)USAGE);
    }

    public static int nwidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return UNSAFE.getInt(null, struct + (long)HEIGHT);
    }

    public static int nlayerCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)LAYERCOUNT);
    }

    public static int nviewFormatCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)VIEWFORMATCOUNT);
    }

    @Nullable
    public static IntBuffer npViewFormats(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PVIEWFORMATS)), (int)VkFramebufferAttachmentImageInfoKHR.nviewFormatCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nusage(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)USAGE, value);
    }

    public static void nwidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HEIGHT, value);
    }

    public static void nlayerCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LAYERCOUNT, value);
    }

    public static void nviewFormatCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VIEWFORMATCOUNT, value);
    }

    public static void npViewFormats(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PVIEWFORMATS), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        VkFramebufferAttachmentImageInfoKHR.nviewFormatCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkFramebufferAttachmentImageInfoKHR.nviewFormatCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PVIEWFORMATS)));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkFramebufferAttachmentImageInfoKHR.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkFramebufferAttachmentImageInfoKHR.__struct((Struct.Member[])new Struct.Member[]{VkFramebufferAttachmentImageInfoKHR.__member((int)4), VkFramebufferAttachmentImageInfoKHR.__member((int)POINTER_SIZE), VkFramebufferAttachmentImageInfoKHR.__member((int)4), VkFramebufferAttachmentImageInfoKHR.__member((int)4), VkFramebufferAttachmentImageInfoKHR.__member((int)4), VkFramebufferAttachmentImageInfoKHR.__member((int)4), VkFramebufferAttachmentImageInfoKHR.__member((int)4), VkFramebufferAttachmentImageInfoKHR.__member((int)4), VkFramebufferAttachmentImageInfoKHR.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        USAGE = layout.offsetof(3);
        WIDTH = layout.offsetof(4);
        HEIGHT = layout.offsetof(5);
        LAYERCOUNT = layout.offsetof(6);
        VIEWFORMATCOUNT = layout.offsetof(7);
        PVIEWFORMATS = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkFramebufferAttachmentImageInfoKHR, Buffer>
    implements NativeResource {
        private static final VkFramebufferAttachmentImageInfoKHR ELEMENT_FACTORY = VkFramebufferAttachmentImageInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkFramebufferAttachmentImageInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkFramebufferAttachmentImageInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkFramebufferAttachmentImageInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkImageCreateFlags")
        public int flags() {
            return VkFramebufferAttachmentImageInfoKHR.nflags(this.address());
        }

        @NativeType(value="VkImageUsageFlags")
        public int usage() {
            return VkFramebufferAttachmentImageInfoKHR.nusage(this.address());
        }

        @NativeType(value="uint32_t")
        public int width() {
            return VkFramebufferAttachmentImageInfoKHR.nwidth(this.address());
        }

        @NativeType(value="uint32_t")
        public int height() {
            return VkFramebufferAttachmentImageInfoKHR.nheight(this.address());
        }

        @NativeType(value="uint32_t")
        public int layerCount() {
            return VkFramebufferAttachmentImageInfoKHR.nlayerCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int viewFormatCount() {
            return VkFramebufferAttachmentImageInfoKHR.nviewFormatCount(this.address());
        }

        @Nullable
        @NativeType(value="VkFormat const *")
        public IntBuffer pViewFormats() {
            return VkFramebufferAttachmentImageInfoKHR.npViewFormats(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkFramebufferAttachmentImageInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkFramebufferAttachmentImageInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkImageCreateFlags") int value) {
            VkFramebufferAttachmentImageInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer usage(@NativeType(value="VkImageUsageFlags") int value) {
            VkFramebufferAttachmentImageInfoKHR.nusage(this.address(), value);
            return this;
        }

        public Buffer width(@NativeType(value="uint32_t") int value) {
            VkFramebufferAttachmentImageInfoKHR.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(@NativeType(value="uint32_t") int value) {
            VkFramebufferAttachmentImageInfoKHR.nheight(this.address(), value);
            return this;
        }

        public Buffer layerCount(@NativeType(value="uint32_t") int value) {
            VkFramebufferAttachmentImageInfoKHR.nlayerCount(this.address(), value);
            return this;
        }

        public Buffer pViewFormats(@Nullable @NativeType(value="VkFormat const *") IntBuffer value) {
            VkFramebufferAttachmentImageInfoKHR.npViewFormats(this.address(), value);
            return this;
        }
    }
}

