/*
 * Copyright LWJGL. All rights reserved.
 * License terms: https://www.lwjgl.org/license
 * MACHINE GENERATED FILE, DO NOT EDIT
 */
package org.lwjgl.vulkan;

/**
 * This extension adds support for the following SPIR-V extension in Vulkan:
 * 
 * <ul>
 * <li>{@code SPV_KHR_subgroup_vote}</li>
 * </ul>
 * 
 * <p>This extension provides new SPIR-V instructions:</p>
 * 
 * <ul>
 * <li>{@code OpSubgroupAllKHR},</li>
 * <li>{@code OpSubgroupAnyKHR}, and</li>
 * <li>{@code OpSubgroupAllEqualKHR}.</li>
 * </ul>
 * 
 * <p>to compute the composite of a set of boolean conditions across a group of shader invocations that are running concurrently (a <em>subgroup</em>). These composite results may be used to execute shaders more efficiently on a {@code VkPhysicalDevice}.</p>
 * 
 * <p>When using GLSL source-based shader languages, the following shader functions from GL_ARB_shader_group_vote can map to these SPIR-V instructions:</p>
 * 
 * <ul>
 * <li>{@code anyInvocationARB}() &#8594; {@code OpSubgroupAnyKHR},</li>
 * <li>{@code allInvocationsARB}() &#8594; {@code OpSubgroupAllKHR}, and</li>
 * <li>{@code allInvocationsEqualARB}() &#8594; {@code OpSubgroupAllEqualKHR}.</li>
 * </ul>
 * 
 * <p>The subgroup across which the boolean conditions are evaluated is implementation-dependent, and this extension provides no guarantee over how individual shader invocations are assigned to subgroups. In particular, a subgroup has no necessary relationship with the compute shader <em>local workgroup</em> -- any pair of shader invocations in a compute local workgroup may execute in different subgroups as used by these instructions.</p>
 * 
 * <p>Compute shaders operate on an explicitly specified group of threads (a local workgroup), but many implementations will also group non-compute shader invocations and execute them concurrently. When executing code like</p>
 * 
 * <pre><code>
 * if (condition) {
 *   result = do_fast_path();
 * } else {
 *   result = do_general_path();
 * }</code></pre>
 * 
 * <p>where {@code condition} diverges between invocations, an implementation might first execute {@code do_fast_path}() for the invocations where {@code condition} is true and leave the other invocations dormant. Once {@code do_fast_path}() returns, it might call {@code do_general_path}() for invocations where {@code condition} is {@code false} and leave the other invocations dormant. In this case, the shader executes <b>both</b> the fast and the general path and might be better off just using the general path for all invocations.</p>
 * 
 * <p>This extension provides the ability to avoid divergent execution by evaluating a condition across an entire subgroup using code like:</p>
 * 
 * <pre><code>
 * if (allInvocationsARB(condition)) {
 *   result = do_fast_path();
 * } else {
 *   result = do_general_path();
 * }</code></pre>
 * 
 * <p>The built-in function {@code allInvocationsARB}() will return the same value for all invocations in the group, so the group will either execute {@code do_fast_path}() or {@code do_general_path}(), but never both. For example, shader code might want to evaluate a complex function iteratively by starting with an approximation of the result and then refining the approximation. Some input values may require a small number of iterations to generate an accurate result ({@code do_fast_path}) while others require a larger number ({@code do_general_path}). In another example, shader code might want to evaluate a complex function ({@code do_general_path}) that can be greatly simplified when assuming a specific value for one of its inputs ({@code do_fast_path}).</p>
 * 
 * <dl>
 * <dt><b>Name String</b></dt>
 * <dd>{@code VK_EXT_shader_subgroup_vote}</dd>
 * <dt><b>Extension Type</b></dt>
 * <dd>Device extension</dd>
 * <dt><b>Registered Extension Number</b></dt>
 * <dd>66</dd>
 * <dt><b>Revision</b></dt>
 * <dd>1</dd>
 * <dt><b>Extension and Version Dependencies</b></dt>
 * <dd><ul>
 * <li>Requires Vulkan 1.0</li>
 * </ul></dd>
 * <dt><b>Contact</b></dt>
 * <dd><ul>
 * <li>Daniel Koch <a target="_blank" href="https://github.com/KhronosGroup/Vulkan-Docs/issues/new?title=VK_EXT_shader_subgroup_vote:%20&amp;body=@dgkoch%20">dgkoch</a></li>
 * </ul></dd>
 * <dt><b>Last Modified Date</b></dt>
 * <dd>2016-11-28</dd>
 * <dt><b>IP Status</b></dt>
 * <dd>No known IP claims.</dd>
 * <dt><b>Interactions and External Dependencies</b></dt>
 * <dd><ul>
 * <li>This extension requires the <a target="_blank" href="https://htmlpreview.github.io/?https://github.com/KhronosGroup/SPIRV-Registry/blob/master/extensions/KHR/SPV_KHR_subgroup_vote.html">{@code SPV_KHR_subgroup_vote}</a> SPIR-V extension.</li>
 * <li>This extension requires the <a target="_blank" href="https://www.khronos.org/registry/OpenGL/extensions/ARB/ARB_shader_group_vote.txt">{@code GL_ARB_shader_group_vote}</a> extension for GLSL source languages.</li>
 * </ul></dd>
 * <dt><b>Contributors</b></dt>
 * <dd><ul>
 * <li>Neil Henning, Codeplay</li>
 * <li>Daniel Koch, NVIDIA Corporation</li>
 * </ul></dd>
 * </dl>
 */
public final class EXTShaderSubgroupVote {

    /** The extension specification version. */
    public static final int VK_EXT_SHADER_SUBGROUP_VOTE_SPEC_VERSION = 1;

    /** The extension name. */
    public static final String VK_EXT_SHADER_SUBGROUP_VOTE_EXTENSION_NAME = "VK_EXT_shader_subgroup_vote";

    private EXTShaderSubgroupVote() {}

}