/*
 * Copyright LWJGL. All rights reserved.
 * License terms: https://www.lwjgl.org/license
 * MACHINE GENERATED FILE, DO NOT EDIT
 */
package org.lwjgl.vulkan;

/**
 * This extension adds support for using half float variables in shaders.
 * 
 * <h5>Deprecation by VK_KHR_shader_float16_int8</h5>
 * 
 * <p>Functionality in this extension was included in <a target="_blank" href="https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VK_KHR_shader_float16_int8">VK_KHR_shader_float16_int8</a> extension, when slink::VkPhysicalDeviceShaderFloat16Int8FeaturesKHR{@code ::shaderFloat16} is enabled.</p>
 * 
 * <dl>
 * <dt><b>Name String</b></dt>
 * <dd>{@code VK_AMD_gpu_shader_half_float}</dd>
 * <dt><b>Extension Type</b></dt>
 * <dd>Device extension</dd>
 * <dt><b>Registered Extension Number</b></dt>
 * <dd>37</dd>
 * <dt><b>Revision</b></dt>
 * <dd>2</dd>
 * <dt><b>Extension and Version Dependencies</b></dt>
 * <dd><ul>
 * <li>Requires Vulkan 1.0</li>
 * </ul></dd>
 * <dt><b>Deprecation state</b></dt>
 * <dd><ul>
 * <li><em>Deprecated</em> by <a target="_blank" href="https://www.khronos.org/registry/vulkan/specs/1.1-extensions/html/vkspec.html#VK_KHR_shader_float16_int8">VK_KHR_shader_float16_int8</a> extension</li>
 * </ul></dd>
 * <dt><b>Contact</b></dt>
 * <dd><ul>
 * <li>Dominik Witczak <a target="_blank" href="https://github.com/KhronosGroup/Vulkan-Docs/issues/new?title=VK_AMD_gpu_shader_half_float:%20&amp;body=@dominikwitczakamd%20">dominikwitczakamd</a></li>
 * </ul></dd>
 * <dt><b>Last Modified Date</b></dt>
 * <dd>2019-04-11</dd>
 * <dt><b>IP Status</b></dt>
 * <dd>No known IP claims.</dd>
 * <dt><b>Contributors</b></dt>
 * <dd><ul>
 * <li>Daniel Rakos, AMD</li>
 * <li>Dominik Witczak, AMD</li>
 * <li>Donglin Wei, AMD</li>
 * <li>Graham Sellers, AMD</li>
 * <li>Qun Lin, AMD</li>
 * <li>Rex Xu, AMD</li>
 * </ul></dd>
 * <dt><b>External Dependencies</b></dt>
 * <dd><ul>
 * <li><a target="_blank" href="https://htmlpreview.github.io/?https://github.com/KhronosGroup/SPIRV-Registry/blob/master/extensions/AMD/SPV_AMD_gpu_shader_half_float.html">{@code SPV_AMD_gpu_shader_half_float}</a></li>
 * </ul></dd>
 * </dl>
 */
public final class AMDGPUShaderHalfFloat {

    /** The extension specification version. */
    public static final int VK_AMD_GPU_SHADER_HALF_FLOAT_SPEC_VERSION = 2;

    /** The extension name. */
    public static final String VK_AMD_GPU_SHADER_HALF_FLOAT_EXTENSION_NAME = "VK_AMD_gpu_shader_half_float";

    private AMDGPUShaderHalfFloat() {}

}