/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.WGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class WGLNVDXInterop {
    public static final int WGL_ACCESS_READ_ONLY_NV = 0;
    public static final int WGL_ACCESS_READ_WRITE_NV = 1;
    public static final int WGL_ACCESS_WRITE_DISCARD_NV = 2;

    protected WGLNVDXInterop() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(WGLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.wglDXSetResourceShareHandleNV, caps.wglDXOpenDeviceNV, caps.wglDXCloseDeviceNV, caps.wglDXRegisterObjectNV, caps.wglDXUnregisterObjectNV, caps.wglDXObjectAccessNV, caps.wglDXLockObjectsNV, caps.wglDXUnlockObjectsNV});
    }

    public static boolean wglDXSetResourceShareHandleNV(long dxObject, long shareHandle) {
        long __functionAddress = GL.getCapabilitiesWGL().wglDXSetResourceShareHandleNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)dxObject);
            Checks.check((long)shareHandle);
        }
        return JNI.callPPI((long)__functionAddress, (long)dxObject, (long)shareHandle) != 0;
    }

    public static long wglDXOpenDeviceNV(long dxDevice) {
        long __functionAddress = GL.getCapabilitiesWGL().wglDXOpenDeviceNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)dxDevice);
        }
        return JNI.callPP((long)__functionAddress, (long)dxDevice);
    }

    public static boolean wglDXCloseDeviceNV(long device) {
        long __functionAddress = GL.getCapabilitiesWGL().wglDXCloseDeviceNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)device);
        }
        return JNI.callPI((long)__functionAddress, (long)device) != 0;
    }

    public static long wglDXRegisterObjectNV(long device, long dxResource, int name, int type, int access) {
        long __functionAddress = GL.getCapabilitiesWGL().wglDXRegisterObjectNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)device);
            Checks.check((long)dxResource);
        }
        return JNI.callPPP((long)__functionAddress, (long)device, (long)dxResource, (int)name, (int)type, (int)access);
    }

    public static boolean wglDXUnregisterObjectNV(long device, long object) {
        long __functionAddress = GL.getCapabilitiesWGL().wglDXUnregisterObjectNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)device);
            Checks.check((long)object);
        }
        return JNI.callPPI((long)__functionAddress, (long)device, (long)object) != 0;
    }

    public static boolean wglDXObjectAccessNV(long object, int access) {
        long __functionAddress = GL.getCapabilitiesWGL().wglDXObjectAccessNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)object);
        }
        return JNI.callPI((long)__functionAddress, (long)object, (int)access) != 0;
    }

    public static int nwglDXLockObjectsNV(long device, int count, long objects) {
        long __functionAddress = GL.getCapabilitiesWGL().wglDXLockObjectsNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)device);
        }
        return JNI.callPPI((long)__functionAddress, (long)device, (int)count, (long)objects);
    }

    public static boolean wglDXLockObjectsNV(long device, PointerBuffer objects) {
        return WGLNVDXInterop.nwglDXLockObjectsNV(device, objects.remaining(), MemoryUtil.memAddress((CustomBuffer)objects)) != 0;
    }

    public static int nwglDXUnlockObjectsNV(long device, int count, long objects) {
        long __functionAddress = GL.getCapabilitiesWGL().wglDXUnlockObjectsNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)device);
        }
        return JNI.callPPI((long)__functionAddress, (long)device, (int)count, (long)objects);
    }

    public static boolean wglDXUnlockObjectsNV(long device, PointerBuffer objects) {
        return WGLNVDXInterop.nwglDXUnlockObjectsNV(device, objects.remaining(), MemoryUtil.memAddress((CustomBuffer)objects)) != 0;
    }
}

