/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class NVTransformFeedback {
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_NV = 35982;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_START_NV = 35972;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_NV = 35973;
    public static final int GL_TRANSFORM_FEEDBACK_RECORD_NV = 35974;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_NV = 35983;
    public static final int GL_INTERLEAVED_ATTRIBS_NV = 35980;
    public static final int GL_SEPARATE_ATTRIBS_NV = 35981;
    public static final int GL_PRIMITIVES_GENERATED_NV = 35975;
    public static final int GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_NV = 35976;
    public static final int GL_RASTERIZER_DISCARD_NV = 35977;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_NV = 35978;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_NV = 35979;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_NV = 35968;
    public static final int GL_TRANSFORM_FEEDBACK_ATTRIBS_NV = 35966;
    public static final int GL_ACTIVE_VARYINGS_NV = 35969;
    public static final int GL_ACTIVE_VARYING_MAX_LENGTH_NV = 35970;
    public static final int GL_TRANSFORM_FEEDBACK_VARYINGS_NV = 35971;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_MODE_NV = 35967;
    public static final int GL_BACK_PRIMARY_COLOR_NV = 35959;
    public static final int GL_BACK_SECONDARY_COLOR_NV = 35960;
    public static final int GL_TEXTURE_COORD_NV = 35961;
    public static final int GL_CLIP_DISTANCE_NV = 35962;
    public static final int GL_VERTEX_ID_NV = 35963;
    public static final int GL_PRIMITIVE_ID_NV = 35964;
    public static final int GL_GENERIC_ATTRIB_NV = 35965;
    public static final int GL_SECONDARY_COLOR_NV = 34093;
    public static final int GL_LAYER_NV = 36266;

    protected NVTransformFeedback() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glBeginTransformFeedbackNV, caps.glEndTransformFeedbackNV, caps.glTransformFeedbackAttribsNV, caps.glBindBufferRangeNV, caps.glBindBufferOffsetNV, caps.glBindBufferBaseNV, caps.glTransformFeedbackVaryingsNV, caps.glActiveVaryingNV, caps.glGetVaryingLocationNV, caps.glGetActiveVaryingNV, caps.glGetTransformFeedbackVaryingNV, caps.glTransformFeedbackStreamAttribsNV});
    }

    public static native void glBeginTransformFeedbackNV(int var0);

    public static native void glEndTransformFeedbackNV();

    public static native void nglTransformFeedbackAttribsNV(int var0, long var1, int var3);

    public static void glTransformFeedbackAttribsNV(IntBuffer attribs, int bufferMode) {
        NVTransformFeedback.nglTransformFeedbackAttribsNV(attribs.remaining(), MemoryUtil.memAddress((IntBuffer)attribs), bufferMode);
    }

    public static native void glBindBufferRangeNV(int var0, int var1, int var2, long var3, long var5);

    public static native void glBindBufferOffsetNV(int var0, int var1, int var2, long var3);

    public static native void glBindBufferBaseNV(int var0, int var1, int var2);

    public static native void nglTransformFeedbackVaryingsNV(int var0, int var1, long var2, int var4);

    public static void glTransformFeedbackVaryingsNV(int program, IntBuffer locations, int bufferMode) {
        NVTransformFeedback.nglTransformFeedbackVaryingsNV(program, locations.remaining(), MemoryUtil.memAddress((IntBuffer)locations), bufferMode);
    }

    public static native void nglActiveVaryingNV(int var0, long var1);

    public static void glActiveVaryingNV(int program, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        NVTransformFeedback.nglActiveVaryingNV(program, MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glActiveVaryingNV(int program, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            NVTransformFeedback.nglActiveVaryingNV(program, MemoryUtil.memAddress((ByteBuffer)nameEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nglGetVaryingLocationNV(int var0, long var1);

    public static int glGetVaryingLocationNV(int program, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return NVTransformFeedback.nglGetVaryingLocationNV(program, MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetVaryingLocationNV(int program, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = NVTransformFeedback.nglGetVaryingLocationNV(program, MemoryUtil.memAddress((ByteBuffer)nameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetActiveVaryingNV(int var0, int var1, int var2, long var3, long var5, long var7, long var9);

    public static void glGetActiveVaryingNV(int program, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)1);
            Checks.check((Buffer)size, (int)1);
            Checks.check((Buffer)type, (int)1);
        }
        NVTransformFeedback.nglGetActiveVaryingNV(program, index, name.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((IntBuffer)size), MemoryUtil.memAddress((IntBuffer)type), MemoryUtil.memAddress((ByteBuffer)name));
    }

    public static native void nglGetTransformFeedbackVaryingNV(int var0, int var1, long var2);

    public static void glGetTransformFeedbackVaryingNV(int program, int index, IntBuffer location) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)location, (int)1);
        }
        NVTransformFeedback.nglGetTransformFeedbackVaryingNV(program, index, MemoryUtil.memAddress((IntBuffer)location));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetTransformFeedbackVaryingNV(int program, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer location = stack.callocInt(1);
            NVTransformFeedback.nglGetTransformFeedbackVaryingNV(program, index, MemoryUtil.memAddress((IntBuffer)location));
            int n = location.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglTransformFeedbackStreamAttribsNV(int var0, long var1, int var3, long var4, int var6);

    public static void glTransformFeedbackStreamAttribsNV(IntBuffer attribs, IntBuffer bufstreams, int bufferMode) {
        NVTransformFeedback.nglTransformFeedbackStreamAttribsNV(attribs.remaining(), MemoryUtil.memAddress((IntBuffer)attribs), bufstreams.remaining(), MemoryUtil.memAddress((IntBuffer)bufstreams), bufferMode);
    }

    public static void glTransformFeedbackAttribsNV(int[] attribs, int bufferMode) {
        long __functionAddress = GL.getICD().glTransformFeedbackAttribsNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)attribs.length, (int[])attribs, (int)bufferMode);
    }

    public static void glTransformFeedbackVaryingsNV(int program, int[] locations, int bufferMode) {
        long __functionAddress = GL.getICD().glTransformFeedbackVaryingsNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)locations.length, (int[])locations, (int)bufferMode);
    }

    public static void glGetActiveVaryingNV(int program, int index, int[] length, int[] size, int[] type, ByteBuffer name) {
        long __functionAddress = GL.getICD().glGetActiveVaryingNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])length, (int)1);
            Checks.check((int[])size, (int)1);
            Checks.check((int[])type, (int)1);
        }
        JNI.callPPPPV((long)__functionAddress, (int)program, (int)index, (int)name.remaining(), (int[])length, (int[])size, (int[])type, (long)MemoryUtil.memAddress((ByteBuffer)name));
    }

    public static void glGetTransformFeedbackVaryingNV(int program, int index, int[] location) {
        long __functionAddress = GL.getICD().glGetTransformFeedbackVaryingNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])location, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)index, (int[])location);
    }

    public static void glTransformFeedbackStreamAttribsNV(int[] attribs, int[] bufstreams, int bufferMode) {
        long __functionAddress = GL.getICD().glTransformFeedbackStreamAttribsNV;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)attribs.length, (int[])attribs, (int)bufstreams.length, (int[])bufstreams, (int)bufferMode);
    }

    static {
        GL.initialize();
    }
}

