/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class KHRRobustness {
    public static final int GL_NO_ERROR = 0;
    public static final int GL_GUILTY_CONTEXT_RESET = 33363;
    public static final int GL_INNOCENT_CONTEXT_RESET = 33364;
    public static final int GL_UNKNOWN_CONTEXT_RESET = 33365;
    public static final int GL_CONTEXT_ROBUST_ACCESS = 37107;
    public static final int GL_RESET_NOTIFICATION_STRATEGY = 33366;
    public static final int GL_LOSE_CONTEXT_ON_RESET = 33362;
    public static final int GL_NO_RESET_NOTIFICATION = 33377;
    public static final int GL_CONTEXT_LOST = 1287;

    protected KHRRobustness() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glGetGraphicsResetStatus, caps.glReadnPixels, caps.glGetnUniformfv, caps.glGetnUniformiv, caps.glGetnUniformuiv});
    }

    public static native int glGetGraphicsResetStatus();

    public static native void nglReadnPixels(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7);

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, int bufSize, long pixels) {
        KHRRobustness.nglReadnPixels(x, y, width, height, format, type, bufSize, pixels);
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, ByteBuffer pixels) {
        KHRRobustness.nglReadnPixels(x, y, width, height, format, type, pixels.remaining(), MemoryUtil.memAddress((ByteBuffer)pixels));
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, ShortBuffer pixels) {
        KHRRobustness.nglReadnPixels(x, y, width, height, format, type, pixels.remaining() << 1, MemoryUtil.memAddress((ShortBuffer)pixels));
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, IntBuffer pixels) {
        KHRRobustness.nglReadnPixels(x, y, width, height, format, type, pixels.remaining() << 2, MemoryUtil.memAddress((IntBuffer)pixels));
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, FloatBuffer pixels) {
        KHRRobustness.nglReadnPixels(x, y, width, height, format, type, pixels.remaining() << 2, MemoryUtil.memAddress((FloatBuffer)pixels));
    }

    public static native void nglGetnUniformfv(int var0, int var1, int var2, long var3);

    public static void glGetnUniformfv(int program, int location, FloatBuffer params) {
        KHRRobustness.nglGetnUniformfv(program, location, params.remaining(), MemoryUtil.memAddress((FloatBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetnUniformf(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            KHRRobustness.nglGetnUniformfv(program, location, 1, MemoryUtil.memAddress((FloatBuffer)params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetnUniformiv(int var0, int var1, int var2, long var3);

    public static void glGetnUniformiv(int program, int location, FloatBuffer params) {
        KHRRobustness.nglGetnUniformiv(program, location, params.remaining(), MemoryUtil.memAddress((FloatBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetnUniformi(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            KHRRobustness.nglGetnUniformiv(program, location, 1, MemoryUtil.memAddress((FloatBuffer)params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetnUniformuiv(int var0, int var1, int var2, long var3);

    public static void glGetnUniformuiv(int program, int location, FloatBuffer params) {
        KHRRobustness.nglGetnUniformuiv(program, location, params.remaining(), MemoryUtil.memAddress((FloatBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetnUniformui(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            KHRRobustness.nglGetnUniformuiv(program, location, 1, MemoryUtil.memAddress((FloatBuffer)params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, short[] pixels) {
        long __functionAddress = GL.getICD().glReadnPixels;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (int)(pixels.length << 1), (short[])pixels);
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, int[] pixels) {
        long __functionAddress = GL.getICD().glReadnPixels;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (int)(pixels.length << 2), (int[])pixels);
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, float[] pixels) {
        long __functionAddress = GL.getICD().glReadnPixels;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (int)(pixels.length << 2), (float[])pixels);
    }

    public static void glGetnUniformfv(int program, int location, float[] params) {
        long __functionAddress = GL.getICD().glGetnUniformfv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)params.length, (float[])params);
    }

    public static void glGetnUniformiv(int program, int location, float[] params) {
        long __functionAddress = GL.getICD().glGetnUniformiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)params.length, (float[])params);
    }

    public static void glGetnUniformuiv(int program, int location, float[] params) {
        long __functionAddress = GL.getICD().glGetnUniformuiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)params.length, (float[])params);
    }

    static {
        GL.initialize();
    }
}

