/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageCallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class KHRDebug {
    public static final int GL_DEBUG_OUTPUT = 37600;
    public static final int GL_DEBUG_OUTPUT_SYNCHRONOUS = 33346;
    public static final int GL_CONTEXT_FLAG_DEBUG_BIT = 2;
    public static final int GL_MAX_DEBUG_MESSAGE_LENGTH = 37187;
    public static final int GL_MAX_DEBUG_LOGGED_MESSAGES = 37188;
    public static final int GL_DEBUG_LOGGED_MESSAGES = 37189;
    public static final int GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH = 33347;
    public static final int GL_MAX_DEBUG_GROUP_STACK_DEPTH = 33388;
    public static final int GL_DEBUG_GROUP_STACK_DEPTH = 33389;
    public static final int GL_MAX_LABEL_LENGTH = 33512;
    public static final int GL_DEBUG_CALLBACK_FUNCTION = 33348;
    public static final int GL_DEBUG_CALLBACK_USER_PARAM = 33349;
    public static final int GL_DEBUG_SOURCE_API = 33350;
    public static final int GL_DEBUG_SOURCE_WINDOW_SYSTEM = 33351;
    public static final int GL_DEBUG_SOURCE_SHADER_COMPILER = 33352;
    public static final int GL_DEBUG_SOURCE_THIRD_PARTY = 33353;
    public static final int GL_DEBUG_SOURCE_APPLICATION = 33354;
    public static final int GL_DEBUG_SOURCE_OTHER = 33355;
    public static final int GL_DEBUG_TYPE_ERROR = 33356;
    public static final int GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR = 33357;
    public static final int GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR = 33358;
    public static final int GL_DEBUG_TYPE_PORTABILITY = 33359;
    public static final int GL_DEBUG_TYPE_PERFORMANCE = 33360;
    public static final int GL_DEBUG_TYPE_OTHER = 33361;
    public static final int GL_DEBUG_TYPE_MARKER = 33384;
    public static final int GL_DEBUG_TYPE_PUSH_GROUP = 33385;
    public static final int GL_DEBUG_TYPE_POP_GROUP = 33386;
    public static final int GL_DEBUG_SEVERITY_HIGH = 37190;
    public static final int GL_DEBUG_SEVERITY_MEDIUM = 37191;
    public static final int GL_DEBUG_SEVERITY_LOW = 37192;
    public static final int GL_DEBUG_SEVERITY_NOTIFICATION = 33387;
    public static final int GL_BUFFER = 33504;
    public static final int GL_SHADER = 33505;
    public static final int GL_PROGRAM = 33506;
    public static final int GL_QUERY = 33507;
    public static final int GL_PROGRAM_PIPELINE = 33508;
    public static final int GL_SAMPLER = 33510;
    public static final int GL_DISPLAY_LIST = 33511;

    protected KHRDebug() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glDebugMessageControl, caps.glDebugMessageInsert, caps.glDebugMessageCallback, caps.glGetDebugMessageLog, caps.glPushDebugGroup, caps.glPopDebugGroup, caps.glObjectLabel, caps.glGetObjectLabel, caps.glObjectPtrLabel, caps.glGetObjectPtrLabel});
    }

    public static native void nglDebugMessageControl(int var0, int var1, int var2, int var3, long var4, boolean var6);

    public static void glDebugMessageControl(int source, int type, int severity, IntBuffer ids, boolean enabled) {
        KHRDebug.nglDebugMessageControl(source, type, severity, Checks.remainingSafe((Buffer)ids), MemoryUtil.memAddressSafe((IntBuffer)ids), enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDebugMessageControl(int source, int type, int severity, int id, boolean enabled) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer ids = stack.ints(id);
            KHRDebug.nglDebugMessageControl(source, type, severity, 1, MemoryUtil.memAddress((IntBuffer)ids), enabled);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglDebugMessageInsert(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glDebugMessageInsert(int source, int type, int id, int severity, ByteBuffer message) {
        KHRDebug.nglDebugMessageInsert(source, type, id, severity, message.remaining(), MemoryUtil.memAddress((ByteBuffer)message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDebugMessageInsert(int source, int type, int id, int severity, CharSequence message) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer messageEncoded = stack.UTF8(message, false);
            KHRDebug.nglDebugMessageInsert(source, type, id, severity, messageEncoded.remaining(), MemoryUtil.memAddress((ByteBuffer)messageEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglDebugMessageCallback(long var0, long var2);

    public static void glDebugMessageCallback(GLDebugMessageCallbackI callback, long userParam) {
        KHRDebug.nglDebugMessageCallback(MemoryUtil.memAddressSafe((Pointer)callback), userParam);
    }

    public static native int nglGetDebugMessageLog(int var0, int var1, long var2, long var4, long var6, long var8, long var10, long var12);

    public static int glGetDebugMessageLog(int count, IntBuffer sources, IntBuffer types, IntBuffer ids, IntBuffer severities, IntBuffer lengths, ByteBuffer messageLog) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)sources, (int)count);
            Checks.checkSafe((Buffer)types, (int)count);
            Checks.checkSafe((Buffer)ids, (int)count);
            Checks.checkSafe((Buffer)severities, (int)count);
            Checks.checkSafe((Buffer)lengths, (int)count);
        }
        return KHRDebug.nglGetDebugMessageLog(count, Checks.remainingSafe((Buffer)messageLog), MemoryUtil.memAddressSafe((IntBuffer)sources), MemoryUtil.memAddressSafe((IntBuffer)types), MemoryUtil.memAddressSafe((IntBuffer)ids), MemoryUtil.memAddressSafe((IntBuffer)severities), MemoryUtil.memAddressSafe((IntBuffer)lengths), MemoryUtil.memAddressSafe((ByteBuffer)messageLog));
    }

    public static native void nglPushDebugGroup(int var0, int var1, int var2, long var3);

    public static void glPushDebugGroup(int source, int id, ByteBuffer message) {
        KHRDebug.nglPushDebugGroup(source, id, message.remaining(), MemoryUtil.memAddress((ByteBuffer)message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glPushDebugGroup(int source, int id, CharSequence message) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer messageEncoded = stack.UTF8(message, false);
            KHRDebug.nglPushDebugGroup(source, id, messageEncoded.remaining(), MemoryUtil.memAddress((ByteBuffer)messageEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glPopDebugGroup();

    public static native void nglObjectLabel(int var0, int var1, int var2, long var3);

    public static void glObjectLabel(int identifier, int name, ByteBuffer label) {
        KHRDebug.nglObjectLabel(identifier, name, label.remaining(), MemoryUtil.memAddress((ByteBuffer)label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glObjectLabel(int identifier, int name, CharSequence label) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer labelEncoded = stack.UTF8(label, false);
            KHRDebug.nglObjectLabel(identifier, name, labelEncoded.remaining(), MemoryUtil.memAddress((ByteBuffer)labelEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetObjectLabel(int var0, int var1, int var2, long var3, long var5);

    public static void glGetObjectLabel(int identifier, int name, IntBuffer length, ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)1);
        }
        KHRDebug.nglGetObjectLabel(identifier, name, label.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetObjectLabel(int identifier, int name, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer label = stack.malloc(bufSize);
            KHRDebug.nglGetObjectLabel(identifier, name, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)label));
            String string = MemoryUtil.memUTF8((ByteBuffer)label, (int)length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static String glGetObjectLabel(int identifier, int name) {
        return KHRDebug.glGetObjectLabel(identifier, name, GL11.glGetInteger(33512));
    }

    public static native void nglObjectPtrLabel(long var0, int var2, long var3);

    public static void glObjectPtrLabel(long ptr, ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.check((long)ptr);
        }
        KHRDebug.nglObjectPtrLabel(ptr, label.remaining(), MemoryUtil.memAddress((ByteBuffer)label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glObjectPtrLabel(long ptr, CharSequence label) {
        if (Checks.CHECKS) {
            Checks.check((long)ptr);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer labelEncoded = stack.UTF8(label, false);
            KHRDebug.nglObjectPtrLabel(ptr, labelEncoded.remaining(), MemoryUtil.memAddress((ByteBuffer)labelEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetObjectPtrLabel(long var0, int var2, long var3, long var5);

    public static void glGetObjectPtrLabel(long ptr, IntBuffer length, ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.check((long)ptr);
            Checks.checkSafe((Buffer)length, (int)1);
        }
        KHRDebug.nglGetObjectPtrLabel(ptr, label.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)label));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetObjectPtrLabel(long ptr, int bufSize) {
        if (Checks.CHECKS) {
            Checks.check((long)ptr);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer label = stack.malloc(bufSize);
            KHRDebug.nglGetObjectPtrLabel(ptr, bufSize, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)label));
            String string = MemoryUtil.memUTF8((ByteBuffer)label, (int)length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static String glGetObjectPtrLabel(long ptr) {
        return KHRDebug.glGetObjectPtrLabel(ptr, GL11.glGetInteger(33512));
    }

    public static void glDebugMessageControl(int source, int type, int severity, int[] ids, boolean enabled) {
        long __functionAddress = GL.getICD().glDebugMessageControl;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)source, (int)type, (int)severity, (int)Checks.lengthSafe((int[])ids), (int[])ids, (boolean)enabled);
    }

    public static int glGetDebugMessageLog(int count, int[] sources, int[] types, int[] ids, int[] severities, int[] lengths, ByteBuffer messageLog) {
        long __functionAddress = GL.getICD().glGetDebugMessageLog;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])sources, (int)count);
            Checks.checkSafe((int[])types, (int)count);
            Checks.checkSafe((int[])ids, (int)count);
            Checks.checkSafe((int[])severities, (int)count);
            Checks.checkSafe((int[])lengths, (int)count);
        }
        return JNI.callPPPPPPI((long)__functionAddress, (int)count, (int)Checks.remainingSafe((Buffer)messageLog), (int[])sources, (int[])types, (int[])ids, (int[])severities, (int[])lengths, (long)MemoryUtil.memAddressSafe((ByteBuffer)messageLog));
    }

    public static void glGetObjectLabel(int identifier, int name, int[] length, ByteBuffer label) {
        long __functionAddress = GL.getICD().glGetObjectLabel;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])length, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)identifier, (int)name, (int)label.remaining(), (int[])length, (long)MemoryUtil.memAddress((ByteBuffer)label));
    }

    public static void glGetObjectPtrLabel(long ptr, int[] length, ByteBuffer label) {
        long __functionAddress = GL.getICD().glGetObjectPtrLabel;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)ptr);
            Checks.checkSafe((int[])length, (int)1);
        }
        JNI.callPPPV((long)__functionAddress, (long)ptr, (int)label.remaining(), (int[])length, (long)MemoryUtil.memAddress((ByteBuffer)label));
    }

    static {
        GL.initialize();
    }
}

