/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLXCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class GLXARBGetProcAddress {
    protected GLXARBGetProcAddress() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLXCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glXGetProcAddressARB});
    }

    public static long nglXGetProcAddressARB(long procName) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXGetProcAddressARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPP((long)__functionAddress, (long)procName);
    }

    public static long glXGetProcAddressARB(ByteBuffer procName) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)procName);
        }
        return GLXARBGetProcAddress.nglXGetProcAddressARB(MemoryUtil.memAddress((ByteBuffer)procName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glXGetProcAddressARB(CharSequence procName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer procNameEncoded = stack.ASCII(procName);
            long l = GLXARBGetProcAddress.nglXGetProcAddressARB(MemoryUtil.memAddress((ByteBuffer)procNameEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }
}

