/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class GL45 {
    public static final int GL_NEGATIVE_ONE_TO_ONE = 37726;
    public static final int GL_ZERO_TO_ONE = 37727;
    public static final int GL_CLIP_ORIGIN = 37724;
    public static final int GL_CLIP_DEPTH_MODE = 37725;
    public static final int GL_QUERY_WAIT_INVERTED = 36375;
    public static final int GL_QUERY_NO_WAIT_INVERTED = 36376;
    public static final int GL_QUERY_BY_REGION_WAIT_INVERTED = 36377;
    public static final int GL_QUERY_BY_REGION_NO_WAIT_INVERTED = 36378;
    public static final int GL_MAX_CULL_DISTANCES = 33529;
    public static final int GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES = 33530;
    public static final int GL_TEXTURE_TARGET = 4102;
    public static final int GL_QUERY_TARGET = 33514;
    public static final int GL_CONTEXT_RELEASE_BEHAVIOR = 33531;
    public static final int GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH = 33532;
    public static final int GL_GUILTY_CONTEXT_RESET = 33363;
    public static final int GL_INNOCENT_CONTEXT_RESET = 33364;
    public static final int GL_UNKNOWN_CONTEXT_RESET = 33365;
    public static final int GL_RESET_NOTIFICATION_STRATEGY = 33366;
    public static final int GL_LOSE_CONTEXT_ON_RESET = 33362;
    public static final int GL_NO_RESET_NOTIFICATION = 33377;
    public static final int GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT = 4;
    public static final int GL_CONTEXT_LOST = 1287;

    protected GL45() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps, Set<String> ext) {
        return Checks.checkFunctions((long[])new long[]{caps.glClipControl, caps.glCreateTransformFeedbacks, caps.glTransformFeedbackBufferBase, caps.glTransformFeedbackBufferRange, caps.glGetTransformFeedbackiv, caps.glGetTransformFeedbacki_v, caps.glGetTransformFeedbacki64_v, caps.glCreateBuffers, caps.glNamedBufferStorage, caps.glNamedBufferData, caps.glNamedBufferSubData, caps.glCopyNamedBufferSubData, caps.glClearNamedBufferData, caps.glClearNamedBufferSubData, caps.glMapNamedBuffer, caps.glMapNamedBufferRange, caps.glUnmapNamedBuffer, caps.glFlushMappedNamedBufferRange, caps.glGetNamedBufferParameteriv, caps.glGetNamedBufferParameteri64v, caps.glGetNamedBufferPointerv, caps.glGetNamedBufferSubData, caps.glCreateFramebuffers, caps.glNamedFramebufferRenderbuffer, caps.glNamedFramebufferParameteri, caps.glNamedFramebufferTexture, caps.glNamedFramebufferTextureLayer, caps.glNamedFramebufferDrawBuffer, caps.glNamedFramebufferDrawBuffers, caps.glNamedFramebufferReadBuffer, caps.glInvalidateNamedFramebufferData, caps.glInvalidateNamedFramebufferSubData, caps.glClearNamedFramebufferiv, caps.glClearNamedFramebufferuiv, caps.glClearNamedFramebufferfv, caps.glClearNamedFramebufferfi, caps.glBlitNamedFramebuffer, caps.glCheckNamedFramebufferStatus, caps.glGetNamedFramebufferParameteriv, caps.glGetNamedFramebufferAttachmentParameteriv, caps.glCreateRenderbuffers, caps.glNamedRenderbufferStorage, caps.glNamedRenderbufferStorageMultisample, caps.glGetNamedRenderbufferParameteriv, caps.glCreateTextures, caps.glTextureBuffer, caps.glTextureBufferRange, caps.glTextureStorage1D, caps.glTextureStorage2D, caps.glTextureStorage3D, caps.glTextureStorage2DMultisample, caps.glTextureStorage3DMultisample, caps.glTextureSubImage1D, caps.glTextureSubImage2D, caps.glTextureSubImage3D, caps.glCompressedTextureSubImage1D, caps.glCompressedTextureSubImage2D, caps.glCompressedTextureSubImage3D, caps.glCopyTextureSubImage1D, caps.glCopyTextureSubImage2D, caps.glCopyTextureSubImage3D, caps.glTextureParameterf, caps.glTextureParameterfv, caps.glTextureParameteri, caps.glTextureParameterIiv, caps.glTextureParameterIuiv, caps.glTextureParameteriv, caps.glGenerateTextureMipmap, caps.glBindTextureUnit, caps.glGetTextureImage, caps.glGetCompressedTextureImage, caps.glGetTextureLevelParameterfv, caps.glGetTextureLevelParameteriv, caps.glGetTextureParameterfv, caps.glGetTextureParameterIiv, caps.glGetTextureParameterIuiv, caps.glGetTextureParameteriv, caps.glCreateVertexArrays, caps.glDisableVertexArrayAttrib, caps.glEnableVertexArrayAttrib, caps.glVertexArrayElementBuffer, caps.glVertexArrayVertexBuffer, caps.glVertexArrayVertexBuffers, caps.glVertexArrayAttribFormat, caps.glVertexArrayAttribIFormat, caps.glVertexArrayAttribLFormat, caps.glVertexArrayAttribBinding, caps.glVertexArrayBindingDivisor, caps.glGetVertexArrayiv, caps.glGetVertexArrayIndexediv, caps.glGetVertexArrayIndexed64iv, caps.glCreateSamplers, caps.glCreateProgramPipelines, caps.glCreateQueries, caps.glGetQueryBufferObjectiv, caps.glGetQueryBufferObjectuiv, caps.glGetQueryBufferObjecti64v, caps.glGetQueryBufferObjectui64v, caps.glMemoryBarrierByRegion, caps.glGetTextureSubImage, caps.glGetCompressedTextureSubImage, caps.glTextureBarrier, caps.glGetGraphicsResetStatus, caps.glReadnPixels, caps.glGetnUniformfv, caps.glGetnUniformiv, caps.glGetnUniformuiv});
    }

    public static native void glClipControl(int var0, int var1);

    public static native void nglCreateTransformFeedbacks(int var0, long var1);

    public static void glCreateTransformFeedbacks(IntBuffer ids) {
        GL45.nglCreateTransformFeedbacks(ids.remaining(), MemoryUtil.memAddress((IntBuffer)ids));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreateTransformFeedbacks() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer ids = stack.callocInt(1);
            GL45.nglCreateTransformFeedbacks(1, MemoryUtil.memAddress((IntBuffer)ids));
            int n = ids.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glTransformFeedbackBufferBase(int var0, int var1, int var2);

    public static native void glTransformFeedbackBufferRange(int var0, int var1, int var2, long var3, long var5);

    public static native void nglGetTransformFeedbackiv(int var0, int var1, long var2);

    public static void glGetTransformFeedbackiv(int xfb, int pname, IntBuffer param) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)param, (int)1);
        }
        GL45.nglGetTransformFeedbackiv(xfb, pname, MemoryUtil.memAddress((IntBuffer)param));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetTransformFeedbacki(int xfb, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer param = stack.callocInt(1);
            GL45.nglGetTransformFeedbackiv(xfb, pname, MemoryUtil.memAddress((IntBuffer)param));
            int n = param.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetTransformFeedbacki_v(int var0, int var1, int var2, long var3);

    public static void glGetTransformFeedbacki_v(int xfb, int pname, int index, IntBuffer param) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)param, (int)1);
        }
        GL45.nglGetTransformFeedbacki_v(xfb, pname, index, MemoryUtil.memAddress((IntBuffer)param));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetTransformFeedbacki(int xfb, int pname, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer param = stack.callocInt(1);
            GL45.nglGetTransformFeedbacki_v(xfb, pname, index, MemoryUtil.memAddress((IntBuffer)param));
            int n = param.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetTransformFeedbacki64_v(int var0, int var1, int var2, long var3);

    public static void glGetTransformFeedbacki64_v(int xfb, int pname, int index, LongBuffer param) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)param, (int)1);
        }
        GL45.nglGetTransformFeedbacki64_v(xfb, pname, index, MemoryUtil.memAddress((LongBuffer)param));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetTransformFeedbacki64(int xfb, int pname, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer param = stack.callocLong(1);
            GL45.nglGetTransformFeedbacki64_v(xfb, pname, index, MemoryUtil.memAddress((LongBuffer)param));
            long l = param.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglCreateBuffers(int var0, long var1);

    public static void glCreateBuffers(IntBuffer buffers) {
        GL45.nglCreateBuffers(buffers.remaining(), MemoryUtil.memAddress((IntBuffer)buffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreateBuffers() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer buffers = stack.callocInt(1);
            GL45.nglCreateBuffers(1, MemoryUtil.memAddress((IntBuffer)buffers));
            int n = buffers.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglNamedBufferStorage(int var0, long var1, long var3, int var5);

    public static void glNamedBufferStorage(int buffer, long size, int flags) {
        GL45.nglNamedBufferStorage(buffer, size, 0L, flags);
    }

    public static void glNamedBufferStorage(int buffer, ByteBuffer data, int flags) {
        GL45.nglNamedBufferStorage(buffer, data.remaining(), MemoryUtil.memAddress((ByteBuffer)data), flags);
    }

    public static void glNamedBufferStorage(int buffer, ShortBuffer data, int flags) {
        GL45.nglNamedBufferStorage(buffer, data.remaining() << 1, MemoryUtil.memAddress((ShortBuffer)data), flags);
    }

    public static void glNamedBufferStorage(int buffer, IntBuffer data, int flags) {
        GL45.nglNamedBufferStorage(buffer, data.remaining() << 2, MemoryUtil.memAddress((IntBuffer)data), flags);
    }

    public static void glNamedBufferStorage(int buffer, FloatBuffer data, int flags) {
        GL45.nglNamedBufferStorage(buffer, data.remaining() << 2, MemoryUtil.memAddress((FloatBuffer)data), flags);
    }

    public static void glNamedBufferStorage(int buffer, DoubleBuffer data, int flags) {
        GL45.nglNamedBufferStorage(buffer, data.remaining() << 3, MemoryUtil.memAddress((DoubleBuffer)data), flags);
    }

    public static native void nglNamedBufferData(int var0, long var1, long var3, int var5);

    public static void glNamedBufferData(int buffer, long size, int usage) {
        GL45.nglNamedBufferData(buffer, size, 0L, usage);
    }

    public static void glNamedBufferData(int buffer, ByteBuffer data, int usage) {
        GL45.nglNamedBufferData(buffer, data.remaining(), MemoryUtil.memAddress((ByteBuffer)data), usage);
    }

    public static void glNamedBufferData(int buffer, ShortBuffer data, int usage) {
        GL45.nglNamedBufferData(buffer, data.remaining() << 1, MemoryUtil.memAddress((ShortBuffer)data), usage);
    }

    public static void glNamedBufferData(int buffer, IntBuffer data, int usage) {
        GL45.nglNamedBufferData(buffer, data.remaining() << 2, MemoryUtil.memAddress((IntBuffer)data), usage);
    }

    public static void glNamedBufferData(int buffer, FloatBuffer data, int usage) {
        GL45.nglNamedBufferData(buffer, data.remaining() << 2, MemoryUtil.memAddress((FloatBuffer)data), usage);
    }

    public static void glNamedBufferData(int buffer, DoubleBuffer data, int usage) {
        GL45.nglNamedBufferData(buffer, data.remaining() << 3, MemoryUtil.memAddress((DoubleBuffer)data), usage);
    }

    public static native void nglNamedBufferSubData(int var0, long var1, long var3, long var5);

    public static void glNamedBufferSubData(int buffer, long offset, ByteBuffer data) {
        GL45.nglNamedBufferSubData(buffer, offset, data.remaining(), MemoryUtil.memAddress((ByteBuffer)data));
    }

    public static void glNamedBufferSubData(int buffer, long offset, ShortBuffer data) {
        GL45.nglNamedBufferSubData(buffer, offset, data.remaining() << 1, MemoryUtil.memAddress((ShortBuffer)data));
    }

    public static void glNamedBufferSubData(int buffer, long offset, IntBuffer data) {
        GL45.nglNamedBufferSubData(buffer, offset, data.remaining() << 2, MemoryUtil.memAddress((IntBuffer)data));
    }

    public static void glNamedBufferSubData(int buffer, long offset, FloatBuffer data) {
        GL45.nglNamedBufferSubData(buffer, offset, data.remaining() << 2, MemoryUtil.memAddress((FloatBuffer)data));
    }

    public static void glNamedBufferSubData(int buffer, long offset, DoubleBuffer data) {
        GL45.nglNamedBufferSubData(buffer, offset, data.remaining() << 3, MemoryUtil.memAddress((DoubleBuffer)data));
    }

    public static native void glCopyNamedBufferSubData(int var0, int var1, long var2, long var4, long var6);

    public static native void nglClearNamedBufferData(int var0, int var1, int var2, int var3, long var4);

    public static void glClearNamedBufferData(int buffer, int internalformat, int format, int type, ByteBuffer data) {
        GL45.nglClearNamedBufferData(buffer, internalformat, format, type, MemoryUtil.memAddressSafe((ByteBuffer)data));
    }

    public static void glClearNamedBufferData(int buffer, int internalformat, int format, int type, ShortBuffer data) {
        GL45.nglClearNamedBufferData(buffer, internalformat, format, type, MemoryUtil.memAddressSafe((ShortBuffer)data));
    }

    public static void glClearNamedBufferData(int buffer, int internalformat, int format, int type, IntBuffer data) {
        GL45.nglClearNamedBufferData(buffer, internalformat, format, type, MemoryUtil.memAddressSafe((IntBuffer)data));
    }

    public static void glClearNamedBufferData(int buffer, int internalformat, int format, int type, FloatBuffer data) {
        GL45.nglClearNamedBufferData(buffer, internalformat, format, type, MemoryUtil.memAddressSafe((FloatBuffer)data));
    }

    public static native void nglClearNamedBufferSubData(int var0, int var1, long var2, long var4, int var6, int var7, long var8);

    public static void glClearNamedBufferSubData(int buffer, int internalformat, long offset, long size, int format, int type, ByteBuffer data) {
        GL45.nglClearNamedBufferSubData(buffer, internalformat, offset, size, format, type, MemoryUtil.memAddressSafe((ByteBuffer)data));
    }

    public static void glClearNamedBufferSubData(int buffer, int internalformat, long offset, long size, int format, int type, ShortBuffer data) {
        GL45.nglClearNamedBufferSubData(buffer, internalformat, offset, size, format, type, MemoryUtil.memAddressSafe((ShortBuffer)data));
    }

    public static void glClearNamedBufferSubData(int buffer, int internalformat, long offset, long size, int format, int type, IntBuffer data) {
        GL45.nglClearNamedBufferSubData(buffer, internalformat, offset, size, format, type, MemoryUtil.memAddressSafe((IntBuffer)data));
    }

    public static void glClearNamedBufferSubData(int buffer, int internalformat, long offset, long size, int format, int type, FloatBuffer data) {
        GL45.nglClearNamedBufferSubData(buffer, internalformat, offset, size, format, type, MemoryUtil.memAddressSafe((FloatBuffer)data));
    }

    public static native long nglMapNamedBuffer(int var0, int var1);

    public static ByteBuffer glMapNamedBuffer(int buffer, int access) {
        long __result = GL45.nglMapNamedBuffer(buffer, access);
        return MemoryUtil.memByteBuffer((long)__result, (int)GL45.glGetNamedBufferParameteri(buffer, 34660));
    }

    public static ByteBuffer glMapNamedBuffer(int buffer, int access, ByteBuffer old_buffer) {
        long __result = GL45.nglMapNamedBuffer(buffer, access);
        int length = GL45.glGetNamedBufferParameteri(buffer, 34660);
        return APIUtil.apiGetMappedBuffer((ByteBuffer)old_buffer, (long)__result, (int)length);
    }

    public static ByteBuffer glMapNamedBuffer(int buffer, int access, long length, ByteBuffer old_buffer) {
        long __result = GL45.nglMapNamedBuffer(buffer, access);
        return APIUtil.apiGetMappedBuffer((ByteBuffer)old_buffer, (long)__result, (int)((int)length));
    }

    public static native long nglMapNamedBufferRange(int var0, long var1, long var3, int var5);

    public static ByteBuffer glMapNamedBufferRange(int buffer, long offset, long length, int access) {
        long __result = GL45.nglMapNamedBufferRange(buffer, offset, length, access);
        return MemoryUtil.memByteBuffer((long)__result, (int)((int)length));
    }

    public static ByteBuffer glMapNamedBufferRange(int buffer, long offset, long length, int access, ByteBuffer old_buffer) {
        long __result = GL45.nglMapNamedBufferRange(buffer, offset, length, access);
        return APIUtil.apiGetMappedBuffer((ByteBuffer)old_buffer, (long)__result, (int)((int)length));
    }

    public static native boolean glUnmapNamedBuffer(int var0);

    public static native void glFlushMappedNamedBufferRange(int var0, long var1, long var3);

    public static native void nglGetNamedBufferParameteriv(int var0, int var1, long var2);

    public static void glGetNamedBufferParameteriv(int buffer, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GL45.nglGetNamedBufferParameteriv(buffer, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetNamedBufferParameteri(int buffer, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL45.nglGetNamedBufferParameteriv(buffer, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetNamedBufferParameteri64v(int var0, int var1, long var2);

    public static void glGetNamedBufferParameteri64v(int buffer, int pname, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GL45.nglGetNamedBufferParameteri64v(buffer, pname, MemoryUtil.memAddress((LongBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetNamedBufferParameteri64(int buffer, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer params = stack.callocLong(1);
            GL45.nglGetNamedBufferParameteri64v(buffer, pname, MemoryUtil.memAddress((LongBuffer)params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetNamedBufferPointerv(int var0, int var1, long var2);

    public static void glGetNamedBufferPointerv(int buffer, int pname, PointerBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)params, (int)1);
        }
        GL45.nglGetNamedBufferPointerv(buffer, pname, MemoryUtil.memAddress((CustomBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetNamedBufferPointer(int buffer, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer params = stack.callocPointer(1);
            GL45.nglGetNamedBufferPointerv(buffer, pname, MemoryUtil.memAddress((CustomBuffer)params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetNamedBufferSubData(int var0, long var1, long var3, long var5);

    public static void glGetNamedBufferSubData(int buffer, long offset, ByteBuffer data) {
        GL45.nglGetNamedBufferSubData(buffer, offset, data.remaining(), MemoryUtil.memAddress((ByteBuffer)data));
    }

    public static void glGetNamedBufferSubData(int buffer, long offset, ShortBuffer data) {
        GL45.nglGetNamedBufferSubData(buffer, offset, data.remaining() << 1, MemoryUtil.memAddress((ShortBuffer)data));
    }

    public static void glGetNamedBufferSubData(int buffer, long offset, IntBuffer data) {
        GL45.nglGetNamedBufferSubData(buffer, offset, data.remaining() << 2, MemoryUtil.memAddress((IntBuffer)data));
    }

    public static void glGetNamedBufferSubData(int buffer, long offset, FloatBuffer data) {
        GL45.nglGetNamedBufferSubData(buffer, offset, data.remaining() << 2, MemoryUtil.memAddress((FloatBuffer)data));
    }

    public static void glGetNamedBufferSubData(int buffer, long offset, DoubleBuffer data) {
        GL45.nglGetNamedBufferSubData(buffer, offset, data.remaining() << 3, MemoryUtil.memAddress((DoubleBuffer)data));
    }

    public static native void nglCreateFramebuffers(int var0, long var1);

    public static void glCreateFramebuffers(IntBuffer framebuffers) {
        GL45.nglCreateFramebuffers(framebuffers.remaining(), MemoryUtil.memAddress((IntBuffer)framebuffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreateFramebuffers() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer framebuffers = stack.callocInt(1);
            GL45.nglCreateFramebuffers(1, MemoryUtil.memAddress((IntBuffer)framebuffers));
            int n = framebuffers.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glNamedFramebufferRenderbuffer(int var0, int var1, int var2, int var3);

    public static native void glNamedFramebufferParameteri(int var0, int var1, int var2);

    public static native void glNamedFramebufferTexture(int var0, int var1, int var2, int var3);

    public static native void glNamedFramebufferTextureLayer(int var0, int var1, int var2, int var3, int var4);

    public static native void glNamedFramebufferDrawBuffer(int var0, int var1);

    public static native void nglNamedFramebufferDrawBuffers(int var0, int var1, long var2);

    public static void glNamedFramebufferDrawBuffers(int framebuffer, IntBuffer bufs) {
        GL45.nglNamedFramebufferDrawBuffers(framebuffer, bufs.remaining(), MemoryUtil.memAddress((IntBuffer)bufs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glNamedFramebufferDrawBuffers(int framebuffer, int buf) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer bufs = stack.ints(buf);
            GL45.nglNamedFramebufferDrawBuffers(framebuffer, 1, MemoryUtil.memAddress((IntBuffer)bufs));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glNamedFramebufferReadBuffer(int var0, int var1);

    public static native void nglInvalidateNamedFramebufferData(int var0, int var1, long var2);

    public static void glInvalidateNamedFramebufferData(int framebuffer, IntBuffer attachments) {
        GL45.nglInvalidateNamedFramebufferData(framebuffer, attachments.remaining(), MemoryUtil.memAddress((IntBuffer)attachments));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glInvalidateNamedFramebufferData(int framebuffer, int attachment) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer attachments = stack.ints(attachment);
            GL45.nglInvalidateNamedFramebufferData(framebuffer, 1, MemoryUtil.memAddress((IntBuffer)attachments));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglInvalidateNamedFramebufferSubData(int var0, int var1, long var2, int var4, int var5, int var6, int var7);

    public static void glInvalidateNamedFramebufferSubData(int framebuffer, IntBuffer attachments, int x, int y, int width, int height) {
        GL45.nglInvalidateNamedFramebufferSubData(framebuffer, attachments.remaining(), MemoryUtil.memAddress((IntBuffer)attachments), x, y, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glInvalidateNamedFramebufferSubData(int framebuffer, int attachment, int x, int y, int width, int height) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer attachments = stack.ints(attachment);
            GL45.nglInvalidateNamedFramebufferSubData(framebuffer, 1, MemoryUtil.memAddress((IntBuffer)attachments), x, y, width, height);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglClearNamedFramebufferiv(int var0, int var1, int var2, long var3);

    public static void glClearNamedFramebufferiv(int framebuffer, int buffer, int drawbuffer, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, (int)1);
        }
        GL45.nglClearNamedFramebufferiv(framebuffer, buffer, drawbuffer, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static native void nglClearNamedFramebufferuiv(int var0, int var1, int var2, long var3);

    public static void glClearNamedFramebufferuiv(int framebuffer, int buffer, int drawbuffer, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, (int)4);
        }
        GL45.nglClearNamedFramebufferuiv(framebuffer, buffer, drawbuffer, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static native void nglClearNamedFramebufferfv(int var0, int var1, int var2, long var3);

    public static void glClearNamedFramebufferfv(int framebuffer, int buffer, int drawbuffer, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, (int)1);
        }
        GL45.nglClearNamedFramebufferfv(framebuffer, buffer, drawbuffer, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void glClearNamedFramebufferfi(int var0, int var1, int var2, float var3, int var4);

    public static native void glBlitNamedFramebuffer(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    public static native int glCheckNamedFramebufferStatus(int var0, int var1);

    public static native void nglGetNamedFramebufferParameteriv(int var0, int var1, long var2);

    public static void glGetNamedFramebufferParameteriv(int framebuffer, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GL45.nglGetNamedFramebufferParameteriv(framebuffer, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetNamedFramebufferParameteri(int framebuffer, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL45.nglGetNamedFramebufferParameteriv(framebuffer, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetNamedFramebufferAttachmentParameteriv(int var0, int var1, int var2, long var3);

    public static void glGetNamedFramebufferAttachmentParameteriv(int framebuffer, int attachment, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GL45.nglGetNamedFramebufferAttachmentParameteriv(framebuffer, attachment, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetNamedFramebufferAttachmentParameteri(int framebuffer, int attachment, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL45.nglGetNamedFramebufferAttachmentParameteriv(framebuffer, attachment, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglCreateRenderbuffers(int var0, long var1);

    public static void glCreateRenderbuffers(IntBuffer renderbuffers) {
        GL45.nglCreateRenderbuffers(renderbuffers.remaining(), MemoryUtil.memAddress((IntBuffer)renderbuffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreateRenderbuffers() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer renderbuffers = stack.callocInt(1);
            GL45.nglCreateRenderbuffers(1, MemoryUtil.memAddress((IntBuffer)renderbuffers));
            int n = renderbuffers.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glNamedRenderbufferStorage(int var0, int var1, int var2, int var3);

    public static native void glNamedRenderbufferStorageMultisample(int var0, int var1, int var2, int var3, int var4);

    public static native void nglGetNamedRenderbufferParameteriv(int var0, int var1, long var2);

    public static void glGetNamedRenderbufferParameteriv(int renderbuffer, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GL45.nglGetNamedRenderbufferParameteriv(renderbuffer, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetNamedRenderbufferParameteri(int renderbuffer, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL45.nglGetNamedRenderbufferParameteriv(renderbuffer, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglCreateTextures(int var0, int var1, long var2);

    public static void glCreateTextures(int target, IntBuffer textures) {
        GL45.nglCreateTextures(target, textures.remaining(), MemoryUtil.memAddress((IntBuffer)textures));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreateTextures(int target) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer textures = stack.callocInt(1);
            GL45.nglCreateTextures(target, 1, MemoryUtil.memAddress((IntBuffer)textures));
            int n = textures.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glTextureBuffer(int var0, int var1, int var2);

    public static native void glTextureBufferRange(int var0, int var1, int var2, long var3, long var5);

    public static native void glTextureStorage1D(int var0, int var1, int var2, int var3);

    public static native void glTextureStorage2D(int var0, int var1, int var2, int var3, int var4);

    public static native void glTextureStorage3D(int var0, int var1, int var2, int var3, int var4, int var5);

    public static native void glTextureStorage2DMultisample(int var0, int var1, int var2, int var3, int var4, boolean var5);

    public static native void glTextureStorage3DMultisample(int var0, int var1, int var2, int var3, int var4, int var5, boolean var6);

    public static native void nglTextureSubImage1D(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, ByteBuffer pixels) {
        GL45.nglTextureSubImage1D(texture, level, xoffset, width, format, type, MemoryUtil.memAddress((ByteBuffer)pixels));
    }

    public static void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, long pixels) {
        GL45.nglTextureSubImage1D(texture, level, xoffset, width, format, type, pixels);
    }

    public static void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, ShortBuffer pixels) {
        GL45.nglTextureSubImage1D(texture, level, xoffset, width, format, type, MemoryUtil.memAddress((ShortBuffer)pixels));
    }

    public static void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, IntBuffer pixels) {
        GL45.nglTextureSubImage1D(texture, level, xoffset, width, format, type, MemoryUtil.memAddress((IntBuffer)pixels));
    }

    public static void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, FloatBuffer pixels) {
        GL45.nglTextureSubImage1D(texture, level, xoffset, width, format, type, MemoryUtil.memAddress((FloatBuffer)pixels));
    }

    public static void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, DoubleBuffer pixels) {
        GL45.nglTextureSubImage1D(texture, level, xoffset, width, format, type, MemoryUtil.memAddress((DoubleBuffer)pixels));
    }

    public static native void nglTextureSubImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    public static void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, ByteBuffer pixels) {
        GL45.nglTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress((ByteBuffer)pixels));
    }

    public static void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, long pixels) {
        GL45.nglTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type, pixels);
    }

    public static void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, ShortBuffer pixels) {
        GL45.nglTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress((ShortBuffer)pixels));
    }

    public static void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, IntBuffer pixels) {
        GL45.nglTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress((IntBuffer)pixels));
    }

    public static void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, FloatBuffer pixels) {
        GL45.nglTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress((FloatBuffer)pixels));
    }

    public static void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, DoubleBuffer pixels) {
        GL45.nglTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress((DoubleBuffer)pixels));
    }

    public static native void nglTextureSubImage3D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10);

    public static void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ByteBuffer pixels) {
        GL45.nglTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress((ByteBuffer)pixels));
    }

    public static void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, long pixels) {
        GL45.nglTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }

    public static void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ShortBuffer pixels) {
        GL45.nglTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress((ShortBuffer)pixels));
    }

    public static void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, IntBuffer pixels) {
        GL45.nglTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress((IntBuffer)pixels));
    }

    public static void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, FloatBuffer pixels) {
        GL45.nglTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress((FloatBuffer)pixels));
    }

    public static void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, DoubleBuffer pixels) {
        GL45.nglTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress((DoubleBuffer)pixels));
    }

    public static native void nglCompressedTextureSubImage1D(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static void glCompressedTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int imageSize, long data) {
        GL45.nglCompressedTextureSubImage1D(texture, level, xoffset, width, format, imageSize, data);
    }

    public static void glCompressedTextureSubImage1D(int texture, int level, int xoffset, int width, int format, ByteBuffer data) {
        GL45.nglCompressedTextureSubImage1D(texture, level, xoffset, width, format, data.remaining(), MemoryUtil.memAddress((ByteBuffer)data));
    }

    public static native void nglCompressedTextureSubImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    public static void glCompressedTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, long data) {
        GL45.nglCompressedTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, imageSize, data);
    }

    public static void glCompressedTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, ByteBuffer data) {
        GL45.nglCompressedTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, data.remaining(), MemoryUtil.memAddress((ByteBuffer)data));
    }

    public static native void nglCompressedTextureSubImage3D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10);

    public static void glCompressedTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, long data) {
        GL45.nglCompressedTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    }

    public static void glCompressedTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, ByteBuffer data) {
        GL45.nglCompressedTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, data.remaining(), MemoryUtil.memAddress((ByteBuffer)data));
    }

    public static native void glCopyTextureSubImage1D(int var0, int var1, int var2, int var3, int var4, int var5);

    public static native void glCopyTextureSubImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public static native void glCopyTextureSubImage3D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public static native void glTextureParameterf(int var0, int var1, float var2);

    public static native void nglTextureParameterfv(int var0, int var1, long var2);

    public static void glTextureParameterfv(int texture, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)4);
        }
        GL45.nglTextureParameterfv(texture, pname, MemoryUtil.memAddress((FloatBuffer)params));
    }

    public static native void glTextureParameteri(int var0, int var1, int var2);

    public static native void nglTextureParameterIiv(int var0, int var1, long var2);

    public static void glTextureParameterIiv(int texture, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GL45.nglTextureParameterIiv(texture, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glTextureParameterIi(int texture, int pname, int param) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.ints(param);
            GL45.nglTextureParameterIiv(texture, pname, MemoryUtil.memAddress((IntBuffer)params));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglTextureParameterIuiv(int var0, int var1, long var2);

    public static void glTextureParameterIuiv(int texture, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GL45.nglTextureParameterIuiv(texture, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glTextureParameterIui(int texture, int pname, int param) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.ints(param);
            GL45.nglTextureParameterIuiv(texture, pname, MemoryUtil.memAddress((IntBuffer)params));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglTextureParameteriv(int var0, int var1, long var2);

    public static void glTextureParameteriv(int texture, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)4);
        }
        GL45.nglTextureParameteriv(texture, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    public static native void glGenerateTextureMipmap(int var0);

    public static native void glBindTextureUnit(int var0, int var1);

    public static native void nglGetTextureImage(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glGetTextureImage(int texture, int level, int format, int type, int bufSize, long pixels) {
        GL45.nglGetTextureImage(texture, level, format, type, bufSize, pixels);
    }

    public static void glGetTextureImage(int texture, int level, int format, int type, ByteBuffer pixels) {
        GL45.nglGetTextureImage(texture, level, format, type, pixels.remaining(), MemoryUtil.memAddress((ByteBuffer)pixels));
    }

    public static void glGetTextureImage(int texture, int level, int format, int type, ShortBuffer pixels) {
        GL45.nglGetTextureImage(texture, level, format, type, pixels.remaining() << 1, MemoryUtil.memAddress((ShortBuffer)pixels));
    }

    public static void glGetTextureImage(int texture, int level, int format, int type, IntBuffer pixels) {
        GL45.nglGetTextureImage(texture, level, format, type, pixels.remaining() << 2, MemoryUtil.memAddress((IntBuffer)pixels));
    }

    public static void glGetTextureImage(int texture, int level, int format, int type, FloatBuffer pixels) {
        GL45.nglGetTextureImage(texture, level, format, type, pixels.remaining() << 2, MemoryUtil.memAddress((FloatBuffer)pixels));
    }

    public static void glGetTextureImage(int texture, int level, int format, int type, DoubleBuffer pixels) {
        GL45.nglGetTextureImage(texture, level, format, type, pixels.remaining() << 3, MemoryUtil.memAddress((DoubleBuffer)pixels));
    }

    public static native void nglGetCompressedTextureImage(int var0, int var1, int var2, long var3);

    public static void glGetCompressedTextureImage(int texture, int level, int bufSize, long pixels) {
        GL45.nglGetCompressedTextureImage(texture, level, bufSize, pixels);
    }

    public static void glGetCompressedTextureImage(int texture, int level, ByteBuffer pixels) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.check((Buffer)pixels, (int)GL45.glGetTextureLevelParameteri(texture, level, 34464));
        }
        GL45.nglGetCompressedTextureImage(texture, level, pixels.remaining(), MemoryUtil.memAddress((ByteBuffer)pixels));
    }

    public static native void nglGetTextureLevelParameterfv(int var0, int var1, int var2, long var3);

    public static void glGetTextureLevelParameterfv(int texture, int level, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GL45.nglGetTextureLevelParameterfv(texture, level, pname, MemoryUtil.memAddress((FloatBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetTextureLevelParameterf(int texture, int level, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            GL45.nglGetTextureLevelParameterfv(texture, level, pname, MemoryUtil.memAddress((FloatBuffer)params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetTextureLevelParameteriv(int var0, int var1, int var2, long var3);

    public static void glGetTextureLevelParameteriv(int texture, int level, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GL45.nglGetTextureLevelParameteriv(texture, level, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetTextureLevelParameteri(int texture, int level, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL45.nglGetTextureLevelParameteriv(texture, level, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetTextureParameterfv(int var0, int var1, long var2);

    public static void glGetTextureParameterfv(int texture, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GL45.nglGetTextureParameterfv(texture, pname, MemoryUtil.memAddress((FloatBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetTextureParameterf(int texture, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            GL45.nglGetTextureParameterfv(texture, pname, MemoryUtil.memAddress((FloatBuffer)params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetTextureParameterIiv(int var0, int var1, long var2);

    public static void glGetTextureParameterIiv(int texture, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GL45.nglGetTextureParameterIiv(texture, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetTextureParameterIi(int texture, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL45.nglGetTextureParameterIiv(texture, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetTextureParameterIuiv(int var0, int var1, long var2);

    public static void glGetTextureParameterIuiv(int texture, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GL45.nglGetTextureParameterIuiv(texture, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetTextureParameterIui(int texture, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL45.nglGetTextureParameterIuiv(texture, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetTextureParameteriv(int var0, int var1, long var2);

    public static void glGetTextureParameteriv(int texture, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GL45.nglGetTextureParameteriv(texture, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetTextureParameteri(int texture, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GL45.nglGetTextureParameteriv(texture, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglCreateVertexArrays(int var0, long var1);

    public static void glCreateVertexArrays(IntBuffer arrays) {
        GL45.nglCreateVertexArrays(arrays.remaining(), MemoryUtil.memAddress((IntBuffer)arrays));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreateVertexArrays() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer arrays = stack.callocInt(1);
            GL45.nglCreateVertexArrays(1, MemoryUtil.memAddress((IntBuffer)arrays));
            int n = arrays.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glDisableVertexArrayAttrib(int var0, int var1);

    public static native void glEnableVertexArrayAttrib(int var0, int var1);

    public static native void glVertexArrayElementBuffer(int var0, int var1);

    public static native void glVertexArrayVertexBuffer(int var0, int var1, int var2, long var3, int var5);

    public static native void nglVertexArrayVertexBuffers(int var0, int var1, int var2, long var3, long var5, long var7);

    public static void glVertexArrayVertexBuffers(int vaobj, int first, IntBuffer buffers, PointerBuffer offsets, IntBuffer strides) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)offsets, (int)Checks.remainingSafe((Buffer)buffers));
            Checks.checkSafe((Buffer)strides, (int)Checks.remainingSafe((Buffer)buffers));
        }
        GL45.nglVertexArrayVertexBuffers(vaobj, first, Checks.remainingSafe((Buffer)buffers), MemoryUtil.memAddressSafe((IntBuffer)buffers), MemoryUtil.memAddressSafe((Pointer)offsets), MemoryUtil.memAddressSafe((IntBuffer)strides));
    }

    public static native void glVertexArrayAttribFormat(int var0, int var1, int var2, int var3, boolean var4, int var5);

    public static native void glVertexArrayAttribIFormat(int var0, int var1, int var2, int var3, int var4);

    public static native void glVertexArrayAttribLFormat(int var0, int var1, int var2, int var3, int var4);

    public static native void glVertexArrayAttribBinding(int var0, int var1, int var2);

    public static native void glVertexArrayBindingDivisor(int var0, int var1, int var2);

    public static native void nglGetVertexArrayiv(int var0, int var1, long var2);

    public static void glGetVertexArrayiv(int vaobj, int pname, IntBuffer param) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)param, (int)1);
        }
        GL45.nglGetVertexArrayiv(vaobj, pname, MemoryUtil.memAddress((IntBuffer)param));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetVertexArrayi(int vaobj, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer param = stack.callocInt(1);
            GL45.nglGetVertexArrayiv(vaobj, pname, MemoryUtil.memAddress((IntBuffer)param));
            int n = param.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetVertexArrayIndexediv(int var0, int var1, int var2, long var3);

    public static void glGetVertexArrayIndexediv(int vaobj, int index, int pname, IntBuffer param) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)param, (int)1);
        }
        GL45.nglGetVertexArrayIndexediv(vaobj, index, pname, MemoryUtil.memAddress((IntBuffer)param));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetVertexArrayIndexedi(int vaobj, int index, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer param = stack.callocInt(1);
            GL45.nglGetVertexArrayIndexediv(vaobj, index, pname, MemoryUtil.memAddress((IntBuffer)param));
            int n = param.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetVertexArrayIndexed64iv(int var0, int var1, int var2, long var3);

    public static void glGetVertexArrayIndexed64iv(int vaobj, int index, int pname, LongBuffer param) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)param, (int)1);
        }
        GL45.nglGetVertexArrayIndexed64iv(vaobj, index, pname, MemoryUtil.memAddress((LongBuffer)param));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetVertexArrayIndexed64i(int vaobj, int index, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer param = stack.callocLong(1);
            GL45.nglGetVertexArrayIndexed64iv(vaobj, index, pname, MemoryUtil.memAddress((LongBuffer)param));
            long l = param.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglCreateSamplers(int var0, long var1);

    public static void glCreateSamplers(IntBuffer samplers) {
        GL45.nglCreateSamplers(samplers.remaining(), MemoryUtil.memAddress((IntBuffer)samplers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreateSamplers() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer samplers = stack.callocInt(1);
            GL45.nglCreateSamplers(1, MemoryUtil.memAddress((IntBuffer)samplers));
            int n = samplers.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglCreateProgramPipelines(int var0, long var1);

    public static void glCreateProgramPipelines(IntBuffer pipelines) {
        GL45.nglCreateProgramPipelines(pipelines.remaining(), MemoryUtil.memAddress((IntBuffer)pipelines));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreateProgramPipelines() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer pipelines = stack.callocInt(1);
            GL45.nglCreateProgramPipelines(1, MemoryUtil.memAddress((IntBuffer)pipelines));
            int n = pipelines.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglCreateQueries(int var0, int var1, long var2);

    public static void glCreateQueries(int target, IntBuffer ids) {
        GL45.nglCreateQueries(target, ids.remaining(), MemoryUtil.memAddress((IntBuffer)ids));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreateQueries(int target) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer ids = stack.callocInt(1);
            GL45.nglCreateQueries(target, 1, MemoryUtil.memAddress((IntBuffer)ids));
            int n = ids.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glGetQueryBufferObjectiv(int var0, int var1, int var2, long var3);

    public static native void glGetQueryBufferObjectuiv(int var0, int var1, int var2, long var3);

    public static native void glGetQueryBufferObjecti64v(int var0, int var1, int var2, long var3);

    public static native void glGetQueryBufferObjectui64v(int var0, int var1, int var2, long var3);

    public static native void glMemoryBarrierByRegion(int var0);

    public static native void nglGetTextureSubImage(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11);

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, int bufSize, long pixels) {
        GL45.nglGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, bufSize, pixels);
    }

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ByteBuffer pixels) {
        GL45.nglGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels.remaining(), MemoryUtil.memAddress((ByteBuffer)pixels));
    }

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ShortBuffer pixels) {
        GL45.nglGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels.remaining() << 1, MemoryUtil.memAddress((ShortBuffer)pixels));
    }

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, IntBuffer pixels) {
        GL45.nglGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels.remaining() << 2, MemoryUtil.memAddress((IntBuffer)pixels));
    }

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, FloatBuffer pixels) {
        GL45.nglGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels.remaining() << 2, MemoryUtil.memAddress((FloatBuffer)pixels));
    }

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, DoubleBuffer pixels) {
        GL45.nglGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels.remaining() << 3, MemoryUtil.memAddress((DoubleBuffer)pixels));
    }

    public static native void nglGetCompressedTextureSubImage(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9);

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int bufSize, long pixels) {
        GL45.nglGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, bufSize, pixels);
    }

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, ByteBuffer pixels) {
        GL45.nglGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, pixels.remaining(), MemoryUtil.memAddress((ByteBuffer)pixels));
    }

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, ShortBuffer pixels) {
        GL45.nglGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, pixels.remaining() << 1, MemoryUtil.memAddress((ShortBuffer)pixels));
    }

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, IntBuffer pixels) {
        GL45.nglGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, pixels.remaining() << 2, MemoryUtil.memAddress((IntBuffer)pixels));
    }

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, FloatBuffer pixels) {
        GL45.nglGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, pixels.remaining() << 2, MemoryUtil.memAddress((FloatBuffer)pixels));
    }

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, DoubleBuffer pixels) {
        GL45.nglGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, pixels.remaining() << 3, MemoryUtil.memAddress((DoubleBuffer)pixels));
    }

    public static native void glTextureBarrier();

    public static native int glGetGraphicsResetStatus();

    public static native void nglGetnMapdv(int var0, int var1, int var2, long var3);

    public static void glGetnMapdv(int target, int query, DoubleBuffer data) {
        GL45.nglGetnMapdv(target, query, data.remaining(), MemoryUtil.memAddress((DoubleBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double glGetnMapd(int target, int query) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            DoubleBuffer data = stack.callocDouble(1);
            GL45.nglGetnMapdv(target, query, 1, MemoryUtil.memAddress((DoubleBuffer)data));
            double d = data.get(0);
            return d;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetnMapfv(int var0, int var1, int var2, long var3);

    public static void glGetnMapfv(int target, int query, FloatBuffer data) {
        GL45.nglGetnMapfv(target, query, data.remaining(), MemoryUtil.memAddress((FloatBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetnMapf(int target, int query) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer data = stack.callocFloat(1);
            GL45.nglGetnMapfv(target, query, 1, MemoryUtil.memAddress((FloatBuffer)data));
            float f = data.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetnMapiv(int var0, int var1, int var2, long var3);

    public static void glGetnMapiv(int target, int query, IntBuffer data) {
        GL45.nglGetnMapiv(target, query, data.remaining(), MemoryUtil.memAddress((IntBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetnMapi(int target, int query) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer data = stack.callocInt(1);
            GL45.nglGetnMapiv(target, query, 1, MemoryUtil.memAddress((IntBuffer)data));
            int n = data.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetnPixelMapfv(int var0, int var1, long var2);

    public static void glGetnPixelMapfv(int map, FloatBuffer data) {
        GL45.nglGetnPixelMapfv(map, data.remaining(), MemoryUtil.memAddress((FloatBuffer)data));
    }

    public static native void nglGetnPixelMapuiv(int var0, int var1, long var2);

    public static void glGetnPixelMapuiv(int map, IntBuffer data) {
        GL45.nglGetnPixelMapuiv(map, data.remaining(), MemoryUtil.memAddress((IntBuffer)data));
    }

    public static native void nglGetnPixelMapusv(int var0, int var1, long var2);

    public static void glGetnPixelMapusv(int map, ShortBuffer data) {
        GL45.nglGetnPixelMapusv(map, data.remaining(), MemoryUtil.memAddress((ShortBuffer)data));
    }

    public static native void nglGetnPolygonStipple(int var0, long var1);

    public static void glGetnPolygonStipple(int bufSize, long pattern) {
        GL45.nglGetnPolygonStipple(bufSize, pattern);
    }

    public static void glGetnPolygonStipple(ByteBuffer pattern) {
        GL45.nglGetnPolygonStipple(pattern.remaining(), MemoryUtil.memAddress((ByteBuffer)pattern));
    }

    public static native void nglGetnTexImage(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glGetnTexImage(int tex, int level, int format, int type, int bufSize, long img) {
        GL45.nglGetnTexImage(tex, level, format, type, bufSize, img);
    }

    public static void glGetnTexImage(int tex, int level, int format, int type, ByteBuffer img) {
        GL45.nglGetnTexImage(tex, level, format, type, img.remaining(), MemoryUtil.memAddress((ByteBuffer)img));
    }

    public static void glGetnTexImage(int tex, int level, int format, int type, ShortBuffer img) {
        GL45.nglGetnTexImage(tex, level, format, type, img.remaining() << 1, MemoryUtil.memAddress((ShortBuffer)img));
    }

    public static void glGetnTexImage(int tex, int level, int format, int type, IntBuffer img) {
        GL45.nglGetnTexImage(tex, level, format, type, img.remaining() << 2, MemoryUtil.memAddress((IntBuffer)img));
    }

    public static void glGetnTexImage(int tex, int level, int format, int type, FloatBuffer img) {
        GL45.nglGetnTexImage(tex, level, format, type, img.remaining() << 2, MemoryUtil.memAddress((FloatBuffer)img));
    }

    public static void glGetnTexImage(int tex, int level, int format, int type, DoubleBuffer img) {
        GL45.nglGetnTexImage(tex, level, format, type, img.remaining() << 3, MemoryUtil.memAddress((DoubleBuffer)img));
    }

    public static native void nglReadnPixels(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7);

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, int bufSize, long pixels) {
        GL45.nglReadnPixels(x, y, width, height, format, type, bufSize, pixels);
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, ByteBuffer pixels) {
        GL45.nglReadnPixels(x, y, width, height, format, type, pixels.remaining(), MemoryUtil.memAddress((ByteBuffer)pixels));
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, ShortBuffer pixels) {
        GL45.nglReadnPixels(x, y, width, height, format, type, pixels.remaining() << 1, MemoryUtil.memAddress((ShortBuffer)pixels));
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, IntBuffer pixels) {
        GL45.nglReadnPixels(x, y, width, height, format, type, pixels.remaining() << 2, MemoryUtil.memAddress((IntBuffer)pixels));
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, FloatBuffer pixels) {
        GL45.nglReadnPixels(x, y, width, height, format, type, pixels.remaining() << 2, MemoryUtil.memAddress((FloatBuffer)pixels));
    }

    public static native void nglGetnColorTable(int var0, int var1, int var2, int var3, long var4);

    public static void glGetnColorTable(int target, int format, int type, int bufSize, long table) {
        GL45.nglGetnColorTable(target, format, type, bufSize, table);
    }

    public static void glGetnColorTable(int target, int format, int type, ByteBuffer table) {
        GL45.nglGetnColorTable(target, format, type, table.remaining(), MemoryUtil.memAddress((ByteBuffer)table));
    }

    public static void glGetnColorTable(int target, int format, int type, ShortBuffer table) {
        GL45.nglGetnColorTable(target, format, type, table.remaining() << 1, MemoryUtil.memAddress((ShortBuffer)table));
    }

    public static void glGetnColorTable(int target, int format, int type, IntBuffer table) {
        GL45.nglGetnColorTable(target, format, type, table.remaining() << 2, MemoryUtil.memAddress((IntBuffer)table));
    }

    public static void glGetnColorTable(int target, int format, int type, FloatBuffer table) {
        GL45.nglGetnColorTable(target, format, type, table.remaining() << 2, MemoryUtil.memAddress((FloatBuffer)table));
    }

    public static native void nglGetnConvolutionFilter(int var0, int var1, int var2, int var3, long var4);

    public static void glGetnConvolutionFilter(int target, int format, int type, int bufSize, long image) {
        GL45.nglGetnConvolutionFilter(target, format, type, bufSize, image);
    }

    public static void glGetnConvolutionFilter(int target, int format, int type, ByteBuffer image) {
        GL45.nglGetnConvolutionFilter(target, format, type, image.remaining(), MemoryUtil.memAddress((ByteBuffer)image));
    }

    public static native void nglGetnSeparableFilter(int var0, int var1, int var2, int var3, long var4, int var6, long var7, long var9);

    public static void glGetnSeparableFilter(int target, int format, int type, int rowBufSize, long row, int columnBufSize, long column, ByteBuffer span) {
        GL45.nglGetnSeparableFilter(target, format, type, rowBufSize, row, columnBufSize, column, MemoryUtil.memAddressSafe((ByteBuffer)span));
    }

    public static void glGetnSeparableFilter(int target, int format, int type, ByteBuffer row, ByteBuffer column, ByteBuffer span) {
        GL45.nglGetnSeparableFilter(target, format, type, row.remaining(), MemoryUtil.memAddress((ByteBuffer)row), column.remaining(), MemoryUtil.memAddress((ByteBuffer)column), MemoryUtil.memAddressSafe((ByteBuffer)span));
    }

    public static native void nglGetnHistogram(int var0, boolean var1, int var2, int var3, int var4, long var5);

    public static void glGetnHistogram(int target, boolean reset, int format, int type, int bufSize, long values) {
        GL45.nglGetnHistogram(target, reset, format, type, bufSize, values);
    }

    public static void glGetnHistogram(int target, boolean reset, int format, int type, ByteBuffer values) {
        GL45.nglGetnHistogram(target, reset, format, type, values.remaining(), MemoryUtil.memAddress((ByteBuffer)values));
    }

    public static native void nglGetnMinmax(int var0, boolean var1, int var2, int var3, int var4, long var5);

    public static void glGetnMinmax(int target, boolean reset, int format, int type, int bufSize, long values) {
        GL45.nglGetnMinmax(target, reset, format, type, bufSize, values);
    }

    public static void glGetnMinmax(int target, boolean reset, int format, int type, ByteBuffer values) {
        GL45.nglGetnMinmax(target, reset, format, type, values.remaining(), MemoryUtil.memAddress((ByteBuffer)values));
    }

    public static native void nglGetnCompressedTexImage(int var0, int var1, int var2, long var3);

    public static void glGetnCompressedTexImage(int target, int level, int bufSize, long img) {
        GL45.nglGetnCompressedTexImage(target, level, bufSize, img);
    }

    public static void glGetnCompressedTexImage(int target, int level, ByteBuffer img) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.check((Buffer)img, (int)GL11.glGetTexLevelParameteri(target, level, 34464));
        }
        GL45.nglGetnCompressedTexImage(target, level, img.remaining(), MemoryUtil.memAddress((ByteBuffer)img));
    }

    public static native void nglGetnUniformfv(int var0, int var1, int var2, long var3);

    public static void glGetnUniformfv(int program, int location, FloatBuffer params) {
        GL45.nglGetnUniformfv(program, location, params.remaining(), MemoryUtil.memAddress((FloatBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetnUniformf(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            GL45.nglGetnUniformfv(program, location, 1, MemoryUtil.memAddress((FloatBuffer)params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetnUniformdv(int var0, int var1, int var2, long var3);

    public static void glGetnUniformdv(int program, int location, DoubleBuffer params) {
        GL45.nglGetnUniformdv(program, location, params.remaining(), MemoryUtil.memAddress((DoubleBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double glGetnUniformd(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            DoubleBuffer params = stack.callocDouble(1);
            GL45.nglGetnUniformdv(program, location, 1, MemoryUtil.memAddress((DoubleBuffer)params));
            double d = params.get(0);
            return d;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetnUniformiv(int var0, int var1, int var2, long var3);

    public static void glGetnUniformiv(int program, int location, FloatBuffer params) {
        GL45.nglGetnUniformiv(program, location, params.remaining(), MemoryUtil.memAddress((FloatBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetnUniformi(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            GL45.nglGetnUniformiv(program, location, 1, MemoryUtil.memAddress((FloatBuffer)params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetnUniformuiv(int var0, int var1, int var2, long var3);

    public static void glGetnUniformuiv(int program, int location, FloatBuffer params) {
        GL45.nglGetnUniformuiv(program, location, params.remaining(), MemoryUtil.memAddress((FloatBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetnUniformui(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            GL45.nglGetnUniformuiv(program, location, 1, MemoryUtil.memAddress((FloatBuffer)params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glCreateTransformFeedbacks(int[] ids) {
        long __functionAddress = GL.getICD().glCreateTransformFeedbacks;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)ids.length, (int[])ids);
    }

    public static void glGetTransformFeedbackiv(int xfb, int pname, int[] param) {
        long __functionAddress = GL.getICD().glGetTransformFeedbackiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])param, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)xfb, (int)pname, (int[])param);
    }

    public static void glGetTransformFeedbacki_v(int xfb, int pname, int index, int[] param) {
        long __functionAddress = GL.getICD().glGetTransformFeedbacki_v;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])param, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)xfb, (int)pname, (int)index, (int[])param);
    }

    public static void glGetTransformFeedbacki64_v(int xfb, int pname, int index, long[] param) {
        long __functionAddress = GL.getICD().glGetTransformFeedbacki64_v;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])param, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)xfb, (int)pname, (int)index, (long[])param);
    }

    public static void glCreateBuffers(int[] buffers) {
        long __functionAddress = GL.getICD().glCreateBuffers;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)buffers.length, (int[])buffers);
    }

    public static void glNamedBufferStorage(int buffer, short[] data, int flags) {
        long __functionAddress = GL.getICD().glNamedBufferStorage;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)buffer, (long)(data.length << 1), (short[])data, (int)flags);
    }

    public static void glNamedBufferStorage(int buffer, int[] data, int flags) {
        long __functionAddress = GL.getICD().glNamedBufferStorage;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)buffer, (long)(data.length << 2), (int[])data, (int)flags);
    }

    public static void glNamedBufferStorage(int buffer, float[] data, int flags) {
        long __functionAddress = GL.getICD().glNamedBufferStorage;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)buffer, (long)(data.length << 2), (float[])data, (int)flags);
    }

    public static void glNamedBufferStorage(int buffer, double[] data, int flags) {
        long __functionAddress = GL.getICD().glNamedBufferStorage;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)buffer, (long)(data.length << 3), (double[])data, (int)flags);
    }

    public static void glNamedBufferData(int buffer, short[] data, int usage) {
        long __functionAddress = GL.getICD().glNamedBufferData;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)buffer, (long)(data.length << 1), (short[])data, (int)usage);
    }

    public static void glNamedBufferData(int buffer, int[] data, int usage) {
        long __functionAddress = GL.getICD().glNamedBufferData;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)buffer, (long)(data.length << 2), (int[])data, (int)usage);
    }

    public static void glNamedBufferData(int buffer, float[] data, int usage) {
        long __functionAddress = GL.getICD().glNamedBufferData;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)buffer, (long)(data.length << 2), (float[])data, (int)usage);
    }

    public static void glNamedBufferData(int buffer, double[] data, int usage) {
        long __functionAddress = GL.getICD().glNamedBufferData;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPV((long)__functionAddress, (int)buffer, (long)(data.length << 3), (double[])data, (int)usage);
    }

    public static void glNamedBufferSubData(int buffer, long offset, short[] data) {
        long __functionAddress = GL.getICD().glNamedBufferSubData;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)buffer, (long)offset, (long)(data.length << 1), (short[])data);
    }

    public static void glNamedBufferSubData(int buffer, long offset, int[] data) {
        long __functionAddress = GL.getICD().glNamedBufferSubData;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)buffer, (long)offset, (long)(data.length << 2), (int[])data);
    }

    public static void glNamedBufferSubData(int buffer, long offset, float[] data) {
        long __functionAddress = GL.getICD().glNamedBufferSubData;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)buffer, (long)offset, (long)(data.length << 2), (float[])data);
    }

    public static void glNamedBufferSubData(int buffer, long offset, double[] data) {
        long __functionAddress = GL.getICD().glNamedBufferSubData;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)buffer, (long)offset, (long)(data.length << 3), (double[])data);
    }

    public static void glGetNamedBufferParameteriv(int buffer, int pname, int[] params) {
        long __functionAddress = GL.getICD().glGetNamedBufferParameteriv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)buffer, (int)pname, (int[])params);
    }

    public static void glGetNamedBufferParameteri64v(int buffer, int pname, long[] params) {
        long __functionAddress = GL.getICD().glGetNamedBufferParameteri64v;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)buffer, (int)pname, (long[])params);
    }

    public static void glGetNamedBufferSubData(int buffer, long offset, short[] data) {
        long __functionAddress = GL.getICD().glGetNamedBufferSubData;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)buffer, (long)offset, (long)(data.length << 1), (short[])data);
    }

    public static void glGetNamedBufferSubData(int buffer, long offset, int[] data) {
        long __functionAddress = GL.getICD().glGetNamedBufferSubData;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)buffer, (long)offset, (long)(data.length << 2), (int[])data);
    }

    public static void glGetNamedBufferSubData(int buffer, long offset, float[] data) {
        long __functionAddress = GL.getICD().glGetNamedBufferSubData;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)buffer, (long)offset, (long)(data.length << 2), (float[])data);
    }

    public static void glGetNamedBufferSubData(int buffer, long offset, double[] data) {
        long __functionAddress = GL.getICD().glGetNamedBufferSubData;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPPV((long)__functionAddress, (int)buffer, (long)offset, (long)(data.length << 3), (double[])data);
    }

    public static void glCreateFramebuffers(int[] framebuffers) {
        long __functionAddress = GL.getICD().glCreateFramebuffers;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)framebuffers.length, (int[])framebuffers);
    }

    public static void glNamedFramebufferDrawBuffers(int framebuffer, int[] bufs) {
        long __functionAddress = GL.getICD().glNamedFramebufferDrawBuffers;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)framebuffer, (int)bufs.length, (int[])bufs);
    }

    public static void glInvalidateNamedFramebufferData(int framebuffer, int[] attachments) {
        long __functionAddress = GL.getICD().glInvalidateNamedFramebufferData;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)framebuffer, (int)attachments.length, (int[])attachments);
    }

    public static void glInvalidateNamedFramebufferSubData(int framebuffer, int[] attachments, int x, int y, int width, int height) {
        long __functionAddress = GL.getICD().glInvalidateNamedFramebufferSubData;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)framebuffer, (int)attachments.length, (int[])attachments, (int)x, (int)y, (int)width, (int)height);
    }

    public static void glClearNamedFramebufferiv(int framebuffer, int buffer, int drawbuffer, int[] value) {
        long __functionAddress = GL.getICD().glClearNamedFramebufferiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])value, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)framebuffer, (int)buffer, (int)drawbuffer, (int[])value);
    }

    public static void glClearNamedFramebufferuiv(int framebuffer, int buffer, int drawbuffer, int[] value) {
        long __functionAddress = GL.getICD().glClearNamedFramebufferuiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])value, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)framebuffer, (int)buffer, (int)drawbuffer, (int[])value);
    }

    public static void glClearNamedFramebufferfv(int framebuffer, int buffer, int drawbuffer, float[] value) {
        long __functionAddress = GL.getICD().glClearNamedFramebufferfv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((float[])value, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)framebuffer, (int)buffer, (int)drawbuffer, (float[])value);
    }

    public static void glGetNamedFramebufferParameteriv(int framebuffer, int pname, int[] params) {
        long __functionAddress = GL.getICD().glGetNamedFramebufferParameteriv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)framebuffer, (int)pname, (int[])params);
    }

    public static void glGetNamedFramebufferAttachmentParameteriv(int framebuffer, int attachment, int pname, int[] params) {
        long __functionAddress = GL.getICD().glGetNamedFramebufferAttachmentParameteriv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)framebuffer, (int)attachment, (int)pname, (int[])params);
    }

    public static void glCreateRenderbuffers(int[] renderbuffers) {
        long __functionAddress = GL.getICD().glCreateRenderbuffers;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)renderbuffers.length, (int[])renderbuffers);
    }

    public static void glGetNamedRenderbufferParameteriv(int renderbuffer, int pname, int[] params) {
        long __functionAddress = GL.getICD().glGetNamedRenderbufferParameteriv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)renderbuffer, (int)pname, (int[])params);
    }

    public static void glCreateTextures(int target, int[] textures) {
        long __functionAddress = GL.getICD().glCreateTextures;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)textures.length, (int[])textures);
    }

    public static void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, short[] pixels) {
        long __functionAddress = GL.getICD().glTextureSubImage1D;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)level, (int)xoffset, (int)width, (int)format, (int)type, (short[])pixels);
    }

    public static void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, int[] pixels) {
        long __functionAddress = GL.getICD().glTextureSubImage1D;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)level, (int)xoffset, (int)width, (int)format, (int)type, (int[])pixels);
    }

    public static void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, float[] pixels) {
        long __functionAddress = GL.getICD().glTextureSubImage1D;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)level, (int)xoffset, (int)width, (int)format, (int)type, (float[])pixels);
    }

    public static void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, double[] pixels) {
        long __functionAddress = GL.getICD().glTextureSubImage1D;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)level, (int)xoffset, (int)width, (int)format, (int)type, (double[])pixels);
    }

    public static void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, short[] pixels) {
        long __functionAddress = GL.getICD().glTextureSubImage2D;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (short[])pixels);
    }

    public static void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, int[] pixels) {
        long __functionAddress = GL.getICD().glTextureSubImage2D;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (int[])pixels);
    }

    public static void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, float[] pixels) {
        long __functionAddress = GL.getICD().glTextureSubImage2D;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (float[])pixels);
    }

    public static void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, double[] pixels) {
        long __functionAddress = GL.getICD().glTextureSubImage2D;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (double[])pixels);
    }

    public static void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, short[] pixels) {
        long __functionAddress = GL.getICD().glTextureSubImage3D;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)format, (int)type, (short[])pixels);
    }

    public static void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, int[] pixels) {
        long __functionAddress = GL.getICD().glTextureSubImage3D;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)format, (int)type, (int[])pixels);
    }

    public static void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, float[] pixels) {
        long __functionAddress = GL.getICD().glTextureSubImage3D;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)format, (int)type, (float[])pixels);
    }

    public static void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, double[] pixels) {
        long __functionAddress = GL.getICD().glTextureSubImage3D;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)format, (int)type, (double[])pixels);
    }

    public static void glTextureParameterfv(int texture, int pname, float[] params) {
        long __functionAddress = GL.getICD().glTextureParameterfv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((float[])params, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)pname, (float[])params);
    }

    public static void glTextureParameterIiv(int texture, int pname, int[] params) {
        long __functionAddress = GL.getICD().glTextureParameterIiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)pname, (int[])params);
    }

    public static void glTextureParameterIuiv(int texture, int pname, int[] params) {
        long __functionAddress = GL.getICD().glTextureParameterIuiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)pname, (int[])params);
    }

    public static void glTextureParameteriv(int texture, int pname, int[] params) {
        long __functionAddress = GL.getICD().glTextureParameteriv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])params, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)pname, (int[])params);
    }

    public static void glGetTextureImage(int texture, int level, int format, int type, short[] pixels) {
        long __functionAddress = GL.getICD().glGetTextureImage;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)level, (int)format, (int)type, (int)(pixels.length << 1), (short[])pixels);
    }

    public static void glGetTextureImage(int texture, int level, int format, int type, int[] pixels) {
        long __functionAddress = GL.getICD().glGetTextureImage;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)level, (int)format, (int)type, (int)(pixels.length << 2), (int[])pixels);
    }

    public static void glGetTextureImage(int texture, int level, int format, int type, float[] pixels) {
        long __functionAddress = GL.getICD().glGetTextureImage;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)level, (int)format, (int)type, (int)(pixels.length << 2), (float[])pixels);
    }

    public static void glGetTextureImage(int texture, int level, int format, int type, double[] pixels) {
        long __functionAddress = GL.getICD().glGetTextureImage;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)level, (int)format, (int)type, (int)(pixels.length << 3), (double[])pixels);
    }

    public static void glGetTextureLevelParameterfv(int texture, int level, int pname, float[] params) {
        long __functionAddress = GL.getICD().glGetTextureLevelParameterfv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((float[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)level, (int)pname, (float[])params);
    }

    public static void glGetTextureLevelParameteriv(int texture, int level, int pname, int[] params) {
        long __functionAddress = GL.getICD().glGetTextureLevelParameteriv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)level, (int)pname, (int[])params);
    }

    public static void glGetTextureParameterfv(int texture, int pname, float[] params) {
        long __functionAddress = GL.getICD().glGetTextureParameterfv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((float[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)pname, (float[])params);
    }

    public static void glGetTextureParameterIiv(int texture, int pname, int[] params) {
        long __functionAddress = GL.getICD().glGetTextureParameterIiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)pname, (int[])params);
    }

    public static void glGetTextureParameterIuiv(int texture, int pname, int[] params) {
        long __functionAddress = GL.getICD().glGetTextureParameterIuiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)pname, (int[])params);
    }

    public static void glGetTextureParameteriv(int texture, int pname, int[] params) {
        long __functionAddress = GL.getICD().glGetTextureParameteriv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)pname, (int[])params);
    }

    public static void glCreateVertexArrays(int[] arrays) {
        long __functionAddress = GL.getICD().glCreateVertexArrays;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)arrays.length, (int[])arrays);
    }

    public static void glVertexArrayVertexBuffers(int vaobj, int first, int[] buffers, PointerBuffer offsets, int[] strides) {
        long __functionAddress = GL.getICD().glVertexArrayVertexBuffers;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((CustomBuffer)offsets, (int)Checks.lengthSafe((int[])buffers));
            Checks.checkSafe((int[])strides, (int)Checks.lengthSafe((int[])buffers));
        }
        JNI.callPPPV((long)__functionAddress, (int)vaobj, (int)first, (int)Checks.lengthSafe((int[])buffers), (int[])buffers, (long)MemoryUtil.memAddressSafe((Pointer)offsets), (int[])strides);
    }

    public static void glGetVertexArrayiv(int vaobj, int pname, int[] param) {
        long __functionAddress = GL.getICD().glGetVertexArrayiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])param, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)vaobj, (int)pname, (int[])param);
    }

    public static void glGetVertexArrayIndexediv(int vaobj, int index, int pname, int[] param) {
        long __functionAddress = GL.getICD().glGetVertexArrayIndexediv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])param, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)vaobj, (int)index, (int)pname, (int[])param);
    }

    public static void glGetVertexArrayIndexed64iv(int vaobj, int index, int pname, long[] param) {
        long __functionAddress = GL.getICD().glGetVertexArrayIndexed64iv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])param, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)vaobj, (int)index, (int)pname, (long[])param);
    }

    public static void glCreateSamplers(int[] samplers) {
        long __functionAddress = GL.getICD().glCreateSamplers;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)samplers.length, (int[])samplers);
    }

    public static void glCreateProgramPipelines(int[] pipelines) {
        long __functionAddress = GL.getICD().glCreateProgramPipelines;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)pipelines.length, (int[])pipelines);
    }

    public static void glCreateQueries(int target, int[] ids) {
        long __functionAddress = GL.getICD().glCreateQueries;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)ids.length, (int[])ids);
    }

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, short[] pixels) {
        long __functionAddress = GL.getICD().glGetTextureSubImage;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)format, (int)type, (int)(pixels.length << 1), (short[])pixels);
    }

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, int[] pixels) {
        long __functionAddress = GL.getICD().glGetTextureSubImage;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)format, (int)type, (int)(pixels.length << 2), (int[])pixels);
    }

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, float[] pixels) {
        long __functionAddress = GL.getICD().glGetTextureSubImage;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)format, (int)type, (int)(pixels.length << 2), (float[])pixels);
    }

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, double[] pixels) {
        long __functionAddress = GL.getICD().glGetTextureSubImage;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)format, (int)type, (int)(pixels.length << 3), (double[])pixels);
    }

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, short[] pixels) {
        long __functionAddress = GL.getICD().glGetCompressedTextureSubImage;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)(pixels.length << 1), (short[])pixels);
    }

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int[] pixels) {
        long __functionAddress = GL.getICD().glGetCompressedTextureSubImage;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)(pixels.length << 2), (int[])pixels);
    }

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, float[] pixels) {
        long __functionAddress = GL.getICD().glGetCompressedTextureSubImage;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)(pixels.length << 2), (float[])pixels);
    }

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, double[] pixels) {
        long __functionAddress = GL.getICD().glGetCompressedTextureSubImage;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)texture, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)(pixels.length << 3), (double[])pixels);
    }

    public static void glGetnMapdv(int target, int query, double[] data) {
        long __functionAddress = GL.getICD().glGetnMapdv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)query, (int)data.length, (double[])data);
    }

    public static void glGetnMapfv(int target, int query, float[] data) {
        long __functionAddress = GL.getICD().glGetnMapfv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)query, (int)data.length, (float[])data);
    }

    public static void glGetnMapiv(int target, int query, int[] data) {
        long __functionAddress = GL.getICD().glGetnMapiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)query, (int)data.length, (int[])data);
    }

    public static void glGetnPixelMapfv(int map, float[] data) {
        long __functionAddress = GL.getICD().glGetnPixelMapfv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)map, (int)data.length, (float[])data);
    }

    public static void glGetnPixelMapuiv(int map, int[] data) {
        long __functionAddress = GL.getICD().glGetnPixelMapuiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)map, (int)data.length, (int[])data);
    }

    public static void glGetnPixelMapusv(int map, short[] data) {
        long __functionAddress = GL.getICD().glGetnPixelMapusv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)map, (int)data.length, (short[])data);
    }

    public static void glGetnTexImage(int tex, int level, int format, int type, short[] img) {
        long __functionAddress = GL.getICD().glGetnTexImage;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)tex, (int)level, (int)format, (int)type, (int)(img.length << 1), (short[])img);
    }

    public static void glGetnTexImage(int tex, int level, int format, int type, int[] img) {
        long __functionAddress = GL.getICD().glGetnTexImage;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)tex, (int)level, (int)format, (int)type, (int)(img.length << 2), (int[])img);
    }

    public static void glGetnTexImage(int tex, int level, int format, int type, float[] img) {
        long __functionAddress = GL.getICD().glGetnTexImage;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)tex, (int)level, (int)format, (int)type, (int)(img.length << 2), (float[])img);
    }

    public static void glGetnTexImage(int tex, int level, int format, int type, double[] img) {
        long __functionAddress = GL.getICD().glGetnTexImage;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)tex, (int)level, (int)format, (int)type, (int)(img.length << 3), (double[])img);
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, short[] pixels) {
        long __functionAddress = GL.getICD().glReadnPixels;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (int)(pixels.length << 1), (short[])pixels);
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, int[] pixels) {
        long __functionAddress = GL.getICD().glReadnPixels;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (int)(pixels.length << 2), (int[])pixels);
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, float[] pixels) {
        long __functionAddress = GL.getICD().glReadnPixels;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (int)(pixels.length << 2), (float[])pixels);
    }

    public static void glGetnColorTable(int target, int format, int type, short[] table) {
        long __functionAddress = GL.getICD().glGetnColorTable;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)format, (int)type, (int)(table.length << 1), (short[])table);
    }

    public static void glGetnColorTable(int target, int format, int type, int[] table) {
        long __functionAddress = GL.getICD().glGetnColorTable;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)format, (int)type, (int)(table.length << 2), (int[])table);
    }

    public static void glGetnColorTable(int target, int format, int type, float[] table) {
        long __functionAddress = GL.getICD().glGetnColorTable;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)format, (int)type, (int)(table.length << 2), (float[])table);
    }

    public static void glGetnUniformfv(int program, int location, float[] params) {
        long __functionAddress = GL.getICD().glGetnUniformfv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)params.length, (float[])params);
    }

    public static void glGetnUniformdv(int program, int location, double[] params) {
        long __functionAddress = GL.getICD().glGetnUniformdv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)params.length, (double[])params);
    }

    public static void glGetnUniformiv(int program, int location, float[] params) {
        long __functionAddress = GL.getICD().glGetnUniformiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)params.length, (float[])params);
    }

    public static void glGetnUniformuiv(int program, int location, float[] params) {
        long __functionAddress = GL.getICD().glGetnUniformuiv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)params.length, (float[])params);
    }

    static {
        GL.initialize();
    }
}

