/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class GL32 {
    public static final int GL_CONTEXT_PROFILE_MASK = 37158;
    public static final int GL_CONTEXT_CORE_PROFILE_BIT = 1;
    public static final int GL_CONTEXT_COMPATIBILITY_PROFILE_BIT = 2;
    public static final int GL_MAX_VERTEX_OUTPUT_COMPONENTS = 37154;
    public static final int GL_MAX_GEOMETRY_INPUT_COMPONENTS = 37155;
    public static final int GL_MAX_GEOMETRY_OUTPUT_COMPONENTS = 37156;
    public static final int GL_MAX_FRAGMENT_INPUT_COMPONENTS = 37157;
    public static final int GL_FIRST_VERTEX_CONVENTION = 36429;
    public static final int GL_LAST_VERTEX_CONVENTION = 36430;
    public static final int GL_PROVOKING_VERTEX = 36431;
    public static final int GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION = 36428;
    public static final int GL_TEXTURE_CUBE_MAP_SEAMLESS = 34895;
    public static final int GL_SAMPLE_POSITION = 36432;
    public static final int GL_SAMPLE_MASK = 36433;
    public static final int GL_SAMPLE_MASK_VALUE = 36434;
    public static final int GL_TEXTURE_2D_MULTISAMPLE = 37120;
    public static final int GL_PROXY_TEXTURE_2D_MULTISAMPLE = 37121;
    public static final int GL_TEXTURE_2D_MULTISAMPLE_ARRAY = 37122;
    public static final int GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY = 37123;
    public static final int GL_MAX_SAMPLE_MASK_WORDS = 36441;
    public static final int GL_MAX_COLOR_TEXTURE_SAMPLES = 37134;
    public static final int GL_MAX_DEPTH_TEXTURE_SAMPLES = 37135;
    public static final int GL_MAX_INTEGER_SAMPLES = 37136;
    public static final int GL_TEXTURE_BINDING_2D_MULTISAMPLE = 37124;
    public static final int GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY = 37125;
    public static final int GL_TEXTURE_SAMPLES = 37126;
    public static final int GL_TEXTURE_FIXED_SAMPLE_LOCATIONS = 37127;
    public static final int GL_SAMPLER_2D_MULTISAMPLE = 37128;
    public static final int GL_INT_SAMPLER_2D_MULTISAMPLE = 37129;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE = 37130;
    public static final int GL_SAMPLER_2D_MULTISAMPLE_ARRAY = 37131;
    public static final int GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 37132;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 37133;
    public static final int GL_DEPTH_CLAMP = 34383;
    public static final int GL_GEOMETRY_SHADER = 36313;
    public static final int GL_GEOMETRY_VERTICES_OUT = 36314;
    public static final int GL_GEOMETRY_INPUT_TYPE = 36315;
    public static final int GL_GEOMETRY_OUTPUT_TYPE = 36316;
    public static final int GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS = 35881;
    public static final int GL_MAX_GEOMETRY_UNIFORM_COMPONENTS = 36319;
    public static final int GL_MAX_GEOMETRY_OUTPUT_VERTICES = 36320;
    public static final int GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS = 36321;
    public static final int GL_LINES_ADJACENCY = 10;
    public static final int GL_LINE_STRIP_ADJACENCY = 11;
    public static final int GL_TRIANGLES_ADJACENCY = 12;
    public static final int GL_TRIANGLE_STRIP_ADJACENCY = 13;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS = 36264;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_LAYERED = 36263;
    public static final int GL_PROGRAM_POINT_SIZE = 34370;
    public static final int GL_MAX_SERVER_WAIT_TIMEOUT = 37137;
    public static final int GL_OBJECT_TYPE = 37138;
    public static final int GL_SYNC_CONDITION = 37139;
    public static final int GL_SYNC_STATUS = 37140;
    public static final int GL_SYNC_FLAGS = 37141;
    public static final int GL_SYNC_FENCE = 37142;
    public static final int GL_SYNC_GPU_COMMANDS_COMPLETE = 37143;
    public static final int GL_UNSIGNALED = 37144;
    public static final int GL_SIGNALED = 37145;
    public static final int GL_SYNC_FLUSH_COMMANDS_BIT = 1;
    public static final long GL_TIMEOUT_IGNORED = -1L;
    public static final int GL_ALREADY_SIGNALED = 37146;
    public static final int GL_TIMEOUT_EXPIRED = 37147;
    public static final int GL_CONDITION_SATISFIED = 37148;
    public static final int GL_WAIT_FAILED = 37149;

    protected GL32() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glGetBufferParameteri64v, caps.glDrawElementsBaseVertex, caps.glDrawRangeElementsBaseVertex, caps.glDrawElementsInstancedBaseVertex, caps.glMultiDrawElementsBaseVertex, caps.glProvokingVertex, caps.glTexImage2DMultisample, caps.glTexImage3DMultisample, caps.glGetMultisamplefv, caps.glSampleMaski, caps.glFramebufferTexture, caps.glFenceSync, caps.glIsSync, caps.glDeleteSync, caps.glClientWaitSync, caps.glWaitSync, caps.glGetInteger64v, caps.glGetInteger64i_v, caps.glGetSynciv});
    }

    public static native void nglGetBufferParameteri64v(int var0, int var1, long var2);

    public static void glGetBufferParameteri64v(int target, int pname, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GL32.nglGetBufferParameteri64v(target, pname, MemoryUtil.memAddress((LongBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetBufferParameteri64(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer params = stack.callocLong(1);
            GL32.nglGetBufferParameteri64v(target, pname, MemoryUtil.memAddress((LongBuffer)params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglDrawElementsBaseVertex(int var0, int var1, int var2, long var3, int var5);

    public static void glDrawElementsBaseVertex(int mode, int count, int type, long indices, int basevertex) {
        GL32.nglDrawElementsBaseVertex(mode, count, type, indices, basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, int type, ByteBuffer indices, int basevertex) {
        GL32.nglDrawElementsBaseVertex(mode, indices.remaining() >> GLChecks.typeToByteShift(type), type, MemoryUtil.memAddress((ByteBuffer)indices), basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, ByteBuffer indices, int basevertex) {
        GL32.nglDrawElementsBaseVertex(mode, indices.remaining(), 5121, MemoryUtil.memAddress((ByteBuffer)indices), basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, ShortBuffer indices, int basevertex) {
        GL32.nglDrawElementsBaseVertex(mode, indices.remaining(), 5123, MemoryUtil.memAddress((ShortBuffer)indices), basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, IntBuffer indices, int basevertex) {
        GL32.nglDrawElementsBaseVertex(mode, indices.remaining(), 5125, MemoryUtil.memAddress((IntBuffer)indices), basevertex);
    }

    public static native void nglDrawRangeElementsBaseVertex(int var0, int var1, int var2, int var3, int var4, long var5, int var7);

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, int count, int type, long indices, int basevertex) {
        GL32.nglDrawRangeElementsBaseVertex(mode, start, end, count, type, indices, basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, int type, ByteBuffer indices, int basevertex) {
        GL32.nglDrawRangeElementsBaseVertex(mode, start, end, indices.remaining() >> GLChecks.typeToByteShift(type), type, MemoryUtil.memAddress((ByteBuffer)indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, ByteBuffer indices, int basevertex) {
        GL32.nglDrawRangeElementsBaseVertex(mode, start, end, indices.remaining(), 5121, MemoryUtil.memAddress((ByteBuffer)indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, ShortBuffer indices, int basevertex) {
        GL32.nglDrawRangeElementsBaseVertex(mode, start, end, indices.remaining(), 5123, MemoryUtil.memAddress((ShortBuffer)indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, IntBuffer indices, int basevertex) {
        GL32.nglDrawRangeElementsBaseVertex(mode, start, end, indices.remaining(), 5125, MemoryUtil.memAddress((IntBuffer)indices), basevertex);
    }

    public static native void nglDrawElementsInstancedBaseVertex(int var0, int var1, int var2, long var3, int var5, int var6);

    public static void glDrawElementsInstancedBaseVertex(int mode, int count, int type, long indices, int primcount, int basevertex) {
        GL32.nglDrawElementsInstancedBaseVertex(mode, count, type, indices, primcount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, int type, ByteBuffer indices, int primcount, int basevertex) {
        GL32.nglDrawElementsInstancedBaseVertex(mode, indices.remaining() >> GLChecks.typeToByteShift(type), type, MemoryUtil.memAddress((ByteBuffer)indices), primcount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, ByteBuffer indices, int primcount, int basevertex) {
        GL32.nglDrawElementsInstancedBaseVertex(mode, indices.remaining(), 5121, MemoryUtil.memAddress((ByteBuffer)indices), primcount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, ShortBuffer indices, int primcount, int basevertex) {
        GL32.nglDrawElementsInstancedBaseVertex(mode, indices.remaining(), 5123, MemoryUtil.memAddress((ShortBuffer)indices), primcount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, IntBuffer indices, int primcount, int basevertex) {
        GL32.nglDrawElementsInstancedBaseVertex(mode, indices.remaining(), 5125, MemoryUtil.memAddress((IntBuffer)indices), primcount, basevertex);
    }

    public static native void nglMultiDrawElementsBaseVertex(int var0, long var1, int var3, long var4, int var6, long var7);

    public static void glMultiDrawElementsBaseVertex(int mode, IntBuffer count, int type, PointerBuffer indices, IntBuffer basevertex) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)indices, (int)count.remaining());
            Checks.check((Buffer)basevertex, (int)count.remaining());
        }
        GL32.nglMultiDrawElementsBaseVertex(mode, MemoryUtil.memAddress((IntBuffer)count), type, MemoryUtil.memAddress((CustomBuffer)indices), count.remaining(), MemoryUtil.memAddress((IntBuffer)basevertex));
    }

    public static native void glProvokingVertex(int var0);

    public static native void glTexImage2DMultisample(int var0, int var1, int var2, int var3, int var4, boolean var5);

    public static native void glTexImage3DMultisample(int var0, int var1, int var2, int var3, int var4, int var5, boolean var6);

    public static native void nglGetMultisamplefv(int var0, int var1, long var2);

    public static void glGetMultisamplefv(int pname, int index, FloatBuffer val) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)val, (int)1);
        }
        GL32.nglGetMultisamplefv(pname, index, MemoryUtil.memAddress((FloatBuffer)val));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetMultisamplef(int pname, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer val = stack.callocFloat(1);
            GL32.nglGetMultisamplefv(pname, index, MemoryUtil.memAddress((FloatBuffer)val));
            float f = val.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glSampleMaski(int var0, int var1);

    public static native void glFramebufferTexture(int var0, int var1, int var2, int var3);

    public static native long glFenceSync(int var0, int var1);

    public static native boolean nglIsSync(long var0);

    public static boolean glIsSync(long sync) {
        if (Checks.CHECKS) {
            Checks.check((long)sync);
        }
        return GL32.nglIsSync(sync);
    }

    public static native void nglDeleteSync(long var0);

    public static void glDeleteSync(long sync) {
        if (Checks.CHECKS) {
            Checks.check((long)sync);
        }
        GL32.nglDeleteSync(sync);
    }

    public static native int nglClientWaitSync(long var0, int var2, long var3);

    public static int glClientWaitSync(long sync, int flags, long timeout) {
        if (Checks.CHECKS) {
            Checks.check((long)sync);
        }
        return GL32.nglClientWaitSync(sync, flags, timeout);
    }

    public static native void nglWaitSync(long var0, int var2, long var3);

    public static void glWaitSync(long sync, int flags, long timeout) {
        if (Checks.CHECKS) {
            Checks.check((long)sync);
        }
        GL32.nglWaitSync(sync, flags, timeout);
    }

    public static native void nglGetInteger64v(int var0, long var1);

    public static void glGetInteger64v(int pname, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GL32.nglGetInteger64v(pname, MemoryUtil.memAddress((LongBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetInteger64(int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer params = stack.callocLong(1);
            GL32.nglGetInteger64v(pname, MemoryUtil.memAddress((LongBuffer)params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetInteger64i_v(int var0, int var1, long var2);

    public static void glGetInteger64i_v(int pname, int index, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        GL32.nglGetInteger64i_v(pname, index, MemoryUtil.memAddress((LongBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetInteger64i(int pname, int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer params = stack.callocLong(1);
            GL32.nglGetInteger64i_v(pname, index, MemoryUtil.memAddress((LongBuffer)params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetSynciv(long var0, int var2, int var3, long var4, long var6);

    public static void glGetSynciv(long sync, int pname, IntBuffer length, IntBuffer values) {
        if (Checks.CHECKS) {
            Checks.check((long)sync);
            Checks.checkSafe((Buffer)length, (int)1);
        }
        GL32.nglGetSynciv(sync, pname, values.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((IntBuffer)values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetSynci(long sync, int pname, IntBuffer length) {
        if (Checks.CHECKS) {
            Checks.check((long)sync);
            Checks.checkSafe((Buffer)length, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer values = stack.callocInt(1);
            GL32.nglGetSynciv(sync, pname, 1, MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((IntBuffer)values));
            int n = values.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glGetBufferParameteri64v(int target, int pname, long[] params) {
        long __functionAddress = GL.getICD().glGetBufferParameteri64v;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)pname, (long[])params);
    }

    public static void glMultiDrawElementsBaseVertex(int mode, int[] count, int type, PointerBuffer indices, int[] basevertex) {
        long __functionAddress = GL.getICD().glMultiDrawElementsBaseVertex;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((CustomBuffer)indices, (int)count.length);
            Checks.check((int[])basevertex, (int)count.length);
        }
        JNI.callPPPV((long)__functionAddress, (int)mode, (int[])count, (int)type, (long)MemoryUtil.memAddress((CustomBuffer)indices), (int)count.length, (int[])basevertex);
    }

    public static void glGetMultisamplefv(int pname, int index, float[] val) {
        long __functionAddress = GL.getICD().glGetMultisamplefv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((float[])val, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)pname, (int)index, (float[])val);
    }

    public static void glGetInteger64v(int pname, long[] params) {
        long __functionAddress = GL.getICD().glGetInteger64v;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)pname, (long[])params);
    }

    public static void glGetInteger64i_v(int pname, int index, long[] params) {
        long __functionAddress = GL.getICD().glGetInteger64i_v;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)pname, (int)index, (long[])params);
    }

    public static void glGetSynciv(long sync, int pname, int[] length, int[] values) {
        long __functionAddress = GL.getICD().glGetSynciv;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)sync);
            Checks.checkSafe((int[])length, (int)1);
        }
        JNI.callPPPV((long)__functionAddress, (long)sync, (int)pname, (int)values.length, (int[])length, (int[])values);
    }

    static {
        GL.initialize();
    }
}

