/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class EXTSeparateShaderObjects {
    public static final int GL_ACTIVE_PROGRAM_EXT = 35725;

    protected EXTSeparateShaderObjects() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glUseShaderProgramEXT, caps.glActiveProgramEXT, caps.glCreateShaderProgramEXT});
    }

    public static native void glUseShaderProgramEXT(int var0, int var1);

    public static native void glActiveProgramEXT(int var0);

    public static native int nglCreateShaderProgramEXT(int var0, long var1);

    public static int glCreateShaderProgramEXT(int type, ByteBuffer string) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)string);
        }
        return EXTSeparateShaderObjects.nglCreateShaderProgramEXT(type, MemoryUtil.memAddress((ByteBuffer)string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreateShaderProgramEXT(int type, CharSequence string) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer stringEncoded = stack.UTF8(string);
            int n = EXTSeparateShaderObjects.nglCreateShaderProgramEXT(type, MemoryUtil.memAddress((ByteBuffer)stringEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    static {
        GL.initialize();
    }
}

