/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBTransposeMatrix {
    public static final int GL_TRANSPOSE_MODELVIEW_MATRIX_ARB = 34019;
    public static final int GL_TRANSPOSE_PROJECTION_MATRIX_ARB = 34020;
    public static final int GL_TRANSPOSE_TEXTURE_MATRIX_ARB = 34021;
    public static final int GL_TRANSPOSE_COLOR_MATRIX_ARB = 34022;

    protected ARBTransposeMatrix() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glLoadTransposeMatrixfARB, caps.glLoadTransposeMatrixdARB, caps.glMultTransposeMatrixfARB, caps.glMultTransposeMatrixdARB});
    }

    public static native void nglLoadTransposeMatrixfARB(long var0);

    public static void glLoadTransposeMatrixfARB(FloatBuffer m) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)m, (int)16);
        }
        ARBTransposeMatrix.nglLoadTransposeMatrixfARB(MemoryUtil.memAddress((FloatBuffer)m));
    }

    public static native void nglLoadTransposeMatrixdARB(long var0);

    public static void glLoadTransposeMatrixdARB(DoubleBuffer m) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)m, (int)16);
        }
        ARBTransposeMatrix.nglLoadTransposeMatrixdARB(MemoryUtil.memAddress((DoubleBuffer)m));
    }

    public static native void nglMultTransposeMatrixfARB(long var0);

    public static void glMultTransposeMatrixfARB(FloatBuffer m) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)m, (int)16);
        }
        ARBTransposeMatrix.nglMultTransposeMatrixfARB(MemoryUtil.memAddress((FloatBuffer)m));
    }

    public static native void nglMultTransposeMatrixdARB(long var0);

    public static void glMultTransposeMatrixdARB(DoubleBuffer m) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)m, (int)16);
        }
        ARBTransposeMatrix.nglMultTransposeMatrixdARB(MemoryUtil.memAddress((DoubleBuffer)m));
    }

    public static void glLoadTransposeMatrixfARB(float[] m) {
        long __functionAddress = GL.getICD().glLoadTransposeMatrixfARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((float[])m, (int)16);
        }
        JNI.callPV((long)__functionAddress, (float[])m);
    }

    public static void glLoadTransposeMatrixdARB(double[] m) {
        long __functionAddress = GL.getICD().glLoadTransposeMatrixdARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((double[])m, (int)16);
        }
        JNI.callPV((long)__functionAddress, (double[])m);
    }

    public static void glMultTransposeMatrixfARB(float[] m) {
        long __functionAddress = GL.getICD().glMultTransposeMatrixfARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((float[])m, (int)16);
        }
        JNI.callPV((long)__functionAddress, (float[])m);
    }

    public static void glMultTransposeMatrixdARB(double[] m) {
        long __functionAddress = GL.getICD().glMultTransposeMatrixdARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((double[])m, (int)16);
        }
        JNI.callPV((long)__functionAddress, (double[])m);
    }

    static {
        GL.initialize();
    }
}

