/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ARBShadingLanguageInclude {
    public static final int GL_SHADER_INCLUDE_ARB = 36270;
    public static final int GL_NAMED_STRING_LENGTH_ARB = 36329;
    public static final int GL_NAMED_STRING_TYPE_ARB = 36330;

    protected ARBShadingLanguageInclude() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glNamedStringARB, caps.glDeleteNamedStringARB, caps.glCompileShaderIncludeARB, caps.glIsNamedStringARB, caps.glGetNamedStringARB, caps.glGetNamedStringivARB});
    }

    public static native void nglNamedStringARB(int var0, int var1, long var2, int var4, long var5);

    public static void glNamedStringARB(int type, ByteBuffer name, ByteBuffer string) {
        ARBShadingLanguageInclude.nglNamedStringARB(type, name.remaining(), MemoryUtil.memAddress((ByteBuffer)name), string.remaining(), MemoryUtil.memAddress((ByteBuffer)string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glNamedStringARB(int type, CharSequence name, CharSequence string) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name, false);
            ByteBuffer stringEncoded = stack.UTF8(string, false);
            ARBShadingLanguageInclude.nglNamedStringARB(type, nameEncoded.remaining(), MemoryUtil.memAddress((ByteBuffer)nameEncoded), stringEncoded.remaining(), MemoryUtil.memAddress((ByteBuffer)stringEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglDeleteNamedStringARB(int var0, long var1);

    public static void glDeleteNamedStringARB(ByteBuffer name) {
        ARBShadingLanguageInclude.nglDeleteNamedStringARB(name.remaining(), MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteNamedStringARB(CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name, false);
            ARBShadingLanguageInclude.nglDeleteNamedStringARB(nameEncoded.remaining(), MemoryUtil.memAddress((ByteBuffer)nameEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglCompileShaderIncludeARB(int var0, int var1, long var2, long var4);

    public static void glCompileShaderIncludeARB(int shader, PointerBuffer path, IntBuffer length) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)path.remaining());
        }
        ARBShadingLanguageInclude.nglCompileShaderIncludeARB(shader, path.remaining(), MemoryUtil.memAddress((CustomBuffer)path), MemoryUtil.memAddressSafe((IntBuffer)length));
    }

    public static native boolean nglIsNamedStringARB(int var0, long var1);

    public static boolean glIsNamedStringARB(ByteBuffer name) {
        return ARBShadingLanguageInclude.nglIsNamedStringARB(name.remaining(), MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean glIsNamedStringARB(CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name, false);
            boolean bl = ARBShadingLanguageInclude.nglIsNamedStringARB(nameEncoded.remaining(), MemoryUtil.memAddress((ByteBuffer)nameEncoded));
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetNamedStringARB(int var0, long var1, int var3, long var4, long var6);

    public static void glGetNamedStringARB(ByteBuffer name, IntBuffer stringlen, ByteBuffer string) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)stringlen, (int)1);
        }
        ARBShadingLanguageInclude.nglGetNamedStringARB(name.remaining(), MemoryUtil.memAddress((ByteBuffer)name), string.remaining(), MemoryUtil.memAddressSafe((IntBuffer)stringlen), MemoryUtil.memAddress((ByteBuffer)string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glGetNamedStringARB(CharSequence name, IntBuffer stringlen, ByteBuffer string) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)stringlen, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name, false);
            ARBShadingLanguageInclude.nglGetNamedStringARB(nameEncoded.remaining(), MemoryUtil.memAddress((ByteBuffer)nameEncoded), string.remaining(), MemoryUtil.memAddressSafe((IntBuffer)stringlen), MemoryUtil.memAddress((ByteBuffer)string));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetNamedStringARB(CharSequence name, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name, false);
            IntBuffer stringlen = stack.ints(0);
            ByteBuffer string = stack.malloc(bufSize);
            ARBShadingLanguageInclude.nglGetNamedStringARB(nameEncoded.remaining(), MemoryUtil.memAddress((ByteBuffer)nameEncoded), bufSize, MemoryUtil.memAddress((IntBuffer)stringlen), MemoryUtil.memAddress((ByteBuffer)string));
            String string2 = MemoryUtil.memUTF8((ByteBuffer)string, (int)stringlen.get(0));
            return string2;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static String glGetNamedStringARB(CharSequence name) {
        return ARBShadingLanguageInclude.glGetNamedStringARB(name, ARBShadingLanguageInclude.glGetNamedStringiARB(name, 36329));
    }

    public static native void nglGetNamedStringivARB(int var0, long var1, int var3, long var4);

    public static void glGetNamedStringivARB(ByteBuffer name, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        ARBShadingLanguageInclude.nglGetNamedStringivARB(name.remaining(), MemoryUtil.memAddress((ByteBuffer)name), pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glGetNamedStringivARB(CharSequence name, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name, false);
            ARBShadingLanguageInclude.nglGetNamedStringivARB(nameEncoded.remaining(), MemoryUtil.memAddress((ByteBuffer)nameEncoded), pname, MemoryUtil.memAddress((IntBuffer)params));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetNamedStringiARB(CharSequence name, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name, false);
            IntBuffer params = stack.callocInt(1);
            ARBShadingLanguageInclude.nglGetNamedStringivARB(nameEncoded.remaining(), MemoryUtil.memAddress((ByteBuffer)nameEncoded), pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glCompileShaderIncludeARB(int shader, PointerBuffer path, int[] length) {
        long __functionAddress = GL.getICD().glCompileShaderIncludeARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])length, (int)path.remaining());
        }
        JNI.callPPV((long)__functionAddress, (int)shader, (int)path.remaining(), (long)MemoryUtil.memAddress((CustomBuffer)path), (int[])length);
    }

    public static void glGetNamedStringARB(ByteBuffer name, int[] stringlen, ByteBuffer string) {
        long __functionAddress = GL.getICD().glGetNamedStringARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])stringlen, (int)1);
        }
        JNI.callPPPV((long)__functionAddress, (int)name.remaining(), (long)MemoryUtil.memAddress((ByteBuffer)name), (int)string.remaining(), (int[])stringlen, (long)MemoryUtil.memAddress((ByteBuffer)string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glGetNamedStringARB(CharSequence name, int[] stringlen, ByteBuffer string) {
        long __functionAddress = GL.getICD().glGetNamedStringARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])stringlen, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name, false);
            JNI.callPPPV((long)__functionAddress, (int)nameEncoded.remaining(), (long)MemoryUtil.memAddress((ByteBuffer)nameEncoded), (int)string.remaining(), (int[])stringlen, (long)MemoryUtil.memAddress((ByteBuffer)string));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glGetNamedStringivARB(ByteBuffer name, int pname, int[] params) {
        long __functionAddress = GL.getICD().glGetNamedStringivARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])params, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)name.remaining(), (long)MemoryUtil.memAddress((ByteBuffer)name), (int)pname, (int[])params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glGetNamedStringivARB(CharSequence name, int pname, int[] params) {
        long __functionAddress = GL.getICD().glGetNamedStringivARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])params, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name, false);
            JNI.callPPV((long)__functionAddress, (int)nameEncoded.remaining(), (long)MemoryUtil.memAddress((ByteBuffer)nameEncoded), (int)pname, (int[])params);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    static {
        GL.initialize();
    }
}

