/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ARBShaderObjects {
    public static final int GL_PROGRAM_OBJECT_ARB = 35648;
    public static final int GL_OBJECT_TYPE_ARB = 35662;
    public static final int GL_OBJECT_SUBTYPE_ARB = 35663;
    public static final int GL_OBJECT_DELETE_STATUS_ARB = 35712;
    public static final int GL_OBJECT_COMPILE_STATUS_ARB = 35713;
    public static final int GL_OBJECT_LINK_STATUS_ARB = 35714;
    public static final int GL_OBJECT_VALIDATE_STATUS_ARB = 35715;
    public static final int GL_OBJECT_INFO_LOG_LENGTH_ARB = 35716;
    public static final int GL_OBJECT_ATTACHED_OBJECTS_ARB = 35717;
    public static final int GL_OBJECT_ACTIVE_UNIFORMS_ARB = 35718;
    public static final int GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB = 35719;
    public static final int GL_OBJECT_SHADER_SOURCE_LENGTH_ARB = 35720;
    public static final int GL_SHADER_OBJECT_ARB = 35656;
    public static final int GL_FLOAT_VEC2_ARB = 35664;
    public static final int GL_FLOAT_VEC3_ARB = 35665;
    public static final int GL_FLOAT_VEC4_ARB = 35666;
    public static final int GL_INT_VEC2_ARB = 35667;
    public static final int GL_INT_VEC3_ARB = 35668;
    public static final int GL_INT_VEC4_ARB = 35669;
    public static final int GL_BOOL_ARB = 35670;
    public static final int GL_BOOL_VEC2_ARB = 35671;
    public static final int GL_BOOL_VEC3_ARB = 35672;
    public static final int GL_BOOL_VEC4_ARB = 35673;
    public static final int GL_FLOAT_MAT2_ARB = 35674;
    public static final int GL_FLOAT_MAT3_ARB = 35675;
    public static final int GL_FLOAT_MAT4_ARB = 35676;
    public static final int GL_SAMPLER_1D_ARB = 35677;
    public static final int GL_SAMPLER_2D_ARB = 35678;
    public static final int GL_SAMPLER_3D_ARB = 35679;
    public static final int GL_SAMPLER_CUBE_ARB = 35680;
    public static final int GL_SAMPLER_1D_SHADOW_ARB = 35681;
    public static final int GL_SAMPLER_2D_SHADOW_ARB = 35682;
    public static final int GL_SAMPLER_2D_RECT_ARB = 35683;
    public static final int GL_SAMPLER_2D_RECT_SHADOW_ARB = 35684;

    protected ARBShaderObjects() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glDeleteObjectARB, caps.glGetHandleARB, caps.glDetachObjectARB, caps.glCreateShaderObjectARB, caps.glShaderSourceARB, caps.glCompileShaderARB, caps.glCreateProgramObjectARB, caps.glAttachObjectARB, caps.glLinkProgramARB, caps.glUseProgramObjectARB, caps.glValidateProgramARB, caps.glUniform1fARB, caps.glUniform2fARB, caps.glUniform3fARB, caps.glUniform4fARB, caps.glUniform1iARB, caps.glUniform2iARB, caps.glUniform3iARB, caps.glUniform4iARB, caps.glUniform1fvARB, caps.glUniform2fvARB, caps.glUniform3fvARB, caps.glUniform4fvARB, caps.glUniform1ivARB, caps.glUniform2ivARB, caps.glUniform3ivARB, caps.glUniform4ivARB, caps.glUniformMatrix2fvARB, caps.glUniformMatrix3fvARB, caps.glUniformMatrix4fvARB, caps.glGetObjectParameterfvARB, caps.glGetObjectParameterivARB, caps.glGetInfoLogARB, caps.glGetAttachedObjectsARB, caps.glGetUniformLocationARB, caps.glGetActiveUniformARB, caps.glGetUniformfvARB, caps.glGetUniformivARB, caps.glGetShaderSourceARB});
    }

    public static native void glDeleteObjectARB(int var0);

    public static native int glGetHandleARB(int var0);

    public static native void glDetachObjectARB(int var0, int var1);

    public static native int glCreateShaderObjectARB(int var0);

    public static native void nglShaderSourceARB(int var0, int var1, long var2, long var4);

    public static void glShaderSourceARB(int shaderObj, PointerBuffer string, IntBuffer length) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)string.remaining());
        }
        ARBShaderObjects.nglShaderSourceARB(shaderObj, string.remaining(), MemoryUtil.memAddress((CustomBuffer)string), MemoryUtil.memAddressSafe((IntBuffer)length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glShaderSourceARB(int shaderObj, CharSequence ... string) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long stringAddress = APIUtil.apiArrayi((MemoryStack)stack, MemoryUtil::memUTF8, (CharSequence[])string);
            ARBShaderObjects.nglShaderSourceARB(shaderObj, string.length, stringAddress, stringAddress - (long)(string.length << 2));
            APIUtil.apiArrayFree((long)stringAddress, (int)string.length);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glShaderSourceARB(int shaderObj, CharSequence string) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long stringAddress = APIUtil.apiArrayi((MemoryStack)stack, MemoryUtil::memUTF8, (CharSequence[])new CharSequence[]{string});
            ARBShaderObjects.nglShaderSourceARB(shaderObj, 1, stringAddress, stringAddress - 4L);
            APIUtil.apiArrayFree((long)stringAddress, (int)1);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glCompileShaderARB(int var0);

    public static native int glCreateProgramObjectARB();

    public static native void glAttachObjectARB(int var0, int var1);

    public static native void glLinkProgramARB(int var0);

    public static native void glUseProgramObjectARB(int var0);

    public static native void glValidateProgramARB(int var0);

    public static native void glUniform1fARB(int var0, float var1);

    public static native void glUniform2fARB(int var0, float var1, float var2);

    public static native void glUniform3fARB(int var0, float var1, float var2, float var3);

    public static native void glUniform4fARB(int var0, float var1, float var2, float var3, float var4);

    public static native void glUniform1iARB(int var0, int var1);

    public static native void glUniform2iARB(int var0, int var1, int var2);

    public static native void glUniform3iARB(int var0, int var1, int var2, int var3);

    public static native void glUniform4iARB(int var0, int var1, int var2, int var3, int var4);

    public static native void nglUniform1fvARB(int var0, int var1, long var2);

    public static void glUniform1fvARB(int location, FloatBuffer value) {
        ARBShaderObjects.nglUniform1fvARB(location, value.remaining(), MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglUniform2fvARB(int var0, int var1, long var2);

    public static void glUniform2fvARB(int location, FloatBuffer value) {
        ARBShaderObjects.nglUniform2fvARB(location, value.remaining() >> 1, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglUniform3fvARB(int var0, int var1, long var2);

    public static void glUniform3fvARB(int location, FloatBuffer value) {
        ARBShaderObjects.nglUniform3fvARB(location, value.remaining() / 3, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglUniform4fvARB(int var0, int var1, long var2);

    public static void glUniform4fvARB(int location, FloatBuffer value) {
        ARBShaderObjects.nglUniform4fvARB(location, value.remaining() >> 2, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglUniform1ivARB(int var0, int var1, long var2);

    public static void glUniform1ivARB(int location, IntBuffer value) {
        ARBShaderObjects.nglUniform1ivARB(location, value.remaining(), MemoryUtil.memAddress((IntBuffer)value));
    }

    public static native void nglUniform2ivARB(int var0, int var1, long var2);

    public static void glUniform2ivARB(int location, IntBuffer value) {
        ARBShaderObjects.nglUniform2ivARB(location, value.remaining() >> 1, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static native void nglUniform3ivARB(int var0, int var1, long var2);

    public static void glUniform3ivARB(int location, IntBuffer value) {
        ARBShaderObjects.nglUniform3ivARB(location, value.remaining() / 3, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static native void nglUniform4ivARB(int var0, int var1, long var2);

    public static void glUniform4ivARB(int location, IntBuffer value) {
        ARBShaderObjects.nglUniform4ivARB(location, value.remaining() >> 2, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static native void nglUniformMatrix2fvARB(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix2fvARB(int location, boolean transpose, FloatBuffer value) {
        ARBShaderObjects.nglUniformMatrix2fvARB(location, value.remaining() >> 2, transpose, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglUniformMatrix3fvARB(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix3fvARB(int location, boolean transpose, FloatBuffer value) {
        ARBShaderObjects.nglUniformMatrix3fvARB(location, value.remaining() / 9, transpose, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglUniformMatrix4fvARB(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix4fvARB(int location, boolean transpose, FloatBuffer value) {
        ARBShaderObjects.nglUniformMatrix4fvARB(location, value.remaining() >> 4, transpose, MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static native void nglGetObjectParameterfvARB(int var0, int var1, long var2);

    public static void glGetObjectParameterfvARB(int obj, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        ARBShaderObjects.nglGetObjectParameterfvARB(obj, pname, MemoryUtil.memAddress((FloatBuffer)params));
    }

    public static native void nglGetObjectParameterivARB(int var0, int var1, long var2);

    public static void glGetObjectParameterivARB(int obj, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        ARBShaderObjects.nglGetObjectParameterivARB(obj, pname, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetObjectParameteriARB(int obj, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            ARBShaderObjects.nglGetObjectParameterivARB(obj, pname, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetInfoLogARB(int var0, int var1, long var2, long var4);

    public static void glGetInfoLogARB(int obj, IntBuffer length, ByteBuffer infoLog) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)1);
        }
        ARBShaderObjects.nglGetInfoLogARB(obj, infoLog.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)infoLog));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetInfoLogARB(int obj, int maxLength) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer infoLog = MemoryUtil.memAlloc((int)maxLength);
        try {
            IntBuffer length = stack.ints(0);
            ARBShaderObjects.nglGetInfoLogARB(obj, maxLength, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)infoLog));
            String string = MemoryUtil.memUTF8((ByteBuffer)infoLog, (int)length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree((Buffer)infoLog);
            stack.setPointer(stackPointer);
        }
    }

    public static String glGetInfoLogARB(int obj) {
        return ARBShaderObjects.glGetInfoLogARB(obj, ARBShaderObjects.glGetObjectParameteriARB(obj, 35716));
    }

    public static native void nglGetAttachedObjectsARB(int var0, int var1, long var2, long var4);

    public static void glGetAttachedObjectsARB(int containerObj, IntBuffer count, IntBuffer obj) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)count, (int)1);
        }
        ARBShaderObjects.nglGetAttachedObjectsARB(containerObj, obj.remaining(), MemoryUtil.memAddressSafe((IntBuffer)count), MemoryUtil.memAddress((IntBuffer)obj));
    }

    public static native int nglGetUniformLocationARB(int var0, long var1);

    public static int glGetUniformLocationARB(int programObj, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return ARBShaderObjects.nglGetUniformLocationARB(programObj, MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetUniformLocationARB(int programObj, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            int n = ARBShaderObjects.nglGetUniformLocationARB(programObj, MemoryUtil.memAddress((ByteBuffer)nameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetActiveUniformARB(int var0, int var1, int var2, long var3, long var5, long var7, long var9);

    public static void glGetActiveUniformARB(int programObj, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)1);
            Checks.check((Buffer)size, (int)1);
            Checks.check((Buffer)type, (int)1);
        }
        ARBShaderObjects.nglGetActiveUniformARB(programObj, index, name.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((IntBuffer)size), MemoryUtil.memAddress((IntBuffer)type), MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveUniformARB(int programObj, int index, int maxLength, IntBuffer size, IntBuffer type) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)size, (int)1);
            Checks.check((Buffer)type, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(maxLength);
            ARBShaderObjects.nglGetActiveUniformARB(programObj, index, maxLength, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((IntBuffer)size), MemoryUtil.memAddress((IntBuffer)type), MemoryUtil.memAddress((ByteBuffer)name));
            String string = MemoryUtil.memUTF8((ByteBuffer)name, (int)length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static String glGetActiveUniformARB(int programObj, int index, IntBuffer size, IntBuffer type) {
        return ARBShaderObjects.glGetActiveUniformARB(programObj, index, ARBShaderObjects.glGetObjectParameteriARB(programObj, 35719), size, type);
    }

    public static native void nglGetUniformfvARB(int var0, int var1, long var2);

    public static void glGetUniformfvARB(int programObj, int location, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        ARBShaderObjects.nglGetUniformfvARB(programObj, location, MemoryUtil.memAddress((FloatBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetUniformfARB(int programObj, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            ARBShaderObjects.nglGetUniformfvARB(programObj, location, MemoryUtil.memAddress((FloatBuffer)params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetUniformivARB(int var0, int var1, long var2);

    public static void glGetUniformivARB(int programObj, int location, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, (int)1);
        }
        ARBShaderObjects.nglGetUniformivARB(programObj, location, MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetUniformiARB(int programObj, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            ARBShaderObjects.nglGetUniformivARB(programObj, location, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetShaderSourceARB(int var0, int var1, long var2, long var4);

    public static void glGetShaderSourceARB(int obj, IntBuffer length, ByteBuffer source) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, (int)1);
        }
        ARBShaderObjects.nglGetShaderSourceARB(obj, source.remaining(), MemoryUtil.memAddressSafe((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetShaderSourceARB(int obj, int maxLength) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer source = MemoryUtil.memAlloc((int)maxLength);
        try {
            IntBuffer length = stack.ints(0);
            ARBShaderObjects.nglGetShaderSourceARB(obj, maxLength, MemoryUtil.memAddress((IntBuffer)length), MemoryUtil.memAddress((ByteBuffer)source));
            String string = MemoryUtil.memUTF8((ByteBuffer)source, (int)length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree((Buffer)source);
            stack.setPointer(stackPointer);
        }
    }

    public static String glGetShaderSourceARB(int obj) {
        return ARBShaderObjects.glGetShaderSourceARB(obj, ARBShaderObjects.glGetObjectParameteriARB(obj, 35720));
    }

    public static void glShaderSourceARB(int shaderObj, PointerBuffer string, int[] length) {
        long __functionAddress = GL.getICD().glShaderSourceARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])length, (int)string.remaining());
        }
        JNI.callPPV((long)__functionAddress, (int)shaderObj, (int)string.remaining(), (long)MemoryUtil.memAddress((CustomBuffer)string), (int[])length);
    }

    public static void glUniform1fvARB(int location, float[] value) {
        long __functionAddress = GL.getICD().glUniform1fvARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)value.length, (float[])value);
    }

    public static void glUniform2fvARB(int location, float[] value) {
        long __functionAddress = GL.getICD().glUniform2fvARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length >> 1), (float[])value);
    }

    public static void glUniform3fvARB(int location, float[] value) {
        long __functionAddress = GL.getICD().glUniform3fvARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length / 3), (float[])value);
    }

    public static void glUniform4fvARB(int location, float[] value) {
        long __functionAddress = GL.getICD().glUniform4fvARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length >> 2), (float[])value);
    }

    public static void glUniform1ivARB(int location, int[] value) {
        long __functionAddress = GL.getICD().glUniform1ivARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)value.length, (int[])value);
    }

    public static void glUniform2ivARB(int location, int[] value) {
        long __functionAddress = GL.getICD().glUniform2ivARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length >> 1), (int[])value);
    }

    public static void glUniform3ivARB(int location, int[] value) {
        long __functionAddress = GL.getICD().glUniform3ivARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length / 3), (int[])value);
    }

    public static void glUniform4ivARB(int location, int[] value) {
        long __functionAddress = GL.getICD().glUniform4ivARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length >> 2), (int[])value);
    }

    public static void glUniformMatrix2fvARB(int location, boolean transpose, float[] value) {
        long __functionAddress = GL.getICD().glUniformMatrix2fvARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length >> 2), (boolean)transpose, (float[])value);
    }

    public static void glUniformMatrix3fvARB(int location, boolean transpose, float[] value) {
        long __functionAddress = GL.getICD().glUniformMatrix3fvARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length / 9), (boolean)transpose, (float[])value);
    }

    public static void glUniformMatrix4fvARB(int location, boolean transpose, float[] value) {
        long __functionAddress = GL.getICD().glUniformMatrix4fvARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)location, (int)(value.length >> 4), (boolean)transpose, (float[])value);
    }

    public static void glGetObjectParameterfvARB(int obj, int pname, float[] params) {
        long __functionAddress = GL.getICD().glGetObjectParameterfvARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((float[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)obj, (int)pname, (float[])params);
    }

    public static void glGetObjectParameterivARB(int obj, int pname, int[] params) {
        long __functionAddress = GL.getICD().glGetObjectParameterivARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)obj, (int)pname, (int[])params);
    }

    public static void glGetInfoLogARB(int obj, int[] length, ByteBuffer infoLog) {
        long __functionAddress = GL.getICD().glGetInfoLogARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])length, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)obj, (int)infoLog.remaining(), (int[])length, (long)MemoryUtil.memAddress((ByteBuffer)infoLog));
    }

    public static void glGetAttachedObjectsARB(int containerObj, int[] count, int[] obj) {
        long __functionAddress = GL.getICD().glGetAttachedObjectsARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])count, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)containerObj, (int)obj.length, (int[])count, (int[])obj);
    }

    public static void glGetActiveUniformARB(int programObj, int index, int[] length, int[] size, int[] type, ByteBuffer name) {
        long __functionAddress = GL.getICD().glGetActiveUniformARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])length, (int)1);
            Checks.check((int[])size, (int)1);
            Checks.check((int[])type, (int)1);
        }
        JNI.callPPPPV((long)__functionAddress, (int)programObj, (int)index, (int)name.remaining(), (int[])length, (int[])size, (int[])type, (long)MemoryUtil.memAddress((ByteBuffer)name));
    }

    public static void glGetUniformfvARB(int programObj, int location, float[] params) {
        long __functionAddress = GL.getICD().glGetUniformfvARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((float[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)programObj, (int)location, (float[])params);
    }

    public static void glGetUniformivARB(int programObj, int location, int[] params) {
        long __functionAddress = GL.getICD().glGetUniformivARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])params, (int)1);
        }
        JNI.callPV((long)__functionAddress, (int)programObj, (int)location, (int[])params);
    }

    public static void glGetShaderSourceARB(int obj, int[] length, ByteBuffer source) {
        long __functionAddress = GL.getICD().glGetShaderSourceARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.checkSafe((int[])length, (int)1);
        }
        JNI.callPPV((long)__functionAddress, (int)obj, (int)source.remaining(), (int[])length, (long)MemoryUtil.memAddress((ByteBuffer)source));
    }

    static {
        GL.initialize();
    }
}

