/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ARBRobustness {
    public static final int GL_GUILTY_CONTEXT_RESET_ARB = 33363;
    public static final int GL_INNOCENT_CONTEXT_RESET_ARB = 33364;
    public static final int GL_UNKNOWN_CONTEXT_RESET_ARB = 33365;
    public static final int GL_RESET_NOTIFICATION_STRATEGY_ARB = 33366;
    public static final int GL_LOSE_CONTEXT_ON_RESET_ARB = 33362;
    public static final int GL_NO_RESET_NOTIFICATION_ARB = 33377;
    public static final int GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT_ARB = 4;

    protected ARBRobustness() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps, Set<String> ext) {
        return Checks.checkFunctions((long[])new long[]{caps.glGetGraphicsResetStatusARB, caps.glGetMapdv != 0L ? caps.glGetnMapdvARB : -1L, caps.glGetMapfv != 0L ? caps.glGetnMapfvARB : -1L, caps.glGetMapiv != 0L ? caps.glGetnMapivARB : -1L, caps.glGetPixelMapfv != 0L ? caps.glGetnPixelMapfvARB : -1L, caps.glGetPixelMapuiv != 0L ? caps.glGetnPixelMapuivARB : -1L, caps.glGetPixelMapusv != 0L ? caps.glGetnPixelMapusvARB : -1L, caps.glGetPolygonStipple != 0L ? caps.glGetnPolygonStippleARB : -1L, caps.glGetnTexImageARB, caps.glReadnPixelsARB, ext.contains("GL_ARB_imaging") && caps.glGetColorTable != 0L ? caps.glGetnColorTableARB : -1L, ext.contains("GL_ARB_imaging") && caps.glGetConvolutionFilter != 0L ? caps.glGetnConvolutionFilterARB : -1L, ext.contains("GL_ARB_imaging") && caps.glGetSeparableFilter != 0L ? caps.glGetnSeparableFilterARB : -1L, ext.contains("GL_ARB_imaging") && caps.glGetHistogram != 0L ? caps.glGetnHistogramARB : -1L, ext.contains("GL_ARB_imaging") && caps.glGetMinmax != 0L ? caps.glGetnMinmaxARB : -1L, ext.contains("OpenGL13") ? caps.glGetnCompressedTexImageARB : -1L, ext.contains("OpenGL20") ? caps.glGetnUniformfvARB : -1L, ext.contains("OpenGL20") ? caps.glGetnUniformivARB : -1L, ext.contains("OpenGL30") ? caps.glGetnUniformuivARB : -1L, ext.contains("OpenGL40") ? caps.glGetnUniformdvARB : -1L});
    }

    public static native int glGetGraphicsResetStatusARB();

    public static native void nglGetnMapdvARB(int var0, int var1, int var2, long var3);

    public static void glGetnMapdvARB(int target, int query, DoubleBuffer data) {
        ARBRobustness.nglGetnMapdvARB(target, query, data.remaining(), MemoryUtil.memAddress((DoubleBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double glGetnMapdARB(int target, int query) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            DoubleBuffer data = stack.callocDouble(1);
            ARBRobustness.nglGetnMapdvARB(target, query, 1, MemoryUtil.memAddress((DoubleBuffer)data));
            double d = data.get(0);
            return d;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetnMapfvARB(int var0, int var1, int var2, long var3);

    public static void glGetnMapfvARB(int target, int query, FloatBuffer data) {
        ARBRobustness.nglGetnMapfvARB(target, query, data.remaining(), MemoryUtil.memAddress((FloatBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetnMapfARB(int target, int query) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer data = stack.callocFloat(1);
            ARBRobustness.nglGetnMapfvARB(target, query, 1, MemoryUtil.memAddress((FloatBuffer)data));
            float f = data.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetnMapivARB(int var0, int var1, int var2, long var3);

    public static void glGetnMapivARB(int target, int query, IntBuffer data) {
        ARBRobustness.nglGetnMapivARB(target, query, data.remaining(), MemoryUtil.memAddress((IntBuffer)data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetnMapiARB(int target, int query) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer data = stack.callocInt(1);
            ARBRobustness.nglGetnMapivARB(target, query, 1, MemoryUtil.memAddress((IntBuffer)data));
            int n = data.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetnPixelMapfvARB(int var0, int var1, long var2);

    public static void glGetnPixelMapfvARB(int map, FloatBuffer data) {
        ARBRobustness.nglGetnPixelMapfvARB(map, data.remaining(), MemoryUtil.memAddress((FloatBuffer)data));
    }

    public static native void nglGetnPixelMapuivARB(int var0, int var1, long var2);

    public static void glGetnPixelMapuivARB(int map, IntBuffer data) {
        ARBRobustness.nglGetnPixelMapuivARB(map, data.remaining(), MemoryUtil.memAddress((IntBuffer)data));
    }

    public static native void nglGetnPixelMapusvARB(int var0, int var1, long var2);

    public static void glGetnPixelMapusvARB(int map, ShortBuffer data) {
        ARBRobustness.nglGetnPixelMapusvARB(map, data.remaining(), MemoryUtil.memAddress((ShortBuffer)data));
    }

    public static native void nglGetnPolygonStippleARB(int var0, long var1);

    public static void glGetnPolygonStippleARB(int bufSize, long pattern) {
        ARBRobustness.nglGetnPolygonStippleARB(bufSize, pattern);
    }

    public static void glGetnPolygonStippleARB(ByteBuffer pattern) {
        ARBRobustness.nglGetnPolygonStippleARB(pattern.remaining(), MemoryUtil.memAddress((ByteBuffer)pattern));
    }

    public static native void nglGetnTexImageARB(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glGetnTexImageARB(int tex, int level, int format, int type, int bufSize, long img) {
        ARBRobustness.nglGetnTexImageARB(tex, level, format, type, bufSize, img);
    }

    public static void glGetnTexImageARB(int tex, int level, int format, int type, ByteBuffer img) {
        ARBRobustness.nglGetnTexImageARB(tex, level, format, type, img.remaining(), MemoryUtil.memAddress((ByteBuffer)img));
    }

    public static void glGetnTexImageARB(int tex, int level, int format, int type, ShortBuffer img) {
        ARBRobustness.nglGetnTexImageARB(tex, level, format, type, img.remaining() << 1, MemoryUtil.memAddress((ShortBuffer)img));
    }

    public static void glGetnTexImageARB(int tex, int level, int format, int type, IntBuffer img) {
        ARBRobustness.nglGetnTexImageARB(tex, level, format, type, img.remaining() << 2, MemoryUtil.memAddress((IntBuffer)img));
    }

    public static void glGetnTexImageARB(int tex, int level, int format, int type, FloatBuffer img) {
        ARBRobustness.nglGetnTexImageARB(tex, level, format, type, img.remaining() << 2, MemoryUtil.memAddress((FloatBuffer)img));
    }

    public static void glGetnTexImageARB(int tex, int level, int format, int type, DoubleBuffer img) {
        ARBRobustness.nglGetnTexImageARB(tex, level, format, type, img.remaining() << 3, MemoryUtil.memAddress((DoubleBuffer)img));
    }

    public static native void nglReadnPixelsARB(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7);

    public static void glReadnPixelsARB(int x, int y, int width, int height, int format, int type, int bufSize, long data) {
        ARBRobustness.nglReadnPixelsARB(x, y, width, height, format, type, bufSize, data);
    }

    public static void glReadnPixelsARB(int x, int y, int width, int height, int format, int type, ByteBuffer data) {
        ARBRobustness.nglReadnPixelsARB(x, y, width, height, format, type, data.remaining(), MemoryUtil.memAddress((ByteBuffer)data));
    }

    public static void glReadnPixelsARB(int x, int y, int width, int height, int format, int type, ShortBuffer data) {
        ARBRobustness.nglReadnPixelsARB(x, y, width, height, format, type, data.remaining() << 1, MemoryUtil.memAddress((ShortBuffer)data));
    }

    public static void glReadnPixelsARB(int x, int y, int width, int height, int format, int type, IntBuffer data) {
        ARBRobustness.nglReadnPixelsARB(x, y, width, height, format, type, data.remaining() << 2, MemoryUtil.memAddress((IntBuffer)data));
    }

    public static void glReadnPixelsARB(int x, int y, int width, int height, int format, int type, FloatBuffer data) {
        ARBRobustness.nglReadnPixelsARB(x, y, width, height, format, type, data.remaining() << 2, MemoryUtil.memAddress((FloatBuffer)data));
    }

    public static native void nglGetnColorTableARB(int var0, int var1, int var2, int var3, long var4);

    public static void glGetnColorTableARB(int target, int format, int type, int bufSize, long table) {
        ARBRobustness.nglGetnColorTableARB(target, format, type, bufSize, table);
    }

    public static void glGetnColorTableARB(int target, int format, int type, ByteBuffer table) {
        ARBRobustness.nglGetnColorTableARB(target, format, type, table.remaining(), MemoryUtil.memAddress((ByteBuffer)table));
    }

    public static void glGetnColorTableARB(int target, int format, int type, ShortBuffer table) {
        ARBRobustness.nglGetnColorTableARB(target, format, type, table.remaining() << 1, MemoryUtil.memAddress((ShortBuffer)table));
    }

    public static void glGetnColorTableARB(int target, int format, int type, IntBuffer table) {
        ARBRobustness.nglGetnColorTableARB(target, format, type, table.remaining() << 2, MemoryUtil.memAddress((IntBuffer)table));
    }

    public static void glGetnColorTableARB(int target, int format, int type, FloatBuffer table) {
        ARBRobustness.nglGetnColorTableARB(target, format, type, table.remaining() << 2, MemoryUtil.memAddress((FloatBuffer)table));
    }

    public static native void nglGetnConvolutionFilterARB(int var0, int var1, int var2, int var3, long var4);

    public static void glGetnConvolutionFilterARB(int target, int format, int type, int bufSize, long image) {
        ARBRobustness.nglGetnConvolutionFilterARB(target, format, type, bufSize, image);
    }

    public static void glGetnConvolutionFilterARB(int target, int format, int type, ByteBuffer image) {
        ARBRobustness.nglGetnConvolutionFilterARB(target, format, type, image.remaining(), MemoryUtil.memAddress((ByteBuffer)image));
    }

    public static native void nglGetnSeparableFilterARB(int var0, int var1, int var2, int var3, long var4, int var6, long var7, long var9);

    public static void glGetnSeparableFilterARB(int target, int format, int type, int rowBufSize, long row, int columnBufSize, long column, ByteBuffer span) {
        ARBRobustness.nglGetnSeparableFilterARB(target, format, type, rowBufSize, row, columnBufSize, column, MemoryUtil.memAddressSafe((ByteBuffer)span));
    }

    public static void glGetnSeparableFilterARB(int target, int format, int type, ByteBuffer row, ByteBuffer column, ByteBuffer span) {
        ARBRobustness.nglGetnSeparableFilterARB(target, format, type, row.remaining(), MemoryUtil.memAddress((ByteBuffer)row), column.remaining(), MemoryUtil.memAddress((ByteBuffer)column), MemoryUtil.memAddressSafe((ByteBuffer)span));
    }

    public static native void nglGetnHistogramARB(int var0, boolean var1, int var2, int var3, int var4, long var5);

    public static void glGetnHistogramARB(int target, boolean reset, int format, int type, int bufSize, long values) {
        ARBRobustness.nglGetnHistogramARB(target, reset, format, type, bufSize, values);
    }

    public static void glGetnHistogramARB(int target, boolean reset, int format, int type, ByteBuffer values) {
        ARBRobustness.nglGetnHistogramARB(target, reset, format, type, values.remaining(), MemoryUtil.memAddress((ByteBuffer)values));
    }

    public static native void nglGetnMinmaxARB(int var0, boolean var1, int var2, int var3, int var4, long var5);

    public static void glGetnMinmaxARB(int target, boolean reset, int format, int type, int bufSize, long values) {
        ARBRobustness.nglGetnMinmaxARB(target, reset, format, type, bufSize, values);
    }

    public static void glGetnMinmaxARB(int target, boolean reset, int format, int type, ByteBuffer values) {
        ARBRobustness.nglGetnMinmaxARB(target, reset, format, type, values.remaining(), MemoryUtil.memAddress((ByteBuffer)values));
    }

    public static native void nglGetnCompressedTexImageARB(int var0, int var1, int var2, long var3);

    public static void glGetnCompressedTexImageARB(int target, int level, int bufSize, long img) {
        ARBRobustness.nglGetnCompressedTexImageARB(target, level, bufSize, img);
    }

    public static void glGetnCompressedTexImageARB(int target, int level, ByteBuffer img) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.check((Buffer)img, (int)GL11.glGetTexLevelParameteri(target, level, 34464));
        }
        ARBRobustness.nglGetnCompressedTexImageARB(target, level, img.remaining(), MemoryUtil.memAddress((ByteBuffer)img));
    }

    public static native void nglGetnUniformfvARB(int var0, int var1, int var2, long var3);

    public static void glGetnUniformfvARB(int program, int location, FloatBuffer params) {
        ARBRobustness.nglGetnUniformfvARB(program, location, params.remaining(), MemoryUtil.memAddress((FloatBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetnUniformfARB(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            ARBRobustness.nglGetnUniformfvARB(program, location, 1, MemoryUtil.memAddress((FloatBuffer)params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetnUniformivARB(int var0, int var1, int var2, long var3);

    public static void glGetnUniformivARB(int program, int location, IntBuffer params) {
        ARBRobustness.nglGetnUniformivARB(program, location, params.remaining(), MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetnUniformiARB(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            ARBRobustness.nglGetnUniformivARB(program, location, 1, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetnUniformuivARB(int var0, int var1, int var2, long var3);

    public static void glGetnUniformuivARB(int program, int location, IntBuffer params) {
        ARBRobustness.nglGetnUniformuivARB(program, location, params.remaining(), MemoryUtil.memAddress((IntBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetnUniformuiARB(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            ARBRobustness.nglGetnUniformuivARB(program, location, 1, MemoryUtil.memAddress((IntBuffer)params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetnUniformdvARB(int var0, int var1, int var2, long var3);

    public static void glGetnUniformdvARB(int program, int location, DoubleBuffer params) {
        ARBRobustness.nglGetnUniformdvARB(program, location, params.remaining(), MemoryUtil.memAddress((DoubleBuffer)params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double glGetnUniformdARB(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            DoubleBuffer params = stack.callocDouble(1);
            ARBRobustness.nglGetnUniformdvARB(program, location, 1, MemoryUtil.memAddress((DoubleBuffer)params));
            double d = params.get(0);
            return d;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glGetnMapdvARB(int target, int query, double[] data) {
        long __functionAddress = GL.getICD().glGetnMapdvARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)query, (int)data.length, (double[])data);
    }

    public static void glGetnMapfvARB(int target, int query, float[] data) {
        long __functionAddress = GL.getICD().glGetnMapfvARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)query, (int)data.length, (float[])data);
    }

    public static void glGetnMapivARB(int target, int query, int[] data) {
        long __functionAddress = GL.getICD().glGetnMapivARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)query, (int)data.length, (int[])data);
    }

    public static void glGetnPixelMapfvARB(int map, float[] data) {
        long __functionAddress = GL.getICD().glGetnPixelMapfvARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)map, (int)data.length, (float[])data);
    }

    public static void glGetnPixelMapuivARB(int map, int[] data) {
        long __functionAddress = GL.getICD().glGetnPixelMapuivARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)map, (int)data.length, (int[])data);
    }

    public static void glGetnPixelMapusvARB(int map, short[] data) {
        long __functionAddress = GL.getICD().glGetnPixelMapusvARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)map, (int)data.length, (short[])data);
    }

    public static void glGetnTexImageARB(int tex, int level, int format, int type, short[] img) {
        long __functionAddress = GL.getICD().glGetnTexImageARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)tex, (int)level, (int)format, (int)type, (int)(img.length << 1), (short[])img);
    }

    public static void glGetnTexImageARB(int tex, int level, int format, int type, int[] img) {
        long __functionAddress = GL.getICD().glGetnTexImageARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)tex, (int)level, (int)format, (int)type, (int)(img.length << 2), (int[])img);
    }

    public static void glGetnTexImageARB(int tex, int level, int format, int type, float[] img) {
        long __functionAddress = GL.getICD().glGetnTexImageARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)tex, (int)level, (int)format, (int)type, (int)(img.length << 2), (float[])img);
    }

    public static void glGetnTexImageARB(int tex, int level, int format, int type, double[] img) {
        long __functionAddress = GL.getICD().glGetnTexImageARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)tex, (int)level, (int)format, (int)type, (int)(img.length << 3), (double[])img);
    }

    public static void glReadnPixelsARB(int x, int y, int width, int height, int format, int type, short[] data) {
        long __functionAddress = GL.getICD().glReadnPixelsARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (int)(data.length << 1), (short[])data);
    }

    public static void glReadnPixelsARB(int x, int y, int width, int height, int format, int type, int[] data) {
        long __functionAddress = GL.getICD().glReadnPixelsARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (int)(data.length << 2), (int[])data);
    }

    public static void glReadnPixelsARB(int x, int y, int width, int height, int format, int type, float[] data) {
        long __functionAddress = GL.getICD().glReadnPixelsARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (int)(data.length << 2), (float[])data);
    }

    public static void glGetnColorTableARB(int target, int format, int type, short[] table) {
        long __functionAddress = GL.getICD().glGetnColorTableARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)format, (int)type, (int)(table.length << 1), (short[])table);
    }

    public static void glGetnColorTableARB(int target, int format, int type, int[] table) {
        long __functionAddress = GL.getICD().glGetnColorTableARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)format, (int)type, (int)(table.length << 2), (int[])table);
    }

    public static void glGetnColorTableARB(int target, int format, int type, float[] table) {
        long __functionAddress = GL.getICD().glGetnColorTableARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)target, (int)format, (int)type, (int)(table.length << 2), (float[])table);
    }

    public static void glGetnUniformfvARB(int program, int location, float[] params) {
        long __functionAddress = GL.getICD().glGetnUniformfvARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)params.length, (float[])params);
    }

    public static void glGetnUniformivARB(int program, int location, int[] params) {
        long __functionAddress = GL.getICD().glGetnUniformivARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)params.length, (int[])params);
    }

    public static void glGetnUniformuivARB(int program, int location, int[] params) {
        long __functionAddress = GL.getICD().glGetnUniformuivARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)params.length, (int[])params);
    }

    public static void glGetnUniformdvARB(int program, int location, double[] params) {
        long __functionAddress = GL.getICD().glGetnUniformdvARB;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)__functionAddress, (int)program, (int)location, (int)params.length, (double[])params);
    }

    static {
        GL.initialize();
    }
}

