/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBMultiDrawIndirect {
    protected ARBMultiDrawIndirect() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glMultiDrawArraysIndirect, caps.glMultiDrawElementsIndirect});
    }

    public static native void nglMultiDrawArraysIndirect(int var0, long var1, int var3, int var4);

    public static void glMultiDrawArraysIndirect(int mode, ByteBuffer indirect, int primcount, int stride) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indirect, (int)(primcount * (stride == 0 ? 16 : stride)));
        }
        ARBMultiDrawIndirect.nglMultiDrawArraysIndirect(mode, MemoryUtil.memAddress((ByteBuffer)indirect), primcount, stride);
    }

    public static void glMultiDrawArraysIndirect(int mode, long indirect, int primcount, int stride) {
        ARBMultiDrawIndirect.nglMultiDrawArraysIndirect(mode, indirect, primcount, stride);
    }

    public static void glMultiDrawArraysIndirect(int mode, IntBuffer indirect, int primcount, int stride) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indirect, (int)(primcount * (stride == 0 ? 16 : stride) >> 2));
        }
        ARBMultiDrawIndirect.nglMultiDrawArraysIndirect(mode, MemoryUtil.memAddress((IntBuffer)indirect), primcount, stride);
    }

    public static native void nglMultiDrawElementsIndirect(int var0, int var1, long var2, int var4, int var5);

    public static void glMultiDrawElementsIndirect(int mode, int type, ByteBuffer indirect, int primcount, int stride) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indirect, (int)(primcount * (stride == 0 ? 20 : stride)));
        }
        ARBMultiDrawIndirect.nglMultiDrawElementsIndirect(mode, type, MemoryUtil.memAddress((ByteBuffer)indirect), primcount, stride);
    }

    public static void glMultiDrawElementsIndirect(int mode, int type, long indirect, int primcount, int stride) {
        ARBMultiDrawIndirect.nglMultiDrawElementsIndirect(mode, type, indirect, primcount, stride);
    }

    public static void glMultiDrawElementsIndirect(int mode, int type, IntBuffer indirect, int primcount, int stride) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indirect, (int)(primcount * (stride == 0 ? 20 : stride) >> 2));
        }
        ARBMultiDrawIndirect.nglMultiDrawElementsIndirect(mode, type, MemoryUtil.memAddress((IntBuffer)indirect), primcount, stride);
    }

    public static void glMultiDrawArraysIndirect(int mode, int[] indirect, int primcount, int stride) {
        long __functionAddress = GL.getICD().glMultiDrawArraysIndirect;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])indirect, (int)(primcount * (stride == 0 ? 16 : stride) >> 2));
        }
        JNI.callPV((long)__functionAddress, (int)mode, (int[])indirect, (int)primcount, (int)stride);
    }

    public static void glMultiDrawElementsIndirect(int mode, int type, int[] indirect, int primcount, int stride) {
        long __functionAddress = GL.getICD().glMultiDrawElementsIndirect;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])indirect, (int)(primcount * (stride == 0 ? 20 : stride) >> 2));
        }
        JNI.callPV((long)__functionAddress, (int)mode, (int)type, (int[])indirect, (int)primcount, (int)stride);
    }

    static {
        GL.initialize();
    }
}

