/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBDrawIndirect {
    public static final int GL_DRAW_INDIRECT_BUFFER = 36671;
    public static final int GL_DRAW_INDIRECT_BUFFER_BINDING = 36675;

    protected ARBDrawIndirect() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.glDrawArraysIndirect, caps.glDrawElementsIndirect});
    }

    public static native void nglDrawArraysIndirect(int var0, long var1);

    public static void glDrawArraysIndirect(int mode, ByteBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indirect, (int)16);
        }
        ARBDrawIndirect.nglDrawArraysIndirect(mode, MemoryUtil.memAddress((ByteBuffer)indirect));
    }

    public static void glDrawArraysIndirect(int mode, long indirect) {
        ARBDrawIndirect.nglDrawArraysIndirect(mode, indirect);
    }

    public static void glDrawArraysIndirect(int mode, IntBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indirect, (int)4);
        }
        ARBDrawIndirect.nglDrawArraysIndirect(mode, MemoryUtil.memAddress((IntBuffer)indirect));
    }

    public static native void nglDrawElementsIndirect(int var0, int var1, long var2);

    public static void glDrawElementsIndirect(int mode, int type, ByteBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indirect, (int)20);
        }
        ARBDrawIndirect.nglDrawElementsIndirect(mode, type, MemoryUtil.memAddress((ByteBuffer)indirect));
    }

    public static void glDrawElementsIndirect(int mode, int type, long indirect) {
        ARBDrawIndirect.nglDrawElementsIndirect(mode, type, indirect);
    }

    public static void glDrawElementsIndirect(int mode, int type, IntBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)indirect, (int)5);
        }
        ARBDrawIndirect.nglDrawElementsIndirect(mode, type, MemoryUtil.memAddress((IntBuffer)indirect));
    }

    public static void glDrawArraysIndirect(int mode, int[] indirect) {
        long __functionAddress = GL.getICD().glDrawArraysIndirect;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])indirect, (int)4);
        }
        JNI.callPV((long)__functionAddress, (int)mode, (int[])indirect);
    }

    public static void glDrawElementsIndirect(int mode, int type, int[] indirect) {
        long __functionAddress = GL.getICD().glDrawElementsIndirect;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])indirect, (int)5);
        }
        JNI.callPV((long)__functionAddress, (int)mode, (int)type, (int[])indirect);
    }

    static {
        GL.initialize();
    }
}

