// CheckStyle: start generated
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.nfi.NFISignature.ArgsCachedState;
import com.oracle.truffle.nfi.NFISignature.SignatureBuilder;
import com.oracle.truffle.nfi.NFISignature.SignatureCachedState;
import com.oracle.truffle.nfi.NFISignature.SignatureBuilder.AddArgument;
import com.oracle.truffle.nfi.NFISignature.SignatureBuilder.Build;
import com.oracle.truffle.nfi.NFISignature.SignatureBuilder.SetReturnType;
import com.oracle.truffle.nfi.NFIType.TypeCachedState;
import com.oracle.truffle.nfi.backend.spi.NFIBackendSignatureBuilderLibrary;
import java.lang.invoke.MethodHandles;
import java.util.Objects;

@GeneratedBy(SignatureBuilder.class)
@SuppressWarnings("javadoc")
final class SignatureBuilderGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<NFIBackendSignatureBuilderLibrary> N_F_I_BACKEND_SIGNATURE_BUILDER_LIBRARY_ = LibraryFactory.resolve(NFIBackendSignatureBuilderLibrary.class);

    static  {
        LibraryExport.register(SignatureBuilder.class, new NFIBackendSignatureBuilderLibraryExports());
    }

    private SignatureBuilderGen() {
    }

    @GeneratedBy(SignatureBuilder.class)
    private static final class NFIBackendSignatureBuilderLibraryExports extends LibraryExport<NFIBackendSignatureBuilderLibrary> {

        private NFIBackendSignatureBuilderLibraryExports() {
            super(NFIBackendSignatureBuilderLibrary.class, SignatureBuilder.class, false, false, 0);
        }

        @Override
        protected NFIBackendSignatureBuilderLibrary createUncached(Object receiver) {
            assert receiver instanceof SignatureBuilder;
            NFIBackendSignatureBuilderLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected NFIBackendSignatureBuilderLibrary createCached(Object receiver) {
            assert receiver instanceof SignatureBuilder;
            return new Cached(receiver);
        }

        @GeneratedBy(SignatureBuilder.class)
        private static final class Cached extends NFIBackendSignatureBuilderLibrary {

            static final ReferenceField<AddArgumentCachedData> ADD_ARGUMENT_CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "addArgument_cached_cache", AddArgumentCachedData.class);
            static final ReferenceField<BuildCachedData> BUILD_CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "build_cached_cache", BuildCachedData.class);

            @Child private NFIBackendSignatureBuilderLibrary receiverBackendBuilderNFIBackendSignatureBuilderLibrary_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link AddArgument#doCached}
             *   1: SpecializationActive {@link AddArgument#doGeneric}
             *   2: SpecializationActive {@link SetReturnType#doSet}
             *   3: SpecializationActive {@link Build#doCached}
             *   4: SpecializationActive {@link Build#doGeneric}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            @UnsafeAccessedField @CompilationFinal private AddArgumentCachedData addArgument_cached_cache;
            @UnsafeAccessedField @CompilationFinal private BuildCachedData build_cached_cache;

            protected Cached(Object receiver) {
                SignatureBuilder castReceiver = ((SignatureBuilder) receiver) ;
                this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_ = N_F_I_BACKEND_SIGNATURE_BUILDER_LIBRARY_.create((castReceiver.backendBuilder));
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof SignatureBuilder) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof SignatureBuilder)) {
                    return false;
                } else if (!this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_.accepts((((SignatureBuilder) receiver).backendBuilder))) {
                    return false;
                } else {
                    return true;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link AddArgument#doCached}
             *     Activation probability: 0.16250
             *     With/without class size: 7/12 bytes
             *   Specialization {@link AddArgument#doGeneric}
             *     Activation probability: 0.08750
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public void addArgument(Object arg0Value_, Object arg1Value) {
                assert arg0Value_ instanceof SignatureBuilder : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                SignatureBuilder arg0Value = ((SignatureBuilder) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[SignatureBuilder.AddArgument.doCached(SignatureBuilder, NFIType, ArgsCachedState, TypeCachedState, ArgsCachedState, NFIBackendSignatureBuilderLibrary)] || SpecializationActive[SignatureBuilder.AddArgument.doGeneric(SignatureBuilder, NFIType, NFIBackendSignatureBuilderLibrary)] */ && arg1Value instanceof NFIType) {
                    NFIType arg1Value_ = (NFIType) arg1Value;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[SignatureBuilder.AddArgument.doCached(SignatureBuilder, NFIType, ArgsCachedState, TypeCachedState, ArgsCachedState, NFIBackendSignatureBuilderLibrary)] */) {
                        AddArgumentCachedData s0_ = this.addArgument_cached_cache;
                        if (s0_ != null) {
                            if ((arg0Value.argsState == s0_.prevArgsState_) && (arg1Value_.cachedState == s0_.argState_)) {
                                NFIBackendSignatureBuilderLibrary backendLibrary__ = this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_;
                                AddArgument.doCached(arg0Value, arg1Value_, s0_.prevArgsState_, s0_.argState_, s0_.newArgsState_, backendLibrary__);
                                return;
                            }
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[SignatureBuilder.AddArgument.doGeneric(SignatureBuilder, NFIType, NFIBackendSignatureBuilderLibrary)] */) {
                        {
                            NFIBackendSignatureBuilderLibrary backendLibrary__1 = this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_;
                            AddArgument.doGeneric(arg0Value, arg1Value_, backendLibrary__1);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                addArgumentAndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void addArgumentAndSpecialize(SignatureBuilder arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg1Value instanceof NFIType) {
                    NFIType arg1Value_ = (NFIType) arg1Value;
                    {
                        NFIBackendSignatureBuilderLibrary backendLibrary__ = null;
                        if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[SignatureBuilder.AddArgument.doGeneric(SignatureBuilder, NFIType, NFIBackendSignatureBuilderLibrary)] */) {
                            while (true) {
                                int count0_ = 0;
                                AddArgumentCachedData s0_ = ADD_ARGUMENT_CACHED_CACHE_UPDATER.getVolatile(this);
                                AddArgumentCachedData s0_original = s0_;
                                while (s0_ != null) {
                                    if ((arg0Value.argsState == s0_.prevArgsState_) && (arg1Value_.cachedState == s0_.argState_)) {
                                        backendLibrary__ = this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_;
                                        break;
                                    }
                                    count0_++;
                                    s0_ = null;
                                    break;
                                }
                                if (s0_ == null && count0_ < 1) {
                                    // assert (arg0Value.argsState == s0_.prevArgsState_);
                                    // assert (arg1Value_.cachedState == s0_.argState_);
                                    s0_ = new AddArgumentCachedData();
                                    ArgsCachedState prevArgsState__ = (arg0Value.argsState);
                                    Objects.requireNonNull(prevArgsState__, "Specialization 'doCached(SignatureBuilder, NFIType, ArgsCachedState, TypeCachedState, ArgsCachedState, NFIBackendSignatureBuilderLibrary)' cache 'prevArgsState' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s0_.prevArgsState_ = prevArgsState__;
                                    TypeCachedState argState__ = (arg1Value_.cachedState);
                                    Objects.requireNonNull(argState__, "Specialization 'doCached(SignatureBuilder, NFIType, ArgsCachedState, TypeCachedState, ArgsCachedState, NFIBackendSignatureBuilderLibrary)' cache 'argState' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s0_.argState_ = argState__;
                                    ArgsCachedState newArgsState__ = (prevArgsState__.addArg(argState__));
                                    Objects.requireNonNull(newArgsState__, "Specialization 'doCached(SignatureBuilder, NFIType, ArgsCachedState, TypeCachedState, ArgsCachedState, NFIBackendSignatureBuilderLibrary)' cache 'newArgsState' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s0_.newArgsState_ = newArgsState__;
                                    backendLibrary__ = this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_;
                                    if (!ADD_ARGUMENT_CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                        continue;
                                    }
                                    state_0 = state_0 | 0b1 /* add SpecializationActive[SignatureBuilder.AddArgument.doCached(SignatureBuilder, NFIType, ArgsCachedState, TypeCachedState, ArgsCachedState, NFIBackendSignatureBuilderLibrary)] */;
                                    this.state_0_ = state_0;
                                }
                                if (s0_ != null) {
                                    AddArgument.doCached(arg0Value, arg1Value_, s0_.prevArgsState_, s0_.argState_, s0_.newArgsState_, backendLibrary__);
                                    return;
                                }
                                break;
                            }
                        }
                    }
                    {
                        NFIBackendSignatureBuilderLibrary backendLibrary__1 = null;
                        backendLibrary__1 = this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_;
                        this.addArgument_cached_cache = null;
                        state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[SignatureBuilder.AddArgument.doCached(SignatureBuilder, NFIType, ArgsCachedState, TypeCachedState, ArgsCachedState, NFIBackendSignatureBuilderLibrary)] */;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[SignatureBuilder.AddArgument.doGeneric(SignatureBuilder, NFIType, NFIBackendSignatureBuilderLibrary)] */;
                        this.state_0_ = state_0;
                        AddArgument.doGeneric(arg0Value, arg1Value_, backendLibrary__1);
                        return;
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if (((state_0 & 0b11) & ((state_0 & 0b11) - 1)) == 0 /* is-single  */) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link SetReturnType#doSet}
             *     Activation probability: 0.25000
             *     With/without class size: 7/0 bytes
             * </pre>
             */
            @Override
            public void setReturnType(Object arg0Value_, Object arg1Value) {
                assert arg0Value_ instanceof SignatureBuilder : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                SignatureBuilder arg0Value = ((SignatureBuilder) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[SignatureBuilder.SetReturnType.doSet(SignatureBuilder, NFIType, NFIBackendSignatureBuilderLibrary)] */ && arg1Value instanceof NFIType) {
                    NFIType arg1Value_ = (NFIType) arg1Value;
                    {
                        NFIBackendSignatureBuilderLibrary backendLibrary__ = this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_;
                        SetReturnType.doSet(arg0Value, arg1Value_, backendLibrary__);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                setReturnTypeAndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void setReturnTypeAndSpecialize(SignatureBuilder arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                {
                    NFIBackendSignatureBuilderLibrary backendLibrary__ = null;
                    if (arg1Value instanceof NFIType) {
                        NFIType arg1Value_ = (NFIType) arg1Value;
                        backendLibrary__ = this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[SignatureBuilder.SetReturnType.doSet(SignatureBuilder, NFIType, NFIBackendSignatureBuilderLibrary)] */;
                        this.state_0_ = state_0;
                        SetReturnType.doSet(arg0Value, arg1Value_, backendLibrary__);
                        return;
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link Build#doCached}
             *     Activation probability: 0.16250
             *     With/without class size: 6/4 bytes
             *   Specialization {@link Build#doGeneric}
             *     Activation probability: 0.08750
             *     With/without class size: 5/0 bytes
             * </pre>
             */
            @Override
            public Object build(Object arg0Value_) {
                assert arg0Value_ instanceof SignatureBuilder : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                SignatureBuilder arg0Value = ((SignatureBuilder) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[SignatureBuilder.Build.doCached(SignatureBuilder, SignatureCachedState, NFIBackendSignatureBuilderLibrary)] || SpecializationActive[SignatureBuilder.Build.doGeneric(SignatureBuilder, NFIBackendSignatureBuilderLibrary)] */) {
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[SignatureBuilder.Build.doCached(SignatureBuilder, SignatureCachedState, NFIBackendSignatureBuilderLibrary)] */) {
                        BuildCachedData s0_ = this.build_cached_cache;
                        if (s0_ != null) {
                            if ((arg0Value.argsState == s0_.cachedState_.args) && (arg0Value.retTypeState == s0_.cachedState_.retType)) {
                                NFIBackendSignatureBuilderLibrary backendLibrary__ = this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_;
                                return Build.doCached(arg0Value, s0_.cachedState_, backendLibrary__);
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[SignatureBuilder.Build.doGeneric(SignatureBuilder, NFIBackendSignatureBuilderLibrary)] */) {
                        {
                            NFIBackendSignatureBuilderLibrary backendLibrary__1 = this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_;
                            return Build.doGeneric(arg0Value, backendLibrary__1);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return buildAndSpecialize(arg0Value);
            }

            @SuppressWarnings("unused")
            private NFISignature buildAndSpecialize(SignatureBuilder arg0Value) {
                int state_0 = this.state_0_;
                {
                    NFIBackendSignatureBuilderLibrary backendLibrary__ = null;
                    if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[SignatureBuilder.Build.doGeneric(SignatureBuilder, NFIBackendSignatureBuilderLibrary)] */) {
                        while (true) {
                            int count0_ = 0;
                            BuildCachedData s0_ = BUILD_CACHED_CACHE_UPDATER.getVolatile(this);
                            BuildCachedData s0_original = s0_;
                            while (s0_ != null) {
                                if ((arg0Value.argsState == s0_.cachedState_.args) && (arg0Value.retTypeState == s0_.cachedState_.retType)) {
                                    backendLibrary__ = this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_;
                                    break;
                                }
                                count0_++;
                                s0_ = null;
                                break;
                            }
                            if (s0_ == null && count0_ < 1) {
                                {
                                    SignatureCachedState cachedState__ = (SignatureCachedState.create(arg0Value));
                                    if ((arg0Value.argsState == cachedState__.args) && (arg0Value.retTypeState == cachedState__.retType)) {
                                        s0_ = new BuildCachedData();
                                        Objects.requireNonNull(cachedState__, "Specialization 'doCached(SignatureBuilder, SignatureCachedState, NFIBackendSignatureBuilderLibrary)' cache 'cachedState' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                        s0_.cachedState_ = cachedState__;
                                        backendLibrary__ = this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_;
                                        if (!BUILD_CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                            continue;
                                        }
                                        state_0 = state_0 | 0b1000 /* add SpecializationActive[SignatureBuilder.Build.doCached(SignatureBuilder, SignatureCachedState, NFIBackendSignatureBuilderLibrary)] */;
                                        this.state_0_ = state_0;
                                    }
                                }
                            }
                            if (s0_ != null) {
                                return Build.doCached(arg0Value, s0_.cachedState_, backendLibrary__);
                            }
                            break;
                        }
                    }
                }
                {
                    NFIBackendSignatureBuilderLibrary backendLibrary__1 = null;
                    backendLibrary__1 = this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_;
                    this.build_cached_cache = null;
                    state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[SignatureBuilder.Build.doCached(SignatureBuilder, SignatureCachedState, NFIBackendSignatureBuilderLibrary)] */;
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[SignatureBuilder.Build.doGeneric(SignatureBuilder, NFIBackendSignatureBuilderLibrary)] */;
                    this.state_0_ = state_0;
                    return Build.doGeneric(arg0Value, backendLibrary__1);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link SignatureBuilder#makeVarargs(SignatureBuilder, NFIBackendSignatureBuilderLibrary)}
             *     Activation probability: 0.25000
             *     With/without class size: 7/0 bytes
             * </pre>
             */
            @Override
            public void makeVarargs(Object arg0Value_) {
                assert arg0Value_ instanceof SignatureBuilder : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                SignatureBuilder arg0Value = ((SignatureBuilder) arg0Value_);
                {
                    NFIBackendSignatureBuilderLibrary backendLibrary__ = this.receiverBackendBuilderNFIBackendSignatureBuilderLibrary_;
                    arg0Value.makeVarargs(backendLibrary__);
                    return;
                }
            }

            @GeneratedBy(SignatureBuilder.class)
            @DenyReplace
            private static final class AddArgumentCachedData implements SpecializationDataNode {

                /**
                 * Source Info: <pre>
                 *   Specialization: {@link AddArgument#doCached}
                 *   Parameter: {@link ArgsCachedState} prevArgsState</pre>
                 */
                @CompilationFinal ArgsCachedState prevArgsState_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link AddArgument#doCached}
                 *   Parameter: {@link TypeCachedState} argState</pre>
                 */
                @CompilationFinal TypeCachedState argState_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link AddArgument#doCached}
                 *   Parameter: {@link ArgsCachedState} newArgsState</pre>
                 */
                @CompilationFinal ArgsCachedState newArgsState_;

                AddArgumentCachedData() {
                }

            }
            @GeneratedBy(SignatureBuilder.class)
            @DenyReplace
            private static final class BuildCachedData implements SpecializationDataNode {

                /**
                 * Source Info: <pre>
                 *   Specialization: {@link Build#doCached}
                 *   Parameter: {@link SignatureCachedState} cachedState</pre>
                 */
                @CompilationFinal SignatureCachedState cachedState_;

                BuildCachedData() {
                }

            }
        }
        @GeneratedBy(SignatureBuilder.class)
        @DenyReplace
        private static final class Uncached extends NFIBackendSignatureBuilderLibrary {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof SignatureBuilder) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof SignatureBuilder;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public void addArgument(Object arg0Value_, Object arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                SignatureBuilder arg0Value = ((SignatureBuilder) arg0Value_);
                if (arg1Value instanceof NFIType) {
                    NFIType arg1Value_ = (NFIType) arg1Value;
                    AddArgument.doGeneric(arg0Value, arg1Value_, N_F_I_BACKEND_SIGNATURE_BUILDER_LIBRARY_.getUncached((arg0Value.backendBuilder)));
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public void setReturnType(Object arg0Value_, Object arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                SignatureBuilder arg0Value = ((SignatureBuilder) arg0Value_);
                if (arg1Value instanceof NFIType) {
                    NFIType arg1Value_ = (NFIType) arg1Value;
                    SetReturnType.doSet(arg0Value, arg1Value_, N_F_I_BACKEND_SIGNATURE_BUILDER_LIBRARY_.getUncached((arg0Value.backendBuilder)));
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public Object build(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                SignatureBuilder arg0Value = ((SignatureBuilder) arg0Value_);
                return Build.doGeneric(arg0Value, N_F_I_BACKEND_SIGNATURE_BUILDER_LIBRARY_.getUncached((arg0Value.backendBuilder)));
            }

            @TruffleBoundary
            @Override
            public void makeVarargs(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                SignatureBuilder arg0Value = ((SignatureBuilder) arg0Value_);
                arg0Value.makeVarargs(N_F_I_BACKEND_SIGNATURE_BUILDER_LIBRARY_.getUncached((arg0Value.backendBuilder)));
                return;
            }

        }
    }
}
