// CheckStyle: start generated
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.nfi.ConvertTypeNode.ConvertFromNativeNode;
import com.oracle.truffle.nfi.ConvertTypeNode.ConvertToNativeNode;
import com.oracle.truffle.nfi.ConvertTypeNodeFactory.ConvertFromNativeNodeGen;
import com.oracle.truffle.nfi.ConvertTypeNodeFactory.ConvertToNativeNodeGen;
import com.oracle.truffle.nfi.NFIClosure.Execute;
import com.oracle.truffle.nfi.NFISignature.SignatureCachedState;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.Objects;

@GeneratedBy(NFIClosure.class)
@SuppressWarnings("javadoc")
final class NFIClosureGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(NFIClosure.class, new InteropLibraryExports());
    }

    private NFIClosureGen() {
    }

    @GeneratedBy(NFIClosure.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, NFIClosure.class, false, false, 0);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof NFIClosure;
            InteropLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof NFIClosure;
            return new Cached(receiver);
        }

        @GeneratedBy(NFIClosure.class)
        private static final class Cached extends InteropLibrary {

            private static final StateField SLOW_PATH__EXECUTE_SLOW_PATH_STATE_0_UPDATER = StateField.create(ExecuteSlowPathData.lookup_(), "slowPath_state_0_");
            static final ReferenceField<ExecuteOptimizedDirectData> EXECUTE_OPTIMIZED_DIRECT_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "execute_optimizedDirect_cache", ExecuteOptimizedDirectData.class);
            /**
             * Source Info: <pre>
             *   Specialization: {@link Execute#doSlowPath}
             *   Parameter: {@link InlinedBranchProfile} exception
             *   Inline method: {@link InlinedBranchProfile#inline}</pre>
             */
            private static final InlinedBranchProfile INLINED_EXECUTE_SLOW_PATH_EXCEPTION_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, SLOW_PATH__EXECUTE_SLOW_PATH_STATE_0_UPDATER.subUpdater(0, 1)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link Execute#doSlowPath}
             *   Parameter: {@link ConvertFromNativeNode} convertArg
             *   Inline method: {@link ConvertFromNativeNodeGen#inline}</pre>
             */
            private static final ConvertFromNativeNode INLINED_EXECUTE_SLOW_PATH_CONVERT_ARG_ = ConvertFromNativeNodeGen.inline(InlineTarget.create(ConvertFromNativeNode.class, SLOW_PATH__EXECUTE_SLOW_PATH_STATE_0_UPDATER.subUpdater(1, 3), ReferenceField.create(ExecuteSlowPathData.lookup_(), "execute_slowPath_convertArg__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link Execute#doSlowPath}
             *   Parameter: {@link ConvertToNativeNode} convertRet
             *   Inline method: {@link ConvertToNativeNodeGen#inline}</pre>
             */
            private static final ConvertToNativeNode INLINED_EXECUTE_SLOW_PATH_CONVERT_RET_ = ConvertToNativeNodeGen.inline(InlineTarget.create(ConvertToNativeNode.class, SLOW_PATH__EXECUTE_SLOW_PATH_STATE_0_UPDATER.subUpdater(4, 3), ReferenceField.create(ExecuteSlowPathData.lookup_(), "execute_slowPath_convertRet__field1_", Node.class)));

            @Child private InteropLibrary receiverExecutableInteropLibrary_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link Execute#doOptimizedDirect}
             *   1: SpecializationActive {@link Execute#doOptimizedIndirect}
             *   2: SpecializationActive {@link Execute#doSlowPath}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            @UnsafeAccessedField @Child private ExecuteOptimizedDirectData execute_optimizedDirect_cache;
            /**
             * Source Info: <pre>
             *   Specialization: {@link Execute#doOptimizedIndirect}
             *   Parameter: {@link IndirectCallNode} call</pre>
             */
            @Child private IndirectCallNode execute_optimizedIndirect_call_;
            @Child private ExecuteSlowPathData execute_slowPath_cache;

            protected Cached(Object receiver) {
                NFIClosure castReceiver = ((NFIClosure) receiver) ;
                this.receiverExecutableInteropLibrary_ = INTEROP_LIBRARY_.create((castReceiver.executable));
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof NFIClosure) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof NFIClosure)) {
                    return false;
                } else if (!this.receiverExecutableInteropLibrary_.accepts((((NFIClosure) receiver).executable))) {
                    return false;
                } else {
                    return true;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link Execute#doOptimizedDirect}
             *     Activation probability: 0.24167
             *     With/without class size: 10/8 bytes
             *   Specialization {@link Execute#doOptimizedIndirect}
             *     Activation probability: 0.16667
             *     With/without class size: 7/4 bytes
             *   Specialization {@link Execute#doSlowPath}
             *     Activation probability: 0.09167
             *     With/without class size: 6/9 bytes
             * </pre>
             */
            @ExplodeLoop
            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert arg0Value_ instanceof NFIClosure : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                NFIClosure arg0Value = ((NFIClosure) arg0Value_);
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[NFIClosure.Execute.doOptimizedDirect(NFIClosure, Object[], SignatureCachedState, CallSignatureNode)] || SpecializationActive[NFIClosure.Execute.doOptimizedIndirect(NFIClosure, Object[], IndirectCallNode)] || SpecializationActive[NFIClosure.Execute.doSlowPath(NFIClosure, Object[], Node, InlinedBranchProfile, ConvertFromNativeNode, ConvertToNativeNode, InteropLibrary)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[NFIClosure.Execute.doOptimizedDirect(NFIClosure, Object[], SignatureCachedState, CallSignatureNode)] */ && (arg0Value.signature.cachedState != null)) {
                        ExecuteOptimizedDirectData s0_ = this.execute_optimizedDirect_cache;
                        while (s0_ != null) {
                            if ((arg0Value.signature.cachedState == s0_.cachedState_)) {
                                return Execute.doOptimizedDirect(arg0Value, arg1Value, s0_.cachedState_, s0_.call_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[NFIClosure.Execute.doOptimizedIndirect(NFIClosure, Object[], IndirectCallNode)] */) {
                        {
                            IndirectCallNode call__ = this.execute_optimizedIndirect_call_;
                            if (call__ != null) {
                                if ((arg0Value.signature.cachedState != null)) {
                                    return Execute.doOptimizedIndirect(arg0Value, arg1Value, call__);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[NFIClosure.Execute.doSlowPath(NFIClosure, Object[], Node, InlinedBranchProfile, ConvertFromNativeNode, ConvertToNativeNode, InteropLibrary)] */) {
                        ExecuteSlowPathData s2_ = this.execute_slowPath_cache;
                        if (s2_ != null) {
                            if ((arg0Value.signature.cachedState == null)) {
                                Node node__ = (s2_);
                                InteropLibrary interop__ = this.receiverExecutableInteropLibrary_;
                                return Execute.doSlowPath(arg0Value, arg1Value, node__, INLINED_EXECUTE_SLOW_PATH_EXCEPTION_, INLINED_EXECUTE_SLOW_PATH_CONVERT_ARG_, INLINED_EXECUTE_SLOW_PATH_CONVERT_RET_, interop__);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(NFIClosure arg0Value, Object[] arg1Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                int state_0 = this.state_0_;
                if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[NFIClosure.Execute.doOptimizedIndirect(NFIClosure, Object[], IndirectCallNode)] */ && (arg0Value.signature.cachedState != null)) {
                    while (true) {
                        int count0_ = 0;
                        ExecuteOptimizedDirectData s0_ = EXECUTE_OPTIMIZED_DIRECT_CACHE_UPDATER.getVolatile(this);
                        ExecuteOptimizedDirectData s0_original = s0_;
                        while (s0_ != null) {
                            if ((arg0Value.signature.cachedState == s0_.cachedState_)) {
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            // assert (arg0Value.signature.cachedState == s0_.cachedState_);
                            if (count0_ < (3)) {
                                s0_ = this.insert(new ExecuteOptimizedDirectData(s0_original));
                                s0_.cachedState_ = (arg0Value.signature.cachedState);
                                CallSignatureNode call__1 = s0_.insert((s0_.cachedState_.createOptimizedClosureCall()));
                                Objects.requireNonNull(call__1, "Specialization 'doOptimizedDirect(NFIClosure, Object[], SignatureCachedState, CallSignatureNode)' cache 'call' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s0_.call_ = call__1;
                                if (!EXECUTE_OPTIMIZED_DIRECT_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1 /* add SpecializationActive[NFIClosure.Execute.doOptimizedDirect(NFIClosure, Object[], SignatureCachedState, CallSignatureNode)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s0_ != null) {
                            return Execute.doOptimizedDirect(arg0Value, arg1Value, s0_.cachedState_, s0_.call_);
                        }
                        break;
                    }
                }
                if ((arg0Value.signature.cachedState != null)) {
                    VarHandle.storeStoreFence();
                    this.execute_optimizedIndirect_call_ = this.insert((IndirectCallNode.create()));
                    this.execute_optimizedDirect_cache = null;
                    state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[NFIClosure.Execute.doOptimizedDirect(NFIClosure, Object[], SignatureCachedState, CallSignatureNode)] */;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[NFIClosure.Execute.doOptimizedIndirect(NFIClosure, Object[], IndirectCallNode)] */;
                    this.state_0_ = state_0;
                    return Execute.doOptimizedIndirect(arg0Value, arg1Value, this.execute_optimizedIndirect_call_);
                }
                {
                    InteropLibrary interop__ = null;
                    Node node__ = null;
                    if ((arg0Value.signature.cachedState == null)) {
                        ExecuteSlowPathData s2_ = this.insert(new ExecuteSlowPathData());
                        node__ = (s2_);
                        interop__ = this.receiverExecutableInteropLibrary_;
                        VarHandle.storeStoreFence();
                        this.execute_slowPath_cache = s2_;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[NFIClosure.Execute.doSlowPath(NFIClosure, Object[], Node, InlinedBranchProfile, ConvertFromNativeNode, ConvertToNativeNode, InteropLibrary)] */;
                        this.state_0_ = state_0;
                        return Execute.doSlowPath(arg0Value, arg1Value, node__, INLINED_EXECUTE_SLOW_PATH_EXCEPTION_, INLINED_EXECUTE_SLOW_PATH_CONVERT_ARG_, INLINED_EXECUTE_SLOW_PATH_CONVERT_RET_, interop__);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if ((state_0 & (state_0 - 1)) == 0 /* is-single  */) {
                        ExecuteOptimizedDirectData s0_ = this.execute_optimizedDirect_cache;
                        if ((s0_ == null || s0_.next_ == null)) {
                            return NodeCost.MONOMORPHIC;
                        }
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link NFIClosure#isExecutable(NFIClosure, InteropLibrary)}
             *     Activation probability: 0.50000
             *     With/without class size: 10/0 bytes
             * </pre>
             */
            @Override
            public boolean isExecutable(Object arg0Value_) {
                assert arg0Value_ instanceof NFIClosure : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                NFIClosure arg0Value = ((NFIClosure) arg0Value_);
                {
                    InteropLibrary interop__ = this.receiverExecutableInteropLibrary_;
                    return arg0Value.isExecutable(interop__);
                }
            }

            @GeneratedBy(NFIClosure.class)
            @DenyReplace
            private static final class ExecuteOptimizedDirectData extends Node implements SpecializationDataNode {

                @Child ExecuteOptimizedDirectData next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link Execute#doOptimizedDirect}
                 *   Parameter: {@link SignatureCachedState} cachedState</pre>
                 */
                @CompilationFinal SignatureCachedState cachedState_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link Execute#doOptimizedDirect}
                 *   Parameter: {@link CallSignatureNode} call</pre>
                 */
                @Child CallSignatureNode call_;

                ExecuteOptimizedDirectData(ExecuteOptimizedDirectData next_) {
                    this.next_ = next_;
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

            }
            @GeneratedBy(NFIClosure.class)
            @DenyReplace
            private static final class ExecuteSlowPathData extends Node implements SpecializationDataNode {

                /**
                 * State Info: <pre>
                 *   0: InlinedCache
                 *        Specialization: {@link Execute#doSlowPath}
                 *        Parameter: {@link InlinedBranchProfile} exception
                 *        Inline method: {@link InlinedBranchProfile#inline}
                 *   1-3: InlinedCache
                 *        Specialization: {@link Execute#doSlowPath}
                 *        Parameter: {@link ConvertFromNativeNode} convertArg
                 *        Inline method: {@link ConvertFromNativeNodeGen#inline}
                 *   4-6: InlinedCache
                 *        Specialization: {@link Execute#doSlowPath}
                 *        Parameter: {@link ConvertToNativeNode} convertRet
                 *        Inline method: {@link ConvertToNativeNodeGen#inline}
                 * </pre>
                 */
                @CompilationFinal @UnsafeAccessedField private int slowPath_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link Execute#doSlowPath}
                 *   Parameter: {@link ConvertFromNativeNode} convertArg
                 *   Inline method: {@link ConvertFromNativeNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre>
                 */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node execute_slowPath_convertArg__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link Execute#doSlowPath}
                 *   Parameter: {@link ConvertToNativeNode} convertRet
                 *   Inline method: {@link ConvertToNativeNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre>
                 */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node execute_slowPath_convertRet__field1_;

                ExecuteSlowPathData() {
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
        }
        @GeneratedBy(NFIClosure.class)
        @DenyReplace
        private static final class Uncached extends InteropLibrary {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof NFIClosure) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof NFIClosure;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFIClosure arg0Value = ((NFIClosure) arg0Value_);
                if ((arg0Value.signature.cachedState != null)) {
                    return Execute.doOptimizedIndirect(arg0Value, arg1Value, (IndirectCallNode.getUncached()));
                }
                if ((arg0Value.signature.cachedState == null)) {
                    return Execute.doSlowPath(arg0Value, arg1Value, (this), (InlinedBranchProfile.getUncached()), (ConvertFromNativeNodeGen.getUncached()), (ConvertToNativeNodeGen.getUncached()), INTEROP_LIBRARY_.getUncached((arg0Value.executable)));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public boolean isExecutable(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                NFIClosure arg0Value = ((NFIClosure) arg0Value_);
                return arg0Value.isExecutable(INTEROP_LIBRARY_.getUncached((arg0Value.executable)));
            }

        }
    }
}
