// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Concats all tensors in the list along the 0th dimension.
 * 
 *  Requires that all tensors have the same shape except the first dimension.
 * 
 *  input_handle: The input list.
 *  tensor: The concated result.
 *  lengths: Output tensor containing sizes of the 0th dimension of tensors in the list, used for computing the gradient.
 * 
 * 
 *  Arguments:
 *  * scope: A Scope object
 * 
 *  Returns:
 *  * {@code Output} tensor
 *  * {@code Output} lengths */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class TensorListConcat extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public TensorListConcat(Pointer p) { super(p); }

  /** Optional attribute setters for TensorListConcat */
  public static class Attrs extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Attrs() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Attrs(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Attrs(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Attrs position(long position) {
          return (Attrs)super.position(position);
      }
      @Override public Attrs getPointer(long i) {
          return new Attrs((Pointer)this).offsetAddress(i);
      }
  
    /** Defaults to <unknown> */
    public native @ByVal Attrs ElementShape(@ByVal PartialTensorShape x);

    public native @ByRef PartialTensorShape element_shape_(); public native Attrs element_shape_(PartialTensorShape setter);
  }
  public TensorListConcat(@Const @ByRef Scope scope, @ByVal Input input_handle, @Cast("tensorflow::DataType") int element_dtype) { super((Pointer)null); allocate(scope, input_handle, element_dtype); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input_handle, @Cast("tensorflow::DataType") int element_dtype);
  public TensorListConcat(@Const @ByRef Scope scope, @ByVal Input input_handle, @Cast("tensorflow::DataType") int element_dtype, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, input_handle, element_dtype, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input_handle, @Cast("tensorflow::DataType") int element_dtype, @Const @ByRef Attrs attrs);

  public static native @ByVal Attrs ElementShape(@ByVal PartialTensorShape x);

  public native @ByRef Operation operation(); public native TensorListConcat operation(Operation setter);
  public native @ByRef Output tensor(); public native TensorListConcat tensor(Output setter);
  public native @ByRef Output lengths(); public native TensorListConcat lengths(Output setter);
}
