// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Split the data from the input value into TensorArray elements.
 * 
 *  Assuming that {@code lengths} takes on values
 * 
 *    <pre>{@code (n0, n1, ..., n(T-1))}</pre>
 * 
 *  and that {@code value} has shape
 * 
 *    <pre>{@code (n0 + n1 + ... + n(T-1) x d0 x d1 x ...)}</pre>,
 * 
 *  this splits values into a TensorArray with T tensors.
 * 
 *  TensorArray index t will be the subtensor of values with starting position
 * 
 *    <pre>{@code (n0 + n1 + ... + n(t-1), 0, 0, ...)}</pre>
 * 
 *  and having size
 * 
 *    <pre>{@code nt x d0 x d1 x ...}</pre>
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * handle: The handle to a TensorArray.
 *  * value: The concatenated tensor to write to the TensorArray.
 *  * lengths: The vector of lengths, how to split the rows of value into the
 *  TensorArray.
 *  * flow_in: A float scalar that enforces proper chaining of operations.
 * 
 *  Returns:
 *  * {@code Output}: A float scalar that enforces proper chaining of operations. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class TensorArraySplit extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public TensorArraySplit(Pointer p) { super(p); }

  public TensorArraySplit(@Const @ByRef Scope scope, @ByVal Input handle,
                   @ByVal Input value, @ByVal Input lengths,
                   @ByVal Input flow_in) { super((Pointer)null); allocate(scope, handle, value, lengths, flow_in); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input handle,
                   @ByVal Input value, @ByVal Input lengths,
                   @ByVal Input flow_in);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public native @ByRef Operation operation(); public native TensorArraySplit operation(Operation setter);
  public native @ByRef Output flow_out(); public native TensorArraySplit flow_out(Output setter);
}
