// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** An array of Tensors of given size.
 * 
 *  Write data via Write and read via Read or Pack.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * size: The size of the array.
 *  * dtype: The type of the elements on the tensor_array.
 * 
 *  Optional attributes (see {@code Attrs}):
 *  * element_shape: The expected shape of an element, if known. Used to
 *  validate the shapes of TensorArray elements. If this shape is not
 *  fully specified, gathering zero-size TensorArrays is an error.
 *  * dynamic_size: A boolean that determines whether writes to the TensorArray
 *  are allowed to grow the size.  By default, this is not allowed.
 *  * clear_after_read: If true (default), Tensors in the TensorArray are cleared
 *  after being read.  This disables multiple read semantics but allows early
 *  release of memory.
 *  * identical_element_shapes: If true (default is false), then all
 *  elements in the TensorArray will be expected to have have identical shapes.
 *  This allows certain behaviors, like dynamically checking for
 *  consistent shapes on write, and being able to fill in properly
 *  shaped zero tensors on stack -- even if the element_shape attribute
 *  is not fully defined.
 *  * tensor_array_name: Overrides the name used for the temporary tensor_array
 *  resource. Default value is the name of the 'TensorArray' op (which
 *  is guaranteed unique).
 * 
 *  Returns:
 *  * {@code Output} handle: The handle to the TensorArray.
 *  * {@code Output} flow: A scalar used to control gradient flow. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class TensorArray extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public TensorArray(Pointer p) { super(p); }

  /** Optional attribute setters for TensorArray */
  public static class Attrs extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Attrs() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Attrs(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Attrs(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Attrs position(long position) {
          return (Attrs)super.position(position);
      }
      @Override public Attrs getPointer(long i) {
          return new Attrs((Pointer)this).offsetAddress(i);
      }
  
    /** The expected shape of an element, if known. Used to
     *  validate the shapes of TensorArray elements. If this shape is not
     *  fully specified, gathering zero-size TensorArrays is an error.
     * 
     *  Defaults to <unknown> */
    
    ///
    public native @ByVal Attrs ElementShape(@ByVal PartialTensorShape x);

    /** A boolean that determines whether writes to the TensorArray
     *  are allowed to grow the size.  By default, this is not allowed.
     * 
     *  Defaults to false */
    
    ///
    public native @ByVal Attrs DynamicSize(@Cast("bool") boolean x);

    /** If true (default), Tensors in the TensorArray are cleared
     *  after being read.  This disables multiple read semantics but allows early
     *  release of memory.
     * 
     *  Defaults to true */
    
    ///
    public native @ByVal Attrs ClearAfterRead(@Cast("bool") boolean x);

    /** If true (default is false), then all
     *  elements in the TensorArray will be expected to have have identical shapes.
     *  This allows certain behaviors, like dynamically checking for
     *  consistent shapes on write, and being able to fill in properly
     *  shaped zero tensors on stack -- even if the element_shape attribute
     *  is not fully defined.
     * 
     *  Defaults to false */
    
    ///
    public native @ByVal Attrs IdenticalElementShapes(@Cast("bool") boolean x);

    /** Overrides the name used for the temporary tensor_array
     *  resource. Default value is the name of the 'TensorArray' op (which
     *  is guaranteed unique).
     * 
     *  Defaults to "" */
    public native @ByVal Attrs TensorArrayName(@StringPiece BytePointer x);
    public native @ByVal Attrs TensorArrayName(@StringPiece String x);

    public native @ByRef PartialTensorShape element_shape_(); public native Attrs element_shape_(PartialTensorShape setter);
    public native @Cast("bool") boolean dynamic_size_(); public native Attrs dynamic_size_(boolean setter);
    public native @Cast("bool") boolean clear_after_read_(); public native Attrs clear_after_read_(boolean setter);
    public native @Cast("bool") boolean identical_element_shapes_(); public native Attrs identical_element_shapes_(boolean setter);
    public native @StringPiece BytePointer tensor_array_name_(); public native Attrs tensor_array_name_(BytePointer setter);
  }
  public TensorArray(@Const @ByRef Scope scope, @ByVal Input size,
              @Cast("tensorflow::DataType") int dtype) { super((Pointer)null); allocate(scope, size, dtype); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input size,
              @Cast("tensorflow::DataType") int dtype);
  public TensorArray(@Const @ByRef Scope scope, @ByVal Input size,
              @Cast("tensorflow::DataType") int dtype, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, size, dtype, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input size,
              @Cast("tensorflow::DataType") int dtype, @Const @ByRef Attrs attrs);

  public static native @ByVal Attrs ElementShape(@ByVal PartialTensorShape x);
  public static native @ByVal Attrs DynamicSize(@Cast("bool") boolean x);
  public static native @ByVal Attrs ClearAfterRead(@Cast("bool") boolean x);
  public static native @ByVal Attrs IdenticalElementShapes(@Cast("bool") boolean x);
  public static native @ByVal Attrs TensorArrayName(@StringPiece BytePointer x);
  public static native @ByVal Attrs TensorArrayName(@StringPiece String x);

  public native @ByRef Operation operation(); public native TensorArray operation(Operation setter);
  public native @ByRef Output handle(); public native TensorArray handle(Output setter);
  public native @ByRef Output flow(); public native TensorArray flow(Output setter);
}
