// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Converts each string in the input Tensor to its hash mod by a number of buckets.
 * 
 *  The hash function is deterministic on the content of the string within the
 *  process. The hash function is a keyed hash function, where attribute {@code key}
 *  defines the key of the hash function. {@code key} is an array of 2 elements.
 * 
 *  A strong hash is important when inputs may be malicious, e.g. URLs with
 *  additional components. Adversaries could try to make their inputs hash to the
 *  same bucket for a denial-of-service attack or to skew the results. A strong
 *  hash can be used to make it difficult to find inputs with a skewed hash value
 *  distribution over buckets. This requires that the hash function is
 *  seeded by a high-entropy (random) "key" unknown to the adversary.
 * 
 *  The additional robustness comes at a cost of roughly 4x higher compute
 *  time than {@code tf.string_to_hash_bucket_fast}.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * input: The strings to assign a hash bucket.
 *  * num_buckets: The number of buckets.
 *  * key: The key used to seed the hash function, passed as a list of two uint64
 *  elements.
 * 
 *  Returns:
 *  * {@code Output}: A Tensor of the same shape as the input {@code string_tensor}. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class StringToHashBucketStrong extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public StringToHashBucketStrong(Pointer p) { super(p); }

  public StringToHashBucketStrong(@Const @ByRef Scope scope, @ByVal Input input, @Cast("tensorflow::int64") long num_buckets, @ArraySlice IntPointer key) { super((Pointer)null); allocate(scope, input, num_buckets, key); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @Cast("tensorflow::int64") long num_buckets, @ArraySlice IntPointer key);
  public StringToHashBucketStrong(@Const @ByRef Scope scope, @ByVal Input input, @Cast("tensorflow::int64") long num_buckets, @ArraySlice IntBuffer key) { super((Pointer)null); allocate(scope, input, num_buckets, key); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @Cast("tensorflow::int64") long num_buckets, @ArraySlice IntBuffer key);
  public StringToHashBucketStrong(@Const @ByRef Scope scope, @ByVal Input input, @Cast("tensorflow::int64") long num_buckets, @ArraySlice int... key) { super((Pointer)null); allocate(scope, input, num_buckets, key); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @Cast("tensorflow::int64") long num_buckets, @ArraySlice int... key);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public native @ByRef Operation operation(); public native StringToHashBucketStrong operation(Operation setter);
  public native @ByRef Output output(); public native StringToHashBucketStrong output(Output setter);
}
