// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Applies softmax to a batched N-D {@code SparseTensor}.
 * 
 *  The inputs represent an N-D SparseTensor  with logical shape {@code [..., B, C]}
 *  (where {@code N >= 2}), and with indices sorted in the canonical lexicographic order.
 * 
 *  This op is equivalent to applying the normal {@code tf.nn.softmax()} to each innermost
 *  logical submatrix with shape {@code [B, C]}, but with the catch that *the implicitly
 *  zero elements do not participate*.  Specifically, the algorithm is equivalent
 *  to the following:
 * 
 *    (1) Applies {@code tf.nn.softmax()} to a densified view of each innermost submatrix
 *        with shape {@code [B, C]}, along the size-C dimension;
 *    (2) Masks out the original implicitly-zero locations;
 *    (3) Renormalizes the remaining elements.
 * 
 *  Hence, the {@code SparseTensor} result has exactly the same non-zero indices and
 *  shape.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * sp_indices: 2-D.  {@code NNZ x R} matrix with the indices of non-empty values in a
 *  SparseTensor, in canonical ordering.
 *  * sp_values: 1-D.  {@code NNZ} non-empty values corresponding to {@code sp_indices}.
 *  * sp_shape: 1-D.  Shape of the input SparseTensor.
 * 
 *  Returns:
 *  * {@code Output}: 1-D.  The {@code NNZ} values for the result {@code SparseTensor}. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class SparseSoftmax extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public SparseSoftmax(Pointer p) { super(p); }

  public SparseSoftmax(@Const @ByRef Scope scope, @ByVal Input sp_indices,
                @ByVal Input sp_values, @ByVal Input sp_shape) { super((Pointer)null); allocate(scope, sp_indices, sp_values, sp_shape); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input sp_indices,
                @ByVal Input sp_values, @ByVal Input sp_shape);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public native @ByRef Operation operation(); public native SparseSoftmax operation(Operation setter);
  public native @ByRef Output output(); public native SparseSoftmax output(Output setter);
}
