// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Multiply matrix "a" by matrix "b".
 * 
 *  The inputs must be two-dimensional matrices and the inner dimension of "a" must
 *  match the outer dimension of "b". Both "a" and "b" must be {@code Tensor}s not
 *  {@code SparseTensor}s.  This op is optimized for the case where at least one of "a" or
 *  "b" is sparse, in the sense that they have a large proportion of zero values.
 *  The breakeven for using this versus a dense matrix multiply on one platform was
 *  30% zero values in the sparse matrix.
 * 
 *  The gradient computation of this operation will only take advantage of sparsity
 *  in the input gradient when that gradient comes from a Relu.
 * 
 *  Arguments:
 *  * scope: A Scope object
 * 
 *  Returns:
 *  * {@code Output}: The product tensor. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class SparseMatMul extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public SparseMatMul(Pointer p) { super(p); }

  /** Optional attribute setters for SparseMatMul */
  public static class Attrs extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Attrs() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Attrs(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Attrs(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Attrs position(long position) {
          return (Attrs)super.position(position);
      }
      @Override public Attrs getPointer(long i) {
          return new Attrs((Pointer)this).offsetAddress(i);
      }
  
    /** Defaults to false */
    public native @ByVal Attrs TransposeA(@Cast("bool") boolean x);

    /** Defaults to false */
    public native @ByVal Attrs TransposeB(@Cast("bool") boolean x);

    /** Defaults to false */
    public native @ByVal Attrs AIsSparse(@Cast("bool") boolean x);

    /** Defaults to false */
    public native @ByVal Attrs BIsSparse(@Cast("bool") boolean x);

    public native @Cast("bool") boolean transpose_a_(); public native Attrs transpose_a_(boolean setter);
    public native @Cast("bool") boolean transpose_b_(); public native Attrs transpose_b_(boolean setter);
    public native @Cast("bool") boolean a_is_sparse_(); public native Attrs a_is_sparse_(boolean setter);
    public native @Cast("bool") boolean b_is_sparse_(); public native Attrs b_is_sparse_(boolean setter);
  }
  public SparseMatMul(@Const @ByRef Scope scope, @ByVal Input a,
               @ByVal Input b) { super((Pointer)null); allocate(scope, a, b); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input a,
               @ByVal Input b);
  public SparseMatMul(@Const @ByRef Scope scope, @ByVal Input a,
               @ByVal Input b, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, a, b, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input a,
               @ByVal Input b, @Const @ByRef Attrs attrs);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public static native @ByVal Attrs TransposeA(@Cast("bool") boolean x);
  public static native @ByVal Attrs TransposeB(@Cast("bool") boolean x);
  public static native @ByVal Attrs AIsSparse(@Cast("bool") boolean x);
  public static native @ByVal Attrs BIsSparse(@Cast("bool") boolean x);

  public native @ByRef Operation operation(); public native SparseMatMul operation(Operation setter);
  public native @ByRef Output product(); public native SparseMatMul product(Output setter);
}
