// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Fills empty rows in the input 2-D {@code SparseTensor} with a default value.
 * 
 *  The input {@code SparseTensor} is represented via the tuple of inputs
 *  ({@code indices}, {@code values}, {@code dense_shape}).  The output {@code SparseTensor} has the
 *  same {@code dense_shape} but with indices {@code output_indices} and values
 *  {@code output_values}.
 * 
 *  This op inserts a single entry for every row that doesn't have any values.
 *  The index is created as {@code [row, 0, ..., 0]} and the inserted value
 *  is {@code default_value}.
 * 
 *  For example, suppose {@code sp_input} has shape {@code [5, 6]} and non-empty values:
 * 
 *      [0, 1]: a
 *      [0, 3]: b
 *      [2, 0]: c
 *      [3, 1]: d
 * 
 *  Rows 1 and 4 are empty, so the output will be of shape {@code [5, 6]} with values:
 * 
 *      [0, 1]: a
 *      [0, 3]: b
 *      [1, 0]: default_value
 *      [2, 0]: c
 *      [3, 1]: d
 *      [4, 0]: default_value
 * 
 *  The output {@code SparseTensor} will be in row-major order and will have the
 *  same shape as the input.
 * 
 *  This op also returns an indicator vector shaped {@code [dense_shape[0]]} such that
 * 
 *      empty_row_indicator[i] = True iff row i was an empty row.
 * 
 *  And a reverse index map vector shaped {@code [indices.shape[0]]} that is used during
 *  backpropagation,
 * 
 *      reverse_index_map[j] = out_j s.t. indices[j, :] == output_indices[out_j, :]
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * indices: 2-D. the indices of the sparse tensor.
 *  * values: 1-D. the values of the sparse tensor.
 *  * dense_shape: 1-D. the shape of the sparse tensor.
 *  * default_value: 0-D. default value to insert into location {@code [row, 0, ..., 0]}
 *    for rows missing from the input sparse tensor.
 *  output indices: 2-D. the indices of the filled sparse tensor.
 * 
 *  Returns:
 *  * {@code Output} output_indices
 *  * {@code Output} output_values: 1-D. the values of the filled sparse tensor.
 *  * {@code Output} empty_row_indicator: 1-D. whether the dense row was missing in the
 *  input sparse tensor.
 *  * {@code Output} reverse_index_map: 1-D. a map from the input indices to the output indices. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class SparseFillEmptyRows extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public SparseFillEmptyRows(Pointer p) { super(p); }

  public SparseFillEmptyRows(@Const @ByRef Scope scope, @ByVal Input indices, @ByVal Input values, @ByVal Input dense_shape, @ByVal Input default_value) { super((Pointer)null); allocate(scope, indices, values, dense_shape, default_value); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input indices, @ByVal Input values, @ByVal Input dense_shape, @ByVal Input default_value);

  public native @ByRef Operation operation(); public native SparseFillEmptyRows operation(Operation setter);
  public native @ByRef Output output_indices(); public native SparseFillEmptyRows output_indices(Output setter);
  public native @ByRef Output output_values(); public native SparseFillEmptyRows output_values(Output setter);
  public native @ByRef Output empty_row_indicator(); public native SparseFillEmptyRows empty_row_indicator(Output setter);
  public native @ByRef Output reverse_index_map(); public native SparseFillEmptyRows reverse_index_map(Output setter);
}
