// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


// SamplerCell stores each value of an Sampler.
//
// A cell can be passed off to a module which may repeatedly update it without
// needing further map-indexing computations. This improves both encapsulation
// (separate modules can own a cell each, without needing to know about the map
// to which both cells belong) and performance (since map indexing and
// associated locking are both avoided).
//
// This class is thread-safe.
@Namespace("tensorflow::monitoring") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class SamplerCell extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public SamplerCell(Pointer p) { super(p); }

  public SamplerCell(@StdVector DoublePointer bucket_limits) { super((Pointer)null); allocate(bucket_limits); }
  private native void allocate(@StdVector DoublePointer bucket_limits);
  public SamplerCell(@StdVector DoubleBuffer bucket_limits) { super((Pointer)null); allocate(bucket_limits); }
  private native void allocate(@StdVector DoubleBuffer bucket_limits);
  public SamplerCell(@StdVector double... bucket_limits) { super((Pointer)null); allocate(bucket_limits); }
  private native void allocate(@StdVector double... bucket_limits);

  // Atomically adds a sample.
  public native void Add(double sample);

  // Returns the current histogram value as a proto.
  public native @ByVal HistogramProto value();
}
