// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


// Class representing a handle to a tensorflow resource. Handles are
// not valid across executions, but can be serialized back and forth from within
// a single run.
//
// This is the native C++ class equivalent of ResourceHandleProto.  They are
// separate so that kernels do not need to depend on protos.
@Namespace("tensorflow") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class ResourceHandle extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ResourceHandle(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public ResourceHandle(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public ResourceHandle position(long position) {
        return (ResourceHandle)super.position(position);
    }
    @Override public ResourceHandle getPointer(long i) {
        return new ResourceHandle((Pointer)this).offsetAddress(i);
    }

  public ResourceHandle() { super((Pointer)null); allocate(); }
  private native void allocate();
  public ResourceHandle(@Const @ByRef ResourceHandleProto proto) { super((Pointer)null); allocate(proto); }
  private native void allocate(@Const @ByRef ResourceHandleProto proto);

  // Unique name for the device containing the resource.
  public native @StdString BytePointer device();
  public native void set_device(@StdString BytePointer device);
  public native void set_device(@StdString String device);

  // Container in which this resource is placed.
  public native @StdString BytePointer container();
  public native void set_container(@StdString BytePointer container);
  public native void set_container(@StdString String container);

  // Unique name of this resource.
  public native @StdString BytePointer name();
  public native void set_name(@StdString BytePointer name);
  public native void set_name(@StdString String name);

  // Hash code for the type of the resource. Is only valid in the same device
  // and in the same execution.
  public native @Cast("tensorflow::uint64") long hash_code();
  public native void set_hash_code(@Cast("tensorflow::uint64") long hash_code);

  // For debug-only, the name of the type pointed to by this handle, if
  // available.
  public native @StdString BytePointer maybe_type_name();
  public native void set_maybe_type_name(@StdString BytePointer value);
  public native void set_maybe_type_name(@StdString String value);

  // Data types and shapes for the underlying resource.
  public native @StdVector DtypeAndPartialTensorShape dtypes_and_shapes();
  public native void set_dtypes_and_shapes(
        @StdVector DtypeAndPartialTensorShape dtypes_and_shapes);

  // Conversion to and from ResourceHandleProto
  public native void AsProto(ResourceHandleProto proto);
  public native void FromProto(@Const @ByRef ResourceHandleProto proto);

  // Serialization via ResourceHandleProto
  public native @StdString BytePointer SerializeAsString();
  public native @Cast("bool") boolean ParseFromString(@StdString BytePointer s);
  public native @Cast("bool") boolean ParseFromString(@StdString String s);

  public native @StdString BytePointer DebugString();

  // GUID for anonymous resources. Resources with this shared_name will have
  // their shared_name replaced with a GUID at creation time
  @MemberGetter public static native @Cast("const char*") BytePointer ANONYMOUS_NAME();
  public native @StdString BytePointer device_(); public native ResourceHandle device_(BytePointer setter);
  public native @StdString BytePointer container_(); public native ResourceHandle container_(BytePointer setter);
  public native @StdString BytePointer name_(); public native ResourceHandle name_(BytePointer setter);
  public native @Cast("tensorflow::uint64") long hash_code_(); public native ResourceHandle hash_code_(long setter);
  public native @StdString BytePointer maybe_type_name_(); public native ResourceHandle maybe_type_name_(BytePointer setter);
  public native @StdVector DtypeAndPartialTensorShape dtypes_and_shapes_(); public native ResourceHandle dtypes_and_shapes_(DtypeAndPartialTensorShape setter);
}
