// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Increments variable pointed to by 'resource' until it reaches 'limit'.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * resource: Should be from a scalar {@code Variable} node.
 *  * limit: If incrementing ref would bring it above limit, instead generates an
 *  'OutOfRange' error.
 * 
 *  Returns:
 *  * {@code Output}: A copy of the input before increment. If nothing else modifies the
 *  input, the values produced will all be distinct. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class ResourceCountUpTo extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ResourceCountUpTo(Pointer p) { super(p); }

  public ResourceCountUpTo(@Const @ByRef Scope scope, @ByVal Input resource, @Cast("tensorflow::int64") long _limit, @Cast("tensorflow::DataType") int T) { super((Pointer)null); allocate(scope, resource, _limit, T); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input resource, @Cast("tensorflow::int64") long _limit, @Cast("tensorflow::DataType") int T);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public native @ByRef Operation operation(); public native ResourceCountUpTo operation(Operation setter);
  public native @ByRef Output output(); public native ResourceCountUpTo output(Output setter);
}
