// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Converts one or more images from RGB to HSV.
 * 
 *  Outputs a tensor of the same shape as the {@code images} tensor, containing the HSV
 *  value of the pixels. The output is only well defined if the value in {@code images}
 *  are in {@code [0,1]}.
 * 
 *  {@code output[..., 0]} contains hue, {@code output[..., 1]} contains saturation, and
 *  {@code output[..., 2]} contains value. All HSV values are in {@code [0,1]}. A hue of 0
 *  corresponds to pure red, hue 1/3 is pure green, and 2/3 is pure blue.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * images: 1-D or higher rank. RGB data to convert. Last dimension must be size 3.
 * 
 *  Returns:
 *  * {@code Output}: {@code images} converted to HSV. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class RGBToHSV extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public RGBToHSV(Pointer p) { super(p); }

  public RGBToHSV(@Const @ByRef Scope scope, @ByVal Input images) { super((Pointer)null); allocate(scope, images); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input images);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public native @ByRef Operation operation(); public native RGBToHSV operation(Operation setter);
  public native @ByRef Output output(); public native RGBToHSV output(Output setter);
}
