// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** An identity op that triggers an error if a gradient is requested.
 * 
 *  When executed in a graph, this op outputs its input tensor as-is.
 * 
 *  When building ops to compute gradients, the TensorFlow gradient system
 *  will return an error when trying to lookup the gradient of this op,
 *  because no gradient must ever be registered for this function.  This
 *  op exists to prevent subtle bugs from silently returning unimplemented
 *  gradients in some corner cases.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * input: any tensor.
 * 
 *  Optional attributes (see {@code Attrs}):
 *  * message: Will be printed in the error when anyone tries to differentiate
 *  this operation.
 * 
 *  Returns:
 *  * {@code Output}: the same input tensor. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class PreventGradient extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public PreventGradient(Pointer p) { super(p); }

  /** Optional attribute setters for PreventGradient */
  public static class Attrs extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Attrs() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Attrs(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Attrs(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Attrs position(long position) {
          return (Attrs)super.position(position);
      }
      @Override public Attrs getPointer(long i) {
          return new Attrs((Pointer)this).offsetAddress(i);
      }
  
    /** Will be printed in the error when anyone tries to differentiate
     *  this operation.
     * 
     *  Defaults to "" */
    public native @ByVal Attrs Message(@StringPiece BytePointer x);
    public native @ByVal Attrs Message(@StringPiece String x);

    public native @StringPiece BytePointer message_(); public native Attrs message_(BytePointer setter);
  }
  public PreventGradient(@Const @ByRef Scope scope, @ByVal Input input) { super((Pointer)null); allocate(scope, input); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input);
  public PreventGradient(@Const @ByRef Scope scope, @ByVal Input input,
                  @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, input, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input,
                  @Const @ByRef Attrs attrs);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public static native @ByVal Attrs Message(@StringPiece BytePointer x);
  public static native @ByVal Attrs Message(@StringPiece String x);

  public native @ByRef Operation operation(); public native PreventGradient operation(Operation setter);
  public native @ByRef Output output(); public native PreventGradient output(Output setter);
}
