// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Transforms a scalar brain.SequenceExample proto (as strings) into typed tensors.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * serialized: A scalar containing a binary serialized SequenceExample proto.
 *  * feature_list_dense_missing_assumed_empty: A vector listing the
 *  FeatureList keys which may be missing from the SequenceExample.  If the
 *  associated FeatureList is missing, it is treated as empty.  By default,
 *  any FeatureList not listed in this vector must exist in the SequenceExample.
 *  * context_sparse_keys: A list of Ncontext_sparse string Tensors (scalars).
 *  The keys expected in the Examples' features associated with context_sparse
 *  values.
 *  * context_dense_keys: A list of Ncontext_dense string Tensors (scalars).
 *  The keys expected in the SequenceExamples' context features associated with
 *  dense values.
 *  * feature_list_sparse_keys: A list of Nfeature_list_sparse string Tensors
 *  (scalars).  The keys expected in the FeatureLists associated with sparse
 *  values.
 *  * feature_list_dense_keys: A list of Nfeature_list_dense string Tensors (scalars).
 *  The keys expected in the SequenceExamples' feature_lists associated
 *  with lists of dense values.
 *  * context_dense_defaults: A list of Ncontext_dense Tensors (some may be empty).
 *  context_dense_defaults[j] provides default values
 *  when the SequenceExample's context map lacks context_dense_key[j].
 *  If an empty Tensor is provided for context_dense_defaults[j],
 *  then the Feature context_dense_keys[j] is required.
 *  The input type is inferred from context_dense_defaults[j], even when it's
 *  empty.  If context_dense_defaults[j] is not empty, its shape must match
 *  context_dense_shapes[j].
 *  * debug_name: A scalar containing the name of the serialized proto.
 *  May contain, for example, table key (descriptive) name for the
 *  corresponding serialized proto.  This is purely useful for debugging
 *  purposes, and the presence of values here has no effect on the output.
 *  May also be an empty scalar if no name is available.
 * 
 *  Optional attributes (see {@code Attrs}):
 *  * context_sparse_types: A list of Ncontext_sparse types; the data types of data in
 *  each context Feature given in context_sparse_keys.
 *  Currently the ParseSingleSequenceExample supports DT_FLOAT (FloatList),
 *  DT_INT64 (Int64List), and DT_STRING (BytesList).
 *  * context_dense_shapes: A list of Ncontext_dense shapes; the shapes of data in
 *  each context Feature given in context_dense_keys.
 *  The number of elements in the Feature corresponding to context_dense_key[j]
 *  must always equal context_dense_shapes[j].NumEntries().
 *  The shape of context_dense_values[j] will match context_dense_shapes[j].
 *  * feature_list_sparse_types: A list of Nfeature_list_sparse types; the data types
 *  of data in each FeatureList given in feature_list_sparse_keys.
 *  Currently the ParseSingleSequenceExample supports DT_FLOAT (FloatList),
 *  DT_INT64 (Int64List), and DT_STRING (BytesList).
 *  * feature_list_dense_shapes: A list of Nfeature_list_dense shapes; the shapes of
 *  data in each FeatureList given in feature_list_dense_keys.
 *  The shape of each Feature in the FeatureList corresponding to
 *  feature_list_dense_key[j] must always equal
 *  feature_list_dense_shapes[j].NumEntries().
 * 
 *  Returns:
 *  * {@code OutputList} context_sparse_indices
 *  * {@code OutputList} context_sparse_values
 *  * {@code OutputList} context_sparse_shapes
 *  * {@code OutputList} context_dense_values
 *  * {@code OutputList} feature_list_sparse_indices
 *  * {@code OutputList} feature_list_sparse_values
 *  * {@code OutputList} feature_list_sparse_shapes
 *  * {@code OutputList} feature_list_dense_values */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class ParseSingleSequenceExample extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ParseSingleSequenceExample(Pointer p) { super(p); }

  /** Optional attribute setters for ParseSingleSequenceExample */
  public static class Attrs extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Attrs() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Attrs(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Attrs(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Attrs position(long position) {
          return (Attrs)super.position(position);
      }
      @Override public Attrs getPointer(long i) {
          return new Attrs((Pointer)this).offsetAddress(i);
      }
  
    /** A list of Ncontext_sparse types; the data types of data in
     *  each context Feature given in context_sparse_keys.
     *  Currently the ParseSingleSequenceExample supports DT_FLOAT (FloatList),
     *  DT_INT64 (Int64List), and DT_STRING (BytesList).
     * 
     *  Defaults to [] */
    public native @ByVal Attrs ContextSparseTypes(@Cast("const tensorflow::DataTypeSlice*") @ByRef DataTypeVector x);

    /** Defaults to [] */
    
    ///
    public native @ByVal Attrs FeatureListDenseTypes(@Cast("const tensorflow::DataTypeSlice*") @ByRef DataTypeVector x);

    /** A list of Ncontext_dense shapes; the shapes of data in
     *  each context Feature given in context_dense_keys.
     *  The number of elements in the Feature corresponding to context_dense_key[j]
     *  must always equal context_dense_shapes[j].NumEntries().
     *  The shape of context_dense_values[j] will match context_dense_shapes[j].
     * 
     *  Defaults to [] */
    
    ///
    public native @ByVal Attrs ContextDenseShapes(@ArraySlice PartialTensorShape x);

    /** A list of Nfeature_list_sparse types; the data types
     *  of data in each FeatureList given in feature_list_sparse_keys.
     *  Currently the ParseSingleSequenceExample supports DT_FLOAT (FloatList),
     *  DT_INT64 (Int64List), and DT_STRING (BytesList).
     * 
     *  Defaults to [] */
    
    ///
    public native @ByVal Attrs FeatureListSparseTypes(@Cast("const tensorflow::DataTypeSlice*") @ByRef DataTypeVector x);

    /** A list of Nfeature_list_dense shapes; the shapes of
     *  data in each FeatureList given in feature_list_dense_keys.
     *  The shape of each Feature in the FeatureList corresponding to
     *  feature_list_dense_key[j] must always equal
     *  feature_list_dense_shapes[j].NumEntries().
     * 
     *  Defaults to [] */
    public native @ByVal Attrs FeatureListDenseShapes(@ArraySlice PartialTensorShape x);

    public native @ByRef @Cast("tensorflow::DataTypeSlice*") DataTypeVector context_sparse_types_(); public native Attrs context_sparse_types_(DataTypeVector setter);
    public native @ByRef @Cast("tensorflow::DataTypeSlice*") DataTypeVector feature_list_dense_types_(); public native Attrs feature_list_dense_types_(DataTypeVector setter);
    public native @ArraySlice PartialTensorShape context_dense_shapes_(); public native Attrs context_dense_shapes_(PartialTensorShape setter);
    public native @ByRef @Cast("tensorflow::DataTypeSlice*") DataTypeVector feature_list_sparse_types_(); public native Attrs feature_list_sparse_types_(DataTypeVector setter);
    public native @ArraySlice PartialTensorShape feature_list_dense_shapes_(); public native Attrs feature_list_dense_shapes_(PartialTensorShape setter);
  }
  public ParseSingleSequenceExample(@Const @ByRef Scope scope,
                             @ByVal Input serialized, @ByVal Input feature_list_dense_missing_assumed_empty,
                             @ByVal InputList context_sparse_keys,
                             @ByVal InputList context_dense_keys,
                             @ByVal InputList feature_list_sparse_keys,
                             @ByVal InputList feature_list_dense_keys,
                             @ByVal InputList context_dense_defaults,
                             @ByVal Input debug_name) { super((Pointer)null); allocate(scope, serialized, feature_list_dense_missing_assumed_empty, context_sparse_keys, context_dense_keys, feature_list_sparse_keys, feature_list_dense_keys, context_dense_defaults, debug_name); }
  private native void allocate(@Const @ByRef Scope scope,
                             @ByVal Input serialized, @ByVal Input feature_list_dense_missing_assumed_empty,
                             @ByVal InputList context_sparse_keys,
                             @ByVal InputList context_dense_keys,
                             @ByVal InputList feature_list_sparse_keys,
                             @ByVal InputList feature_list_dense_keys,
                             @ByVal InputList context_dense_defaults,
                             @ByVal Input debug_name);
  public ParseSingleSequenceExample(@Const @ByRef Scope scope,
                             @ByVal Input serialized, @ByVal Input feature_list_dense_missing_assumed_empty,
                             @ByVal InputList context_sparse_keys,
                             @ByVal InputList context_dense_keys,
                             @ByVal InputList feature_list_sparse_keys,
                             @ByVal InputList feature_list_dense_keys,
                             @ByVal InputList context_dense_defaults,
                             @ByVal Input debug_name, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, serialized, feature_list_dense_missing_assumed_empty, context_sparse_keys, context_dense_keys, feature_list_sparse_keys, feature_list_dense_keys, context_dense_defaults, debug_name, attrs); }
  private native void allocate(@Const @ByRef Scope scope,
                             @ByVal Input serialized, @ByVal Input feature_list_dense_missing_assumed_empty,
                             @ByVal InputList context_sparse_keys,
                             @ByVal InputList context_dense_keys,
                             @ByVal InputList feature_list_sparse_keys,
                             @ByVal InputList feature_list_dense_keys,
                             @ByVal InputList context_dense_defaults,
                             @ByVal Input debug_name, @Const @ByRef Attrs attrs);

  public static native @ByVal Attrs ContextSparseTypes(@Cast("const tensorflow::DataTypeSlice*") @ByRef DataTypeVector x);
  public static native @ByVal Attrs FeatureListDenseTypes(@Cast("const tensorflow::DataTypeSlice*") @ByRef DataTypeVector x);
  public static native @ByVal Attrs ContextDenseShapes(@ArraySlice PartialTensorShape x);
  public static native @ByVal Attrs FeatureListSparseTypes(@Cast("const tensorflow::DataTypeSlice*") @ByRef DataTypeVector x);
  public static native @ByVal Attrs FeatureListDenseShapes(@ArraySlice PartialTensorShape x);

  public native @ByRef Operation operation(); public native ParseSingleSequenceExample operation(Operation setter);
  public native @ByRef @Cast("tensorflow::OutputList*") OutputVector context_sparse_indices(); public native ParseSingleSequenceExample context_sparse_indices(OutputVector setter);
  public native @ByRef @Cast("tensorflow::OutputList*") OutputVector context_sparse_values(); public native ParseSingleSequenceExample context_sparse_values(OutputVector setter);
  public native @ByRef @Cast("tensorflow::OutputList*") OutputVector context_sparse_shapes(); public native ParseSingleSequenceExample context_sparse_shapes(OutputVector setter);
  public native @ByRef @Cast("tensorflow::OutputList*") OutputVector context_dense_values(); public native ParseSingleSequenceExample context_dense_values(OutputVector setter);
  public native @ByRef @Cast("tensorflow::OutputList*") OutputVector feature_list_sparse_indices(); public native ParseSingleSequenceExample feature_list_sparse_indices(OutputVector setter);
  public native @ByRef @Cast("tensorflow::OutputList*") OutputVector feature_list_sparse_values(); public native ParseSingleSequenceExample feature_list_sparse_values(OutputVector setter);
  public native @ByRef @Cast("tensorflow::OutputList*") OutputVector feature_list_sparse_shapes(); public native ParseSingleSequenceExample feature_list_sparse_shapes(OutputVector setter);
  public native @ByRef @Cast("tensorflow::OutputList*") OutputVector feature_list_dense_values(); public native ParseSingleSequenceExample feature_list_dense_values(OutputVector setter);
}
