// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Transforms a tf.Example proto (as a string) into typed tensors.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * serialized: A vector containing a batch of binary serialized Example protos.
 *  * dense_defaults: A list of Tensors (some may be empty), whose length matches
 *  the length of {@code dense_keys}. dense_defaults[j] provides default values
 *  when the example's feature_map lacks dense_key[j].  If an empty Tensor is
 *  provided for dense_defaults[j], then the Feature dense_keys[j] is required.
 *  The input type is inferred from dense_defaults[j], even when it's empty.
 *  If dense_defaults[j] is not empty, and dense_shapes[j] is fully defined,
 *  then the shape of dense_defaults[j] must match that of dense_shapes[j].
 *  If dense_shapes[j] has an undefined major dimension (variable strides dense
 *  feature), dense_defaults[j] must contain a single element:
 *  the padding element.
 *  * num_sparse: The number of sparse features to be parsed from the example. This
 *  must match the lengths of {@code sparse_keys} and {@code sparse_types}.
 *  * sparse_keys: A list of {@code num_sparse} strings.
 *  The keys expected in the Examples' features associated with sparse values.
 *  * dense_keys: The keys expected in the Examples' features associated with dense
 *  values.
 *  * sparse_types: A list of {@code num_sparse} types; the data types of data in each
 *  Feature given in sparse_keys.
 *  Currently the ParseSingleExample op supports DT_FLOAT (FloatList),
 *  DT_INT64 (Int64List), and DT_STRING (BytesList).
 *  * dense_shapes: The shapes of data in each Feature given in dense_keys.
 *  The length of this list must match the length of {@code dense_keys}.  The
 *  number of elements in the Feature corresponding to dense_key[j] must
 *  always equal dense_shapes[j].NumEntries().  If dense_shapes[j] ==
 *  (D0, D1, ..., DN) then the shape of output Tensor dense_values[j]
 *  will be (D0, D1, ..., DN): In the case dense_shapes[j] = (-1, D1,
 *  ..., DN), the shape of the output Tensor dense_values[j] will be (M,
 *  D1, .., DN), where M is the number of blocks of elements of length
 *  D1 * .... * DN, in the input.
 * 
 *  Returns:
 *  * {@code OutputList} sparse_indices
 *  * {@code OutputList} sparse_values
 *  * {@code OutputList} sparse_shapes
 *  * {@code OutputList} dense_values */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class ParseSingleExample extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ParseSingleExample(Pointer p) { super(p); }

  public ParseSingleExample(@Const @ByRef Scope scope, @ByVal Input serialized, @ByVal InputList dense_defaults, @Cast("tensorflow::int64") long num_sparse, @Cast("const tensorflow::gtl::ArraySlice<tensorflow::string>*") @ByRef StringVector sparse_keys,
                     @Cast("const tensorflow::gtl::ArraySlice<tensorflow::string>*") @ByRef StringVector dense_keys, @Cast("const tensorflow::DataTypeSlice*") @ByRef DataTypeVector sparse_types, @ArraySlice PartialTensorShape dense_shapes) { super((Pointer)null); allocate(scope, serialized, dense_defaults, num_sparse, sparse_keys, dense_keys, sparse_types, dense_shapes); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input serialized, @ByVal InputList dense_defaults, @Cast("tensorflow::int64") long num_sparse, @Cast("const tensorflow::gtl::ArraySlice<tensorflow::string>*") @ByRef StringVector sparse_keys,
                     @Cast("const tensorflow::gtl::ArraySlice<tensorflow::string>*") @ByRef StringVector dense_keys, @Cast("const tensorflow::DataTypeSlice*") @ByRef DataTypeVector sparse_types, @ArraySlice PartialTensorShape dense_shapes);

  public native @ByRef Operation operation(); public native ParseSingleExample operation(Operation setter);
  public native @ByRef @Cast("tensorflow::OutputList*") OutputVector sparse_indices(); public native ParseSingleExample sparse_indices(OutputVector setter);
  public native @ByRef @Cast("tensorflow::OutputList*") OutputVector sparse_values(); public native ParseSingleExample sparse_values(OutputVector setter);
  public native @ByRef @Cast("tensorflow::OutputList*") OutputVector sparse_shapes(); public native ParseSingleExample sparse_shapes(OutputVector setter);
  public native @ByRef @Cast("tensorflow::OutputList*") OutputVector dense_values(); public native ParseSingleExample dense_values(OutputVector setter);
}
