// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Looks up keys in a table, outputs the corresponding values.
 * 
 *  The tensor {@code keys} must of the same type as the keys of the table.
 *  The output {@code values} is of the type of the table values.
 * 
 *  The scalar {@code default_value} is the value output for keys not present in the
 *  table. It must also be of the same type as the table values.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * table_handle: Handle to the table.
 *  * keys: Any shape.  Keys to look up.
 * 
 *  Returns:
 *  * {@code Output}: Same shape as {@code keys}.  Values found in the table, or {@code default_values}
 *  for missing keys. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class LookupTableFind extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public LookupTableFind(Pointer p) { super(p); }

  public LookupTableFind(@Const @ByRef Scope scope, @ByVal Input table_handle, @ByVal Input keys, @ByVal Input default_value) { super((Pointer)null); allocate(scope, table_handle, keys, default_value); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input table_handle, @ByVal Input keys, @ByVal Input default_value);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public native @ByRef Operation operation(); public native LookupTableFind operation(Operation setter);
  public native @ByRef Output values(); public native LookupTableFind values(Output setter);
}
