// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Local Response Normalization.
 * 
 *  The 4-D {@code input} tensor is treated as a 3-D array of 1-D vectors (along the last
 *  dimension), and each vector is normalized independently.  Within a given vector,
 *  each component is divided by the weighted, squared sum of inputs within
 *  {@code depth_radius}.  In detail,
 * 
 *      sqr_sum[a, b, c, d] =
 *          sum(input[a, b, c, d - depth_radius : d + depth_radius + 1] ** 2)
 *      output = input / (bias + alpha * sqr_sum) ** beta
 * 
 *  For details, see [Krizhevsky et al., ImageNet classification with deep
 *  convolutional neural networks (NIPS 2012)](http://papers.nips.cc/paper/4824-imagenet-classification-with-deep-convolutional-neural-networks).
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * input: 4-D.
 * 
 *  Optional attributes (see {@code Attrs}):
 *  * depth_radius: 0-D.  Half-width of the 1-D normalization window.
 *  * bias: An offset (usually positive to avoid dividing by 0).
 *  * alpha: A scale factor, usually positive.
 *  * beta: An exponent.
 * 
 *  Returns:
 *  * {@code Output}: The output tensor. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class LRN extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public LRN(Pointer p) { super(p); }

  /** Optional attribute setters for LRN */
  public static class Attrs extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Attrs() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Attrs(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Attrs(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Attrs position(long position) {
          return (Attrs)super.position(position);
      }
      @Override public Attrs getPointer(long i) {
          return new Attrs((Pointer)this).offsetAddress(i);
      }
  
    /** 0-D.  Half-width of the 1-D normalization window.
     * 
     *  Defaults to 5 */
    
    ///
    public native @ByVal Attrs DepthRadius(@Cast("tensorflow::int64") long x);

    /** An offset (usually positive to avoid dividing by 0).
     * 
     *  Defaults to 1 */
    
    ///
    public native @ByVal Attrs Bias(float x);

    /** A scale factor, usually positive.
     * 
     *  Defaults to 1 */
    
    ///
    public native @ByVal Attrs Alpha(float x);

    /** An exponent.
     * 
     *  Defaults to 0.5 */
    public native @ByVal Attrs Beta(float x);

    public native @Cast("tensorflow::int64") long depth_radius_(); public native Attrs depth_radius_(long setter);
    public native float bias_(); public native Attrs bias_(float setter);
    public native float alpha_(); public native Attrs alpha_(float setter);
    public native float beta_(); public native Attrs beta_(float setter);
  }
  public LRN(@Const @ByRef Scope scope, @ByVal Input input) { super((Pointer)null); allocate(scope, input); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input);
  public LRN(@Const @ByRef Scope scope, @ByVal Input input, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, input, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @Const @ByRef Attrs attrs);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public static native @ByVal Attrs DepthRadius(@Cast("tensorflow::int64") long x);
  public static native @ByVal Attrs Bias(float x);
  public static native @ByVal Attrs Alpha(float x);
  public static native @ByVal Attrs Beta(float x);

  public native @ByRef Operation operation(); public native LRN operation(Operation setter);
  public native @ByRef Output output(); public native LRN output(Output setter);
}
