// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Computes the inverse permutation of a tensor.
 * 
 *  This operation computes the inverse of an index permutation. It takes a 1-D
 *  integer tensor {@code x}, which represents the indices of a zero-based array, and
 *  swaps each value with its index position. In other words, for an output tensor
 *  {@code y} and an input tensor {@code x}, this operation computes the following:
 * 
 *  {@code y[x[i]] = i for i in [0, 1, ..., len(x) - 1]}
 * 
 *  The values must include 0. There can be no duplicate values or negative values.
 * 
 *  For example:
 * 
 *  <pre>{@code
 *  # tensor `x` is [3, 4, 0, 2, 1]
 *  invert_permutation(x) ==> [2, 4, 3, 0, 1]
 *  }</pre>
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * x: 1-D.
 * 
 *  Returns:
 *  * {@code Output}: 1-D. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class InvertPermutation extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public InvertPermutation(Pointer p) { super(p); }

  public InvertPermutation(@Const @ByRef Scope scope, @ByVal Input x) { super((Pointer)null); allocate(scope, x); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input x);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public native @ByRef Operation operation(); public native InvertPermutation operation(Operation setter);
  public native @ByRef Output y(); public native InvertPermutation y(Output setter);
}
