// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/**     Updates specified rows with values in {@code v}.
 * 
 *      Computes {@code x[i, :] = v; return x}.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * x: A tensor of type {@code T}.
 *  * i: A vector. Indices into the left-most dimension of {@code x}.
 *  * v: A {@code Tensor} of type T. Same dimension sizes as x except the first dimension, which must be the same as i's size.
 * 
 *  Returns:
 *  * {@code Output}: A {@code Tensor} of type T. An alias of {@code x}. The content of {@code y} is undefined if there are duplicates in {@code i}. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class InplaceUpdate extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public InplaceUpdate(Pointer p) { super(p); }

  public InplaceUpdate(@Const @ByRef Scope scope, @ByVal Input x,
                @ByVal Input i, @ByVal Input v) { super((Pointer)null); allocate(scope, x, i, v); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input x,
                @ByVal Input i, @ByVal Input v);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public native @ByRef Operation operation(); public native InplaceUpdate operation(Operation setter);
  public native @ByRef Output y(); public native InplaceUpdate y(Output setter);
}
