// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Initializes a table from a text file.
 * 
 *  It inserts one key-value pair into the table for each line of the file.
 *  The key and value is extracted from the whole line content, elements from the
 *  split line based on {@code delimiter} or the line number (starting from zero).
 *  Where to extract the key and value from a line is specified by {@code key_index} and
 *  {@code value_index}.
 * 
 *  - A value of -1 means use the line number(starting from zero), expects {@code int64}.
 *  - A value of -2 means use the whole line content, expects {@code string}.
 *  - A value >= 0 means use the index (starting at zero) of the split line based
 *    on {@code delimiter}.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * table_handle: Handle to a table which will be initialized.
 *  * filename: Filename of a vocabulary text file.
 *  * key_index: Column index in a line to get the table {@code key} values from.
 *  * value_index: Column index that represents information of a line to get the table
 *  {@code value} values from.
 * 
 *  Optional attributes (see {@code Attrs}):
 *  * vocab_size: Number of elements of the file, use -1 if unknown.
 *  * delimiter: Delimiter to separate fields in a line.
 * 
 *  Returns:
 *  * the created {@code Operation} */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class InitializeTableFromTextFile extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public InitializeTableFromTextFile(Pointer p) { super(p); }

  /** Optional attribute setters for InitializeTableFromTextFile */
  public static class Attrs extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Attrs() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Attrs(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Attrs(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Attrs position(long position) {
          return (Attrs)super.position(position);
      }
      @Override public Attrs getPointer(long i) {
          return new Attrs((Pointer)this).offsetAddress(i);
      }
  
    /** Number of elements of the file, use -1 if unknown.
     * 
     *  Defaults to -1 */
    
    ///
    public native @ByVal Attrs VocabSize(@Cast("tensorflow::int64") long x);

    /** Delimiter to separate fields in a line.
     * 
     *  Defaults to "\t" */
    public native @ByVal Attrs Delimiter(@StringPiece BytePointer x);
    public native @ByVal Attrs Delimiter(@StringPiece String x);

    public native @Cast("tensorflow::int64") long vocab_size_(); public native Attrs vocab_size_(long setter);
    public native @StringPiece BytePointer delimiter_(); public native Attrs delimiter_(BytePointer setter);
  }
  public InitializeTableFromTextFile(@Const @ByRef Scope scope,
                              @ByVal Input table_handle,
                              @ByVal Input filename, @Cast("tensorflow::int64") long key_index,
                              @Cast("tensorflow::int64") long value_index) { super((Pointer)null); allocate(scope, table_handle, filename, key_index, value_index); }
  private native void allocate(@Const @ByRef Scope scope,
                              @ByVal Input table_handle,
                              @ByVal Input filename, @Cast("tensorflow::int64") long key_index,
                              @Cast("tensorflow::int64") long value_index);
  public InitializeTableFromTextFile(@Const @ByRef Scope scope,
                              @ByVal Input table_handle,
                              @ByVal Input filename, @Cast("tensorflow::int64") long key_index,
                              @Cast("tensorflow::int64") long value_index, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, table_handle, filename, key_index, value_index, attrs); }
  private native void allocate(@Const @ByRef Scope scope,
                              @ByVal Input table_handle,
                              @ByVal Input filename, @Cast("tensorflow::int64") long key_index,
                              @Cast("tensorflow::int64") long value_index, @Const @ByRef Attrs attrs);
  public native @ByVal @Name("operator tensorflow::Operation") Operation asOperation();

  public static native @ByVal Attrs VocabSize(@Cast("tensorflow::int64") long x);
  public static native @ByVal Attrs Delimiter(@StringPiece BytePointer x);
  public static native @ByVal Attrs Delimiter(@StringPiece String x);

  public native @ByRef Operation operation(); public native InitializeTableFromTextFile operation(Operation setter);
}
