// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Outputs a {@code Summary} protocol buffer with images.
 * 
 *  The summary has up to {@code max_images} summary values containing images. The
 *  images are built from {@code tensor} which must be 4-D with shape {@code [batch_size,
 *  height, width, channels]} and where {@code channels} can be:
 * 
 *  *  1: {@code tensor} is interpreted as Grayscale.
 *  *  3: {@code tensor} is interpreted as RGB.
 *  *  4: {@code tensor} is interpreted as RGBA.
 * 
 *  The images have the same number of channels as the input tensor. For float
 *  input, the values are normalized one image at a time to fit in the range
 *  {@code [0, 255]}.  {@code uint8} values are unchanged.  The op uses two different
 *  normalization algorithms:
 * 
 *  *  If the input values are all positive, they are rescaled so the largest one
 *     is 255.
 * 
 *  *  If any input value is negative, the values are shifted so input value 0.0
 *     is at 127.  They are then rescaled so that either the smallest value is 0,
 *     or the largest one is 255.
 * 
 *  The {@code tag} argument is a scalar {@code Tensor} of type {@code string}.  It is used to
 *  build the {@code tag} of the summary values:
 * 
 *  *  If {@code max_images} is 1, the summary value tag is '*tag* /image'.
 *  *  If {@code max_images} is greater than 1, the summary value tags are
 *     generated sequentially as '*tag* /image/0', '*tag* /image/1', etc.
 * 
 *  The {@code bad_color} argument is the color to use in the generated images for
 *  non-finite input values.  It is a {@code uint8} 1-D tensor of length {@code channels}.
 *  Each element must be in the range {@code [0, 255]} (It represents the value of a
 *  pixel in the output image).  Non-finite values in the input tensor are
 *  replaced by this tensor in the output image.  The default value is the color
 *  red.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * tag: Scalar. Used to build the {@code tag} attribute of the summary values.
 *  * tensor: 4-D of shape {@code [batch_size, height, width, channels]} where
 *  {@code channels} is 1, 3, or 4.
 * 
 *  Optional attributes (see {@code Attrs}):
 *  * max_images: Max number of batch elements to generate images for.
 *  * bad_color: Color to use for pixels with non-finite values.
 * 
 *  Returns:
 *  * {@code Output}: Scalar. Serialized {@code Summary} protocol buffer. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class ImageSummary extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ImageSummary(Pointer p) { super(p); }

  /** Optional attribute setters for ImageSummary */
  public static class Attrs extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Attrs() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Attrs(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Attrs(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Attrs position(long position) {
          return (Attrs)super.position(position);
      }
      @Override public Attrs getPointer(long i) {
          return new Attrs((Pointer)this).offsetAddress(i);
      }
  
    /** Max number of batch elements to generate images for.
     * 
     *  Defaults to 3 */
    
    ///
    public native @ByVal Attrs MaxImages(@Cast("tensorflow::int64") long x);

    /** Color to use for pixels with non-finite values.
     * 
     *  Defaults to Tensor<type: uint8 shape: [4] values: 255 0 0...> */
    public native @ByVal Attrs BadColor(@Const @ByRef TensorProto x);

    public native @Cast("tensorflow::int64") long max_images_(); public native Attrs max_images_(long setter);
    public native @ByRef TensorProto bad_color_(); public native Attrs bad_color_(TensorProto setter);
  }
  public ImageSummary(@Const @ByRef Scope scope, @ByVal Input tag,
               @ByVal Input tensor) { super((Pointer)null); allocate(scope, tag, tensor); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input tag,
               @ByVal Input tensor);
  public ImageSummary(@Const @ByRef Scope scope, @ByVal Input tag,
               @ByVal Input tensor, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, tag, tensor, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input tag,
               @ByVal Input tensor, @Const @ByRef Attrs attrs);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public static native @ByVal Attrs MaxImages(@Cast("tensorflow::int64") long x);
  public static native @ByVal Attrs BadColor(@Const @ByRef TensorProto x);

  public native @ByRef Operation operation(); public native ImageSummary operation(Operation setter);
  public native @ByRef Output summary(); public native ImageSummary summary(Output setter);
}
