// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Performs a resize and padding as a preprocess during a convolution.
 * 
 *  It's often possible to do spatial transformations more efficiently as part of
 *  the packing stage of a convolution, so this op allows for an optimized
 *  implementation where these stages are fused together. This prevents the need to
 *  write out the intermediate results as whole tensors, reducing memory pressure,
 *  and we can get some latency gains by merging the transformation calculations.
 *  The data_format attribute for Conv2D isn't supported by this op, and defaults to
 *  'NHWC' order.
 *  Internally this op uses a single per-graph scratch buffer, which means that it
 *  will block if multiple versions are being run in parallel. This is because this
 *  operator is primarily an optimization to minimize memory usage.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * input: 4-D with shape {@code [batch, in_height, in_width, in_channels]}.
 *  * size: A 1-D int32 Tensor of 2 elements: {@code new_height, new_width}.  The
 *  new size for the images.
 *  * paddings: A two-column matrix specifying the padding sizes. The number of
 *  rows must be the same as the rank of {@code input}.
 *  * filter: 4-D with shape
 *  {@code [filter_height, filter_width, in_channels, out_channels]}.
 *  * strides: 1-D of length 4.  The stride of the sliding window for each dimension
 *  of {@code input}. Must be in the same order as the dimension specified with format.
 *  * padding: The type of padding algorithm to use.
 * 
 *  Optional attributes (see {@code Attrs}):
 *  * resize_align_corners: If true, the centers of the 4 corner pixels of the input and output tensors are
 *  aligned, preserving the values at the corner pixels. Defaults to false.
 * 
 *  Returns:
 *  * {@code Output}: The output tensor. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class FusedResizeAndPadConv2D extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FusedResizeAndPadConv2D(Pointer p) { super(p); }

  /** Optional attribute setters for FusedResizeAndPadConv2D */
  public static class Attrs extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Attrs() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Attrs(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Attrs(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Attrs position(long position) {
          return (Attrs)super.position(position);
      }
      @Override public Attrs getPointer(long i) {
          return new Attrs((Pointer)this).offsetAddress(i);
      }
  
    /** If true, the centers of the 4 corner pixels of the input and output tensors are
     *  aligned, preserving the values at the corner pixels. Defaults to false.
     * 
     *  Defaults to false */
    public native @ByVal Attrs ResizeAlignCorners(@Cast("bool") boolean x);

    public native @Cast("bool") boolean resize_align_corners_(); public native Attrs resize_align_corners_(boolean setter);
  }
  public FusedResizeAndPadConv2D(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input size, @ByVal Input paddings, @ByVal Input filter, @StringPiece BytePointer mode,
                          @ArraySlice IntPointer strides, @StringPiece BytePointer padding) { super((Pointer)null); allocate(scope, input, size, paddings, filter, mode, strides, padding); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input size, @ByVal Input paddings, @ByVal Input filter, @StringPiece BytePointer mode,
                          @ArraySlice IntPointer strides, @StringPiece BytePointer padding);
  public FusedResizeAndPadConv2D(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input size, @ByVal Input paddings, @ByVal Input filter, @StringPiece String mode,
                          @ArraySlice IntBuffer strides, @StringPiece String padding) { super((Pointer)null); allocate(scope, input, size, paddings, filter, mode, strides, padding); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input size, @ByVal Input paddings, @ByVal Input filter, @StringPiece String mode,
                          @ArraySlice IntBuffer strides, @StringPiece String padding);
  public FusedResizeAndPadConv2D(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input size, @ByVal Input paddings, @ByVal Input filter, @StringPiece BytePointer mode,
                          @ArraySlice int[] strides, @StringPiece BytePointer padding) { super((Pointer)null); allocate(scope, input, size, paddings, filter, mode, strides, padding); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input size, @ByVal Input paddings, @ByVal Input filter, @StringPiece BytePointer mode,
                          @ArraySlice int[] strides, @StringPiece BytePointer padding);
  public FusedResizeAndPadConv2D(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input size, @ByVal Input paddings, @ByVal Input filter, @StringPiece String mode,
                          @ArraySlice IntPointer strides, @StringPiece String padding) { super((Pointer)null); allocate(scope, input, size, paddings, filter, mode, strides, padding); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input size, @ByVal Input paddings, @ByVal Input filter, @StringPiece String mode,
                          @ArraySlice IntPointer strides, @StringPiece String padding);
  public FusedResizeAndPadConv2D(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input size, @ByVal Input paddings, @ByVal Input filter, @StringPiece BytePointer mode,
                          @ArraySlice IntBuffer strides, @StringPiece BytePointer padding) { super((Pointer)null); allocate(scope, input, size, paddings, filter, mode, strides, padding); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input size, @ByVal Input paddings, @ByVal Input filter, @StringPiece BytePointer mode,
                          @ArraySlice IntBuffer strides, @StringPiece BytePointer padding);
  public FusedResizeAndPadConv2D(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input size, @ByVal Input paddings, @ByVal Input filter, @StringPiece String mode,
                          @ArraySlice int[] strides, @StringPiece String padding) { super((Pointer)null); allocate(scope, input, size, paddings, filter, mode, strides, padding); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input size, @ByVal Input paddings, @ByVal Input filter, @StringPiece String mode,
                          @ArraySlice int[] strides, @StringPiece String padding);
  public FusedResizeAndPadConv2D(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input size, @ByVal Input paddings, @ByVal Input filter, @StringPiece BytePointer mode,
                          @ArraySlice IntPointer strides, @StringPiece BytePointer padding, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, input, size, paddings, filter, mode, strides, padding, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input size, @ByVal Input paddings, @ByVal Input filter, @StringPiece BytePointer mode,
                          @ArraySlice IntPointer strides, @StringPiece BytePointer padding, @Const @ByRef Attrs attrs);
  public FusedResizeAndPadConv2D(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input size, @ByVal Input paddings, @ByVal Input filter, @StringPiece String mode,
                          @ArraySlice IntBuffer strides, @StringPiece String padding, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, input, size, paddings, filter, mode, strides, padding, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input size, @ByVal Input paddings, @ByVal Input filter, @StringPiece String mode,
                          @ArraySlice IntBuffer strides, @StringPiece String padding, @Const @ByRef Attrs attrs);
  public FusedResizeAndPadConv2D(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input size, @ByVal Input paddings, @ByVal Input filter, @StringPiece BytePointer mode,
                          @ArraySlice int[] strides, @StringPiece BytePointer padding, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, input, size, paddings, filter, mode, strides, padding, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input size, @ByVal Input paddings, @ByVal Input filter, @StringPiece BytePointer mode,
                          @ArraySlice int[] strides, @StringPiece BytePointer padding, @Const @ByRef Attrs attrs);
  public FusedResizeAndPadConv2D(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input size, @ByVal Input paddings, @ByVal Input filter, @StringPiece String mode,
                          @ArraySlice IntPointer strides, @StringPiece String padding, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, input, size, paddings, filter, mode, strides, padding, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input size, @ByVal Input paddings, @ByVal Input filter, @StringPiece String mode,
                          @ArraySlice IntPointer strides, @StringPiece String padding, @Const @ByRef Attrs attrs);
  public FusedResizeAndPadConv2D(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input size, @ByVal Input paddings, @ByVal Input filter, @StringPiece BytePointer mode,
                          @ArraySlice IntBuffer strides, @StringPiece BytePointer padding, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, input, size, paddings, filter, mode, strides, padding, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input size, @ByVal Input paddings, @ByVal Input filter, @StringPiece BytePointer mode,
                          @ArraySlice IntBuffer strides, @StringPiece BytePointer padding, @Const @ByRef Attrs attrs);
  public FusedResizeAndPadConv2D(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input size, @ByVal Input paddings, @ByVal Input filter, @StringPiece String mode,
                          @ArraySlice int[] strides, @StringPiece String padding, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, input, size, paddings, filter, mode, strides, padding, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input size, @ByVal Input paddings, @ByVal Input filter, @StringPiece String mode,
                          @ArraySlice int[] strides, @StringPiece String padding, @Const @ByRef Attrs attrs);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public static native @ByVal Attrs ResizeAlignCorners(@Cast("bool") boolean x);

  public native @ByRef Operation operation(); public native FusedResizeAndPadConv2D operation(Operation setter);
  public native @ByRef Output output(); public native FusedResizeAndPadConv2D output(Output setter);
}
