// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


// FunctionDefHelper::Create is a convenient helper to construct a
// FunctionDef proto.
// E.g.,
//   FunctionDef my_func = FunctionDefHelper::Create(
//     "my_func_name",
//     {"x:T", "y:T" /* one string per argument */},
//     {"z:T" /* one string per return value */},
//     {"T: {float, double}" /* one string per attribute  */},
//     {
//        {{"o"}, "Mul", {"x", "y"}, {{"T", "$T"}}}
//        /* one entry per function node */
//     },
//     /* Mapping between function returns and function node outputs. */
//     {{"z", "o:z"}});
//
// For the old Function::Node approach, use FunctionDefHelper::Define()
// E.g.,
//   FunctionDef my_func = FunctionDefHelper::Define(
//     "my_func_name",
//     {"x:T", "y:T" /* one string per argument */},
//     {"z:T" /* one string per return value */},
//     {"T: {float, double}" /* one string per attribute  */},
//     {
//        {{"z"}, "Mul", {"x", "y"}, {{"T", "$T"}}}
//        /* one entry per function node */
//     });
@Namespace("tensorflow") @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class FunctionDefHelper extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public FunctionDefHelper() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public FunctionDefHelper(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FunctionDefHelper(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public FunctionDefHelper position(long position) {
        return (FunctionDefHelper)super.position(position);
    }
    @Override public FunctionDefHelper getPointer(long i) {
        return new FunctionDefHelper((Pointer)this).offsetAddress(i);
    }

  // AttrValueWrapper has copy constructors for the type T so that
  // it's easy to construct a simple AttrValue proto.
  //
  // If T is a string type (const char*, string, or StringPiece), and
  // it starts with "$", we construct a AttrValue of "placeholder".
  //
  // E.g.,
  //   std::<string, AttrValueWrapper> x = {"T", "$T"}
  // is a named attr value placeholder.
  @NoOffset public static class AttrValueWrapper extends Pointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public AttrValueWrapper(Pointer p) { super(p); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public AttrValueWrapper(long size) { super((Pointer)null); allocateArray(size); }
      private native void allocateArray(long size);
      @Override public AttrValueWrapper position(long position) {
          return (AttrValueWrapper)super.position(position);
      }
      @Override public AttrValueWrapper getPointer(long i) {
          return new AttrValueWrapper((Pointer)this).offsetAddress(i);
      }
  
    public native @ByRef AttrValue proto(); public native AttrValueWrapper proto(AttrValue setter);

    public AttrValueWrapper() { super((Pointer)null); allocate(); }
    private native void allocate();
  }

  // Constructs an AttrValue.func given the "name" and "attrs".
  public static native @ByVal AttrValueWrapper FunctionRef(
        @StdString BytePointer name,
        @ByVal @Cast("tensorflow::gtl::ArraySlice<std::pair<tensorflow::string,tensorflow::FunctionDefHelper::AttrValueWrapper> >*") StringAttrPairVector attrs);
  public static native @ByVal AttrValueWrapper FunctionRef(
        @StdString String name,
        @ByVal @Cast("tensorflow::gtl::ArraySlice<std::pair<tensorflow::string,tensorflow::FunctionDefHelper::AttrValueWrapper> >*") StringAttrPairVector attrs);
  public static native @ByVal AttrValueWrapper FunctionRef(@StdString BytePointer name);
  public static native @ByVal AttrValueWrapper FunctionRef(@StdString String name);

  // Node is used to construct FunctionDef.Node using initialization
  // lists. E.g.,
  //  Node n = {{"z"}, "Mul", {"x", "y"}, {{"T", "$T"}}};  // z = x * y
  public static class Node extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Node() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Node(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Node(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Node position(long position) {
          return (Node)super.position(position);
      }
      @Override public Node getPointer(long i) {
          return new Node((Pointer)this).offsetAddress(i);
      }
  
    // When constructing a NodeDef, the first entry in ret is used as
    // the node name, the remaining values are ignored.
    public native @ByRef StringVector ret(); public native Node ret(StringVector setter);
    public native @StdString BytePointer op(); public native Node op(BytePointer setter);
    public native @ByRef StringVector arg(); public native Node arg(StringVector setter);
    public native @ByRef @Cast("std::vector<std::pair<tensorflow::string,tensorflow::FunctionDefHelper::AttrValueWrapper> >*") StringAttrPairVector attr(); public native Node attr(StringAttrPairVector setter);
    public native @ByRef StringVector dep(); public native Node dep(StringVector setter);
    public native @StdString BytePointer device(); public native Node device(BytePointer setter);

    public native @ByVal NodeDef ToNodeDef();
  }

  // Creates a FunctionDef from the given parameters. Node inputs must use
  // function encoding (node_name:output_name[:output_index]).
  // - `ret_def` holds a mapping from the function output names from `out_def`
  //   to the node outputs from `node_def`.
  // - `control_ret_def` holds a mapping from the function control
  //   output names to the nodes from `node_def`.
  public static native @ByVal FunctionDef Create(
        @StdString BytePointer function_name, @ByVal @Cast("tensorflow::gtl::ArraySlice<tensorflow::string>*") StringVector in_def,
        @ByVal @Cast("tensorflow::gtl::ArraySlice<tensorflow::string>*") StringVector out_def, @ByVal @Cast("tensorflow::gtl::ArraySlice<tensorflow::string>*") StringVector attr_def,
        @ArraySlice Node node_def,
        @ByVal @Cast("tensorflow::gtl::ArraySlice<std::pair<tensorflow::string,tensorflow::string> >*") StringStringPairVector ret_def,
        @ByVal @Cast("tensorflow::gtl::ArraySlice<std::pair<tensorflow::string,tensorflow::string> >*") StringStringPairVector control_ret_def);
  public static native @ByVal FunctionDef Create(
        @StdString String function_name, @ByVal @Cast("tensorflow::gtl::ArraySlice<tensorflow::string>*") StringVector in_def,
        @ByVal @Cast("tensorflow::gtl::ArraySlice<tensorflow::string>*") StringVector out_def, @ByVal @Cast("tensorflow::gtl::ArraySlice<tensorflow::string>*") StringVector attr_def,
        @ArraySlice Node node_def,
        @ByVal @Cast("tensorflow::gtl::ArraySlice<std::pair<tensorflow::string,tensorflow::string> >*") StringStringPairVector ret_def,
        @ByVal @Cast("tensorflow::gtl::ArraySlice<std::pair<tensorflow::string,tensorflow::string> >*") StringStringPairVector control_ret_def);

  // Creates a FunctionDef from the given parameters. Node inputs must use
  // function encoding (node_name:output_name[:output_index]).
  // - `ret_def` holds a mapping from the function output names from `out_def`
  //   to the node outputs from `node_def`.
  public static native @ByVal FunctionDef Create(@StdString BytePointer function_name,
                              @ByVal @Cast("tensorflow::gtl::ArraySlice<tensorflow::string>*") StringVector in_def,
                              @ByVal @Cast("tensorflow::gtl::ArraySlice<tensorflow::string>*") StringVector out_def,
                              @ByVal @Cast("tensorflow::gtl::ArraySlice<tensorflow::string>*") StringVector attr_def,
                              @ArraySlice Node node_def,
                              @ByVal @Cast("tensorflow::gtl::ArraySlice<std::pair<tensorflow::string,tensorflow::string> >*") StringStringPairVector ret_def);
  public static native @ByVal FunctionDef Create(@StdString String function_name,
                              @ByVal @Cast("tensorflow::gtl::ArraySlice<tensorflow::string>*") StringVector in_def,
                              @ByVal @Cast("tensorflow::gtl::ArraySlice<tensorflow::string>*") StringVector out_def,
                              @ByVal @Cast("tensorflow::gtl::ArraySlice<tensorflow::string>*") StringVector attr_def,
                              @ArraySlice Node node_def,
                              @ByVal @Cast("tensorflow::gtl::ArraySlice<std::pair<tensorflow::string,tensorflow::string> >*") StringStringPairVector ret_def);

  // TODO(josh11b): Get rid of these and transition to the one above.
  public static native @ByVal FunctionDef Define(@StdString BytePointer function_name,
                              @ByVal @Cast("tensorflow::gtl::ArraySlice<tensorflow::string>*") StringVector arg_def,
                              @ByVal @Cast("tensorflow::gtl::ArraySlice<tensorflow::string>*") StringVector ret_def,
                              @ByVal @Cast("tensorflow::gtl::ArraySlice<tensorflow::string>*") StringVector attr_def,
                              @ArraySlice Node node_def);
  public static native @ByVal FunctionDef Define(@StdString String function_name,
                              @ByVal @Cast("tensorflow::gtl::ArraySlice<tensorflow::string>*") StringVector arg_def,
                              @ByVal @Cast("tensorflow::gtl::ArraySlice<tensorflow::string>*") StringVector ret_def,
                              @ByVal @Cast("tensorflow::gtl::ArraySlice<tensorflow::string>*") StringVector attr_def,
                              @ArraySlice Node node_def);

  // Defines an anonymous function. I.e., its name is not relevant.
  public static native @ByVal FunctionDef Define(@ByVal @Cast("tensorflow::gtl::ArraySlice<tensorflow::string>*") StringVector arg_def,
                              @ByVal @Cast("tensorflow::gtl::ArraySlice<tensorflow::string>*") StringVector ret_def,
                              @ByVal @Cast("tensorflow::gtl::ArraySlice<tensorflow::string>*") StringVector attr_def,
                              @ArraySlice Node node_def);

  // Helpers to construct a constant scalar.
}
