// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Compute gradients for a FakeQuantWithMinMaxArgs operation.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * gradients: Backpropagated gradients above the FakeQuantWithMinMaxArgs operation.
 *  * inputs: Values passed as inputs to the FakeQuantWithMinMaxArgs operation.
 * 
 *  Returns:
 *  * {@code Output}: Backpropagated gradients below the FakeQuantWithMinMaxArgs operation:
 *  {@code gradients * (inputs >= min && inputs <= max)}. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class FakeQuantWithMinMaxArgsGradient extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FakeQuantWithMinMaxArgsGradient(Pointer p) { super(p); }

  /** Optional attribute setters for FakeQuantWithMinMaxArgsGradient */
  public static class Attrs extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Attrs() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Attrs(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Attrs(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Attrs position(long position) {
          return (Attrs)super.position(position);
      }
      @Override public Attrs getPointer(long i) {
          return new Attrs((Pointer)this).offsetAddress(i);
      }
  
    /** Defaults to -6 */
    public native @ByVal Attrs Min(float x);

    /** Defaults to 6 */
    public native @ByVal Attrs Max(float x);

    /** Defaults to 8 */
    public native @ByVal Attrs NumBits(@Cast("tensorflow::int64") long x);

    /** Defaults to false */
    public native @ByVal Attrs NarrowRange(@Cast("bool") boolean x);

    public native float min_(); public native Attrs min_(float setter);
    public native float max_(); public native Attrs max_(float setter);
    public native @Cast("tensorflow::int64") long num_bits_(); public native Attrs num_bits_(long setter);
    public native @Cast("bool") boolean narrow_range_(); public native Attrs narrow_range_(boolean setter);
  }
  public FakeQuantWithMinMaxArgsGradient(@Const @ByRef Scope scope,
                                  @ByVal Input gradients,
                                  @ByVal Input inputs) { super((Pointer)null); allocate(scope, gradients, inputs); }
  private native void allocate(@Const @ByRef Scope scope,
                                  @ByVal Input gradients,
                                  @ByVal Input inputs);
  public FakeQuantWithMinMaxArgsGradient(@Const @ByRef Scope scope,
                                  @ByVal Input gradients,
                                  @ByVal Input inputs, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, gradients, inputs, attrs); }
  private native void allocate(@Const @ByRef Scope scope,
                                  @ByVal Input gradients,
                                  @ByVal Input inputs, @Const @ByRef Attrs attrs);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public static native @ByVal Attrs Min(float x);
  public static native @ByVal Attrs Max(float x);
  public static native @ByVal Attrs NumBits(@Cast("tensorflow::int64") long x);
  public static native @ByVal Attrs NarrowRange(@Cast("bool") boolean x);

  public native @ByRef Operation operation(); public native FakeQuantWithMinMaxArgsGradient operation(Operation setter);
  public native @ByRef Output backprops(); public native FakeQuantWithMinMaxArgsGradient backprops(Output setter);
}
