// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Ensures that the tensor's shape matches the expected shape.
 * 
 *  Raises an error if the input tensor's shape does not match the specified shape.
 *  Returns the input tensor otherwise.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * input: A tensor, whose shape is to be validated.
 *  * shape: The expected (possibly partially specified) shape of the input tensor.
 * 
 *  Returns:
 *  * {@code Output}: A tensor with the same shape and contents as the input tensor or value. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class EnsureShape extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public EnsureShape(Pointer p) { super(p); }

  public EnsureShape(@Const @ByRef Scope scope, @ByVal Input input,
              @ByVal PartialTensorShape shape) { super((Pointer)null); allocate(scope, input, shape); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input,
              @ByVal PartialTensorShape shape);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public native @ByRef Operation operation(); public native EnsureShape operation(Operation setter);
  public native @ByRef Output output(); public native EnsureShape output(Output setter);
}
