// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Computes the (possibly normalized) Levenshtein Edit Distance.
 * 
 *  The inputs are variable-length sequences provided by SparseTensors
 *    (hypothesis_indices, hypothesis_values, hypothesis_shape)
 *  and
 *    (truth_indices, truth_values, truth_shape).
 * 
 *  The inputs are:
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * hypothesis_indices: The indices of the hypothesis list SparseTensor.
 *  This is an N x R int64 matrix.
 *  * hypothesis_values: The values of the hypothesis list SparseTensor.
 *  This is an N-length vector.
 *  * hypothesis_shape: The shape of the hypothesis list SparseTensor.
 *  This is an R-length vector.
 *  * truth_indices: The indices of the truth list SparseTensor.
 *  This is an M x R int64 matrix.
 *  * truth_values: The values of the truth list SparseTensor.
 *  This is an M-length vector.
 *  * truth_shape: truth indices, vector.
 * 
 *  Optional attributes (see {@code Attrs}):
 *  * normalize: boolean (if true, edit distances are normalized by length of truth).
 * 
 *  The output is:
 * 
 *  Returns:
 *  * {@code Output}: A dense float tensor with rank R - 1.
 * 
 *  For the example input:
 * 
 *      // hypothesis represents a 2x1 matrix with variable-length values:
 *      //   (0,0) = ["a"]
 *      //   (1,0) = ["b"]
 *      hypothesis_indices = [[0, 0, 0],
 *                            [1, 0, 0]]
 *      hypothesis_values = ["a", "b"]
 *      hypothesis_shape = [2, 1, 1]
 * 
 *      // truth represents a 2x2 matrix with variable-length values:
 *      //   (0,0) = []
 *      //   (0,1) = ["a"]
 *      //   (1,0) = ["b", "c"]
 *      //   (1,1) = ["a"]
 *      truth_indices = [[0, 1, 0],
 *                       [1, 0, 0],
 *                       [1, 0, 1],
 *                       [1, 1, 0]]
 *      truth_values = ["a", "b", "c", "a"]
 *      truth_shape = [2, 2, 2]
 *      normalize = true
 * 
 *  The output will be:
 * 
 *      // output is a 2x2 matrix with edit distances normalized by truth lengths.
 *      output = [[inf, 1.0],  // (0,0): no truth, (0,1): no hypothesis
 *                [0.5, 1.0]]  // (1,0): addition, (1,1): no hypothesis */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class EditDistance extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public EditDistance(Pointer p) { super(p); }

  /** Optional attribute setters for EditDistance */
  public static class Attrs extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Attrs() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Attrs(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Attrs(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Attrs position(long position) {
          return (Attrs)super.position(position);
      }
      @Override public Attrs getPointer(long i) {
          return new Attrs((Pointer)this).offsetAddress(i);
      }
  
    /** boolean (if true, edit distances are normalized by length of truth).
     * 
     *  The output is:
     * 
     *  Defaults to true */
    public native @ByVal Attrs Normalize(@Cast("bool") boolean x);

    public native @Cast("bool") boolean normalize_(); public native Attrs normalize_(boolean setter);
  }
  public EditDistance(@Const @ByRef Scope scope, @ByVal Input hypothesis_indices, @ByVal Input hypothesis_values,
               @ByVal Input hypothesis_shape, @ByVal Input truth_indices, @ByVal Input truth_values,
               @ByVal Input truth_shape) { super((Pointer)null); allocate(scope, hypothesis_indices, hypothesis_values, hypothesis_shape, truth_indices, truth_values, truth_shape); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input hypothesis_indices, @ByVal Input hypothesis_values,
               @ByVal Input hypothesis_shape, @ByVal Input truth_indices, @ByVal Input truth_values,
               @ByVal Input truth_shape);
  public EditDistance(@Const @ByRef Scope scope, @ByVal Input hypothesis_indices, @ByVal Input hypothesis_values,
               @ByVal Input hypothesis_shape, @ByVal Input truth_indices, @ByVal Input truth_values,
               @ByVal Input truth_shape, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, hypothesis_indices, hypothesis_values, hypothesis_shape, truth_indices, truth_values, truth_shape, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input hypothesis_indices, @ByVal Input hypothesis_values,
               @ByVal Input hypothesis_shape, @ByVal Input truth_indices, @ByVal Input truth_values,
               @ByVal Input truth_shape, @Const @ByRef Attrs attrs);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public static native @ByVal Attrs Normalize(@Cast("bool") boolean x);

  public native @ByRef Operation operation(); public native EditDistance operation(Operation setter);
  public native @ByRef Output output(); public native EditDistance output(Output setter);
}
