// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Computes a 2-D depthwise convolution given 4-D {@code input} and {@code filter} tensors.
 * 
 *  Given an input tensor of shape {@code [batch, in_height, in_width, in_channels]}
 *  and a filter / kernel tensor of shape
 *  {@code [filter_height, filter_width, in_channels, channel_multiplier]}, containing
 *  {@code in_channels} convolutional filters of depth 1, {@code depthwise_conv2d} applies
 *  a different filter to each input channel (expanding from 1 channel to
 *  {@code channel_multiplier} channels for each), then concatenates the results
 *  together. Thus, the output has {@code in_channels * channel_multiplier} channels.
 * 
 *  <pre>{@code
 *  for k in 0..in_channels-1
 *    for q in 0..channel_multiplier-1
 *      output[b, i, j, k * channel_multiplier + q] =
 *        sum_{di, dj} input[b, strides[1] * i + di, strides[2] * j + dj, k] *
 *                          filter[di, dj, k, q]
 *  }</pre>
 * 
 *  Must have {@code strides[0] = strides[3] = 1}.  For the most common case of the same
 *  horizontal and vertices strides, {@code strides = [1, stride, stride, 1]}.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * strides: 1-D of length 4.  The stride of the sliding window for each dimension
 *  of {@code input}.
 *  * padding: The type of padding algorithm to use.
 * 
 *  Optional attributes (see {@code Attrs}):
 *  * data_format: Specify the data format of the input and output data. With the
 *  default format "NHWC", the data is stored in the order of:
 *      [batch, height, width, channels].
 *  Alternatively, the format could be "NCHW", the data storage order of:
 *      [batch, channels, height, width].
 *  * dilations: 1-D tensor of length 4.  The dilation factor for each dimension of
 *  {@code input}. If set to k > 1, there will be k-1 skipped cells between each filter
 *  element on that dimension. The dimension order is determined by the value of
 *  {@code data_format}, see above for details. Dilations in the batch and depth
 *  dimensions must be 1.
 * 
 *  Returns:
 *  * {@code Output}: The output tensor. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class DepthwiseConv2dNative extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DepthwiseConv2dNative(Pointer p) { super(p); }

  /** Optional attribute setters for DepthwiseConv2dNative */
  public static class Attrs extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Attrs() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Attrs(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Attrs(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Attrs position(long position) {
          return (Attrs)super.position(position);
      }
      @Override public Attrs getPointer(long i) {
          return new Attrs((Pointer)this).offsetAddress(i);
      }
  
    /** Specify the data format of the input and output data. With the
     *  default format "NHWC", the data is stored in the order of:
     *      [batch, height, width, channels].
     *  Alternatively, the format could be "NCHW", the data storage order of:
     *      [batch, channels, height, width].
     * 
     *  Defaults to "NHWC" */
    
    ///
    public native @ByVal Attrs DataFormat(@StringPiece BytePointer x);
    public native @ByVal Attrs DataFormat(@StringPiece String x);

    /** 1-D tensor of length 4.  The dilation factor for each dimension of
     *  {@code input}. If set to k > 1, there will be k-1 skipped cells between each filter
     *  element on that dimension. The dimension order is determined by the value of
     *  {@code data_format}, see above for details. Dilations in the batch and depth
     *  dimensions must be 1.
     * 
     *  Defaults to [1, 1, 1, 1] */
    public native @ByVal Attrs Dilations(@ArraySlice IntPointer x);
    public native @ByVal Attrs Dilations(@ArraySlice IntBuffer x);
    public native @ByVal Attrs Dilations(@ArraySlice int... x);

    public native @StringPiece BytePointer data_format_(); public native Attrs data_format_(BytePointer setter);
    public native @ArraySlice IntPointer dilations_(); public native Attrs dilations_(IntPointer setter);
  }
  public DepthwiseConv2dNative(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input filter, @ArraySlice IntPointer strides, @StringPiece BytePointer padding) { super((Pointer)null); allocate(scope, input, filter, strides, padding); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input filter, @ArraySlice IntPointer strides, @StringPiece BytePointer padding);
  public DepthwiseConv2dNative(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input filter, @ArraySlice IntBuffer strides, @StringPiece String padding) { super((Pointer)null); allocate(scope, input, filter, strides, padding); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input filter, @ArraySlice IntBuffer strides, @StringPiece String padding);
  public DepthwiseConv2dNative(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input filter, @ArraySlice int[] strides, @StringPiece BytePointer padding) { super((Pointer)null); allocate(scope, input, filter, strides, padding); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input filter, @ArraySlice int[] strides, @StringPiece BytePointer padding);
  public DepthwiseConv2dNative(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input filter, @ArraySlice IntPointer strides, @StringPiece String padding) { super((Pointer)null); allocate(scope, input, filter, strides, padding); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input filter, @ArraySlice IntPointer strides, @StringPiece String padding);
  public DepthwiseConv2dNative(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input filter, @ArraySlice IntBuffer strides, @StringPiece BytePointer padding) { super((Pointer)null); allocate(scope, input, filter, strides, padding); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input filter, @ArraySlice IntBuffer strides, @StringPiece BytePointer padding);
  public DepthwiseConv2dNative(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input filter, @ArraySlice int[] strides, @StringPiece String padding) { super((Pointer)null); allocate(scope, input, filter, strides, padding); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input filter, @ArraySlice int[] strides, @StringPiece String padding);
  public DepthwiseConv2dNative(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input filter, @ArraySlice IntPointer strides, @StringPiece BytePointer padding, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, input, filter, strides, padding, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input filter, @ArraySlice IntPointer strides, @StringPiece BytePointer padding, @Const @ByRef Attrs attrs);
  public DepthwiseConv2dNative(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input filter, @ArraySlice IntBuffer strides, @StringPiece String padding, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, input, filter, strides, padding, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input filter, @ArraySlice IntBuffer strides, @StringPiece String padding, @Const @ByRef Attrs attrs);
  public DepthwiseConv2dNative(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input filter, @ArraySlice int[] strides, @StringPiece BytePointer padding, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, input, filter, strides, padding, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input filter, @ArraySlice int[] strides, @StringPiece BytePointer padding, @Const @ByRef Attrs attrs);
  public DepthwiseConv2dNative(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input filter, @ArraySlice IntPointer strides, @StringPiece String padding, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, input, filter, strides, padding, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input filter, @ArraySlice IntPointer strides, @StringPiece String padding, @Const @ByRef Attrs attrs);
  public DepthwiseConv2dNative(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input filter, @ArraySlice IntBuffer strides, @StringPiece BytePointer padding, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, input, filter, strides, padding, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input filter, @ArraySlice IntBuffer strides, @StringPiece BytePointer padding, @Const @ByRef Attrs attrs);
  public DepthwiseConv2dNative(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input filter, @ArraySlice int[] strides, @StringPiece String padding, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, input, filter, strides, padding, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input input, @ByVal Input filter, @ArraySlice int[] strides, @StringPiece String padding, @Const @ByRef Attrs attrs);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public static native @ByVal Attrs DataFormat(@StringPiece BytePointer x);
  public static native @ByVal Attrs DataFormat(@StringPiece String x);
  public static native @ByVal Attrs Dilations(@ArraySlice IntPointer x);
  public static native @ByVal Attrs Dilations(@ArraySlice IntBuffer x);
  public static native @ByVal Attrs Dilations(@ArraySlice int... x);

  public native @ByRef Operation operation(); public native DepthwiseConv2dNative operation(Operation setter);
  public native @ByRef Output output(); public native DepthwiseConv2dNative output(Output setter);
}
