// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Decode a PNG-encoded image to a uint8 or uint16 tensor.
 * 
 *  The attr {@code channels} indicates the desired number of color channels for the
 *  decoded image.
 * 
 *  Accepted values are:
 * 
 *  *   0: Use the number of channels in the PNG-encoded image.
 *  *   1: output a grayscale image.
 *  *   3: output an RGB image.
 *  *   4: output an RGBA image.
 * 
 *  If needed, the PNG-encoded image is transformed to match the requested number
 *  of color channels.
 * 
 *  This op also supports decoding JPEGs and non-animated GIFs since the interface
 *  is the same, though it is cleaner to use {@code tf.image.decode_image}.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * contents: 0-D.  The PNG-encoded image.
 * 
 *  Optional attributes (see {@code Attrs}):
 *  * channels: Number of color channels for the decoded image.
 * 
 *  Returns:
 *  * {@code Output}: 3-D with shape {@code [height, width, channels]}. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class DecodePng extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DecodePng(Pointer p) { super(p); }

  /** Optional attribute setters for DecodePng */
  public static class Attrs extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Attrs() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Attrs(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Attrs(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Attrs position(long position) {
          return (Attrs)super.position(position);
      }
      @Override public Attrs getPointer(long i) {
          return new Attrs((Pointer)this).offsetAddress(i);
      }
  
    /** Number of color channels for the decoded image.
     * 
     *  Defaults to 0 */
    public native @ByVal Attrs Channels(@Cast("tensorflow::int64") long x);

    /** Defaults to DT_UINT8 */
    public native @ByVal Attrs Dtype(@Cast("tensorflow::DataType") int x);

    public native @Cast("tensorflow::int64") long channels_(); public native Attrs channels_(long setter);
    public native @Cast("tensorflow::DataType") int dtype_(); public native Attrs dtype_(int setter);
  }
  public DecodePng(@Const @ByRef Scope scope, @ByVal Input contents) { super((Pointer)null); allocate(scope, contents); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input contents);
  public DecodePng(@Const @ByRef Scope scope, @ByVal Input contents, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, contents, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input contents, @Const @ByRef Attrs attrs);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public static native @ByVal Attrs Channels(@Cast("tensorflow::int64") long x);
  public static native @ByVal Attrs Dtype(@Cast("tensorflow::DataType") int x);

  public native @ByRef Operation operation(); public native DecodePng operation(Operation setter);
  public native @ByRef Output image(); public native DecodePng image(Output setter);
}
