// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.tensorflow;

import org.bytedeco.tensorflow.Allocator;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.tensorflow.global.tensorflow.*;


/** Extracts crops from the input image tensor and resizes them.
 * 
 *  Extracts crops from the input image tensor and resizes them using bilinear
 *  sampling or nearest neighbor sampling (possibly with aspect ratio change) to a
 *  common output size specified by {@code crop_size}. This is more general than the
 *  {@code crop_to_bounding_box} op which extracts a fixed size slice from the input image
 *  and does not allow resizing or aspect ratio change.
 * 
 *  Returns a tensor with {@code crops} from the input {@code image} at positions defined at the
 *  bounding box locations in {@code boxes}. The cropped boxes are all resized (with
 *  bilinear or nearest neighbor interpolation) to a fixed
 *  {@code size = [crop_height, crop_width]}. The result is a 4-D tensor
 *  {@code [num_boxes, crop_height, crop_width, depth]}. The resizing is corner aligned.
 *  In particular, if {@code boxes = [[0, 0, 1, 1]]}, the method will give identical
 *  results to using {@code tf.image.resize_bilinear()} or
 *  {@code tf.image.resize_nearest_neighbor()}(depends on the {@code method} argument) with
 *  {@code align_corners=True}.
 * 
 *  Arguments:
 *  * scope: A Scope object
 *  * image: A 4-D tensor of shape {@code [batch, image_height, image_width, depth]}.
 *  Both {@code image_height} and {@code image_width} need to be positive.
 *  * boxes: A 2-D tensor of shape {@code [num_boxes, 4]}. The {@code i}-th row of the tensor
 *  specifies the coordinates of a box in the {@code box_ind[i]} image and is specified
 *  in normalized coordinates {@code [y1, x1, y2, x2]}. A normalized coordinate value of
 *  {@code y} is mapped to the image coordinate at {@code y * (image_height - 1)}, so as the
 *  {@code [0, 1]} interval of normalized image height is mapped to
 *  {@code [0, image_height - 1]} in image height coordinates. We do allow {@code y1} > {@code y2}, in
 *  which case the sampled crop is an up-down flipped version of the original
 *  image. The width dimension is treated similarly. Normalized coordinates
 *  outside the {@code [0, 1]} range are allowed, in which case we use
 *  {@code extrapolation_value} to extrapolate the input image values.
 *  * box_ind: A 1-D tensor of shape {@code [num_boxes]} with int32 values in {@code [0, batch)}.
 *  The value of {@code box_ind[i]} specifies the image that the {@code i}-th box refers to.
 *  * crop_size: A 1-D tensor of 2 elements, {@code size = [crop_height, crop_width]}. All
 *  cropped image patches are resized to this size. The aspect ratio of the image
 *  content is not preserved. Both {@code crop_height} and {@code crop_width} need to be
 *  positive.
 * 
 *  Optional attributes (see {@code Attrs}):
 *  * method: A string specifying the sampling method for resizing. It can be either
 *  {@code "bilinear"} or {@code "nearest"} and default to {@code "bilinear"}. Currently two sampling
 *  methods are supported: Bilinear and Nearest Neighbor.
 *  * extrapolation_value: Value used for extrapolation, when applicable.
 * 
 *  Returns:
 *  * {@code Output}: A 4-D tensor of shape {@code [num_boxes, crop_height, crop_width, depth]}. */
@Namespace("tensorflow::ops") @NoOffset @Properties(inherit = org.bytedeco.tensorflow.presets.tensorflow.class)
public class CropAndResize extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CropAndResize(Pointer p) { super(p); }

  /** Optional attribute setters for CropAndResize */
  public static class Attrs extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Attrs() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Attrs(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Attrs(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Attrs position(long position) {
          return (Attrs)super.position(position);
      }
      @Override public Attrs getPointer(long i) {
          return new Attrs((Pointer)this).offsetAddress(i);
      }
  
    /** A string specifying the sampling method for resizing. It can be either
     *  {@code "bilinear"} or {@code "nearest"} and default to {@code "bilinear"}. Currently two sampling
     *  methods are supported: Bilinear and Nearest Neighbor.
     * 
     *  Defaults to "bilinear" */
    
    ///
    public native @ByVal Attrs Method(@StringPiece BytePointer x);
    public native @ByVal Attrs Method(@StringPiece String x);

    /** Value used for extrapolation, when applicable.
     * 
     *  Defaults to 0 */
    public native @ByVal Attrs ExtrapolationValue(float x);

    public native @StringPiece BytePointer method_(); public native Attrs method_(BytePointer setter);
    public native float extrapolation_value_(); public native Attrs extrapolation_value_(float setter);
  }
  public CropAndResize(@Const @ByRef Scope scope, @ByVal Input image,
                @ByVal Input boxes, @ByVal Input box_ind,
                @ByVal Input crop_size) { super((Pointer)null); allocate(scope, image, boxes, box_ind, crop_size); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input image,
                @ByVal Input boxes, @ByVal Input box_ind,
                @ByVal Input crop_size);
  public CropAndResize(@Const @ByRef Scope scope, @ByVal Input image,
                @ByVal Input boxes, @ByVal Input box_ind,
                @ByVal Input crop_size, @Const @ByRef Attrs attrs) { super((Pointer)null); allocate(scope, image, boxes, box_ind, crop_size, attrs); }
  private native void allocate(@Const @ByRef Scope scope, @ByVal Input image,
                @ByVal Input boxes, @ByVal Input box_ind,
                @ByVal Input crop_size, @Const @ByRef Attrs attrs);
  public native @ByVal @Name("operator tensorflow::Output") Output asOutput();
  public native @ByVal @Name("operator tensorflow::Input") Input asInput();
  public native Node node();

  public static native @ByVal Attrs Method(@StringPiece BytePointer x);
  public static native @ByVal Attrs Method(@StringPiece String x);
  public static native @ByVal Attrs ExtrapolationValue(float x);

  public native @ByRef Operation operation(); public native CropAndResize operation(Operation setter);
  public native @ByRef Output crops(); public native CropAndResize crops(Output setter);
}
